/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test.repl;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.mapreduce.test.repl.TestRepl;
import com.mapr.db.mapreduce.tools.DiffTablesWithCrc;
import com.mapr.db.tests.utils.DBTests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossClusterDiffTablesVerification {
    private static final Logger _logger = LoggerFactory.getLogger(CrossClusterDiffTablesVerification.class);
    private static final String SRC_CLUSTER_PATH = "/mapr/cluster1";
    private static final String DST_CLUSTER_PATH = "/mapr/cluster2";
    private static final String SRC_TABLE_NAME = "/srctable";
    private static final String DST_TABLE_NAME = "/dsttable";
    private static final String SRC_TABLE_PATH = "/mapr/cluster1/srctable";
    private static final String DST_TABLE_PATH = "/mapr/cluster2/dsttable";
    private static final String DIFF_TABLE_OUT_DIR = "/tmp/difftables";

    @Before
    public void startupBeforeTest() throws IOException {
        System.out.println("WARNING: Tests in CrossClusterDiffTablesVerification require pre-test manual setup between two M7 clusters with names \"cluster1\" and \"cluster2\" and both should have MapReduce with mapr-resourcemanager and mapr-gateway installed.");
    }

    @After
    public void cleanupAfter() throws IOException {
        if (MapRDBImpl.tableExists((String)SRC_TABLE_PATH)) {
            MapRDBImpl.deleteTable((String)SRC_TABLE_PATH);
        }
        if (MapRDBImpl.tableExists((String)DST_TABLE_PATH)) {
            MapRDBImpl.deleteTable((String)DST_TABLE_PATH);
        }
    }

    public static void compareTablesWithCRC(String srcTable, String dstTable, boolean expectedPass, String columns, boolean cmpmeta) throws Exception {
        String outdir = DIFF_TABLE_OUT_DIR;
        TestRepl.rmDir(outdir);
        String[] diffCrcCmd = new String[]{"-src", srcTable, "-dst", dstTable, "-outdir", outdir, "-mapreduce", "true", "-cmpmeta", cmpmeta ? "true" : "false"};
        ArrayList<String> diffCmdList = new ArrayList<String>(Arrays.asList(diffCrcCmd));
        if (columns != null) {
            diffCmdList.add("-columns");
            diffCmdList.add(columns);
        }
        int ret = ToolRunner.run(null, (Tool)new DiffTablesWithCrc(), (String[])diffCmdList.toArray(diffCrcCmd));
        if (expectedPass) {
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    @Test
    public void CrossClusterReplicateAndCompare() throws Exception, IOException, InterruptedException {
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y", (Object)"cf3", (Object)"c.d");
        _logger.info("Creating source and destination tables...");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_CLUSTER_PATH, (String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_CLUSTER_PATH, (String)DST_TABLE_NAME, (Map)dstMap);
        _logger.info("Source = " + srcTable.getPath().toString() + "\nReplica = " + dstTable.getPath().toString());
        String replPaths = "a.b.c,x.y.z,x.y,a.c.d,a.m";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        _logger.info("Set up replication ...");
        String listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        Document listDoc = MapRDBImpl.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        String replColumns = listDoc.getString("data[0].Columns");
        Assert.assertNotNull((Object)replColumns);
        Document doc = MapRDBImpl.newDocument();
        doc.set("a.b.c", "abc").set("a.b.d", "abd").set("x.y.z", "xyz").set("x.y.w", "xyw").setArray("x.y.a", new Object[]{"One", 2, "Three"}).set("a.m", "am").set("c.d.e", "cde");
        _logger.info("Inserting records ...");
        srcTable.insert("key1", doc);
        srcTable.flush();
        Thread.sleep(10000L);
        _logger.info("Comparing source and replica tables ...");
        CrossClusterDiffTablesVerification.compareTablesWithCRC(srcTable.getPath().toString(), dstTable.getPath().toString(), true, replPaths, false);
        Document readDoc = dstTable.findById("key1");
        Assert.assertEquals((Object)"abc", (Object)readDoc.getString("a.b.c"));
        Assert.assertEquals((Object)"xyz", (Object)readDoc.getString("x.y.z"));
        Assert.assertEquals((Object)"xyw", (Object)readDoc.getString("x.y.w"));
        Assert.assertEquals((Object)Value.Type.ARRAY, (Object)readDoc.getValue("x.y.a").getType());
        Assert.assertEquals((Object)"One", (Object)readDoc.getString("x.y.a[0]"));
        Assert.assertEquals((long)2L, (long)readDoc.getInt("x.y.a[1]"));
        Assert.assertEquals((Object)"Three", (Object)readDoc.getString("x.y.a[2]"));
        Assert.assertEquals((Object)"am", (Object)readDoc.getString("a.m"));
        Assert.assertNull((Object)readDoc.getString("a.b.d"));
        Assert.assertNull((Object)readDoc.getString("c.d.e"));
        Assert.assertNull((Object)readDoc.getString("a.c.d"));
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b", "ab");
        srcTable.update("key1", mut);
        srcTable.flush();
        Thread.sleep(10000L);
        CrossClusterDiffTablesVerification.compareTablesWithCRC(srcTable.getPath().toString(), dstTable.getPath().toString(), true, replPaths, false);
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("a.b.d"));
        Assert.assertNull((Object)readDoc.getValue("a.b"));
        Assert.assertEquals((Object)"xyz", (Object)readDoc.getString("x.y.z"));
        Assert.assertEquals((Object)"xyw", (Object)readDoc.getString("x.y.w"));
        Assert.assertEquals((Object)Value.Type.ARRAY, (Object)readDoc.getValue("x.y.a").getType());
        Assert.assertEquals((Object)"One", (Object)readDoc.getString("x.y.a[0]"));
        Assert.assertEquals((long)2L, (long)readDoc.getInt("x.y.a[1]"));
        Assert.assertEquals((Object)"Three", (Object)readDoc.getString("x.y.a[2]"));
        Assert.assertEquals((Object)"am", (Object)readDoc.getString("a.m"));
        mut.empty();
        mut.delete("a.m").setOrReplace("x.y", "xy").setOrReplace("a.c.d.f", "acdf").setOrReplace("a.c.dd.f", "acddf");
        srcTable.update("key1", mut);
        srcTable.flush();
        Thread.sleep(10000L);
        CrossClusterDiffTablesVerification.compareTablesWithCRC(srcTable.getPath().toString(), dstTable.getPath().toString(), true, replPaths, false);
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("a.b.d"));
        Assert.assertNull((Object)readDoc.getValue("a.b"));
        Assert.assertNull((Object)readDoc.getValue("x.y.z"));
        Assert.assertNull((Object)readDoc.getValue("x.y.w"));
        Assert.assertNull((Object)readDoc.getValue("a.c.dd.f"));
        Assert.assertNull((Object)readDoc.getValue("a.m"));
        Assert.assertEquals((Object)"xy", (Object)readDoc.getString("x.y"));
        Assert.assertEquals((Object)"acdf", (Object)readDoc.getString("a.c.d.f"));
        mut.empty();
        mut.delete("x.y");
        srcTable.update("key1", mut);
        srcTable.flush();
        Thread.sleep(10000L);
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("x.y"));
        Assert.assertEquals((Object)"acdf", (Object)readDoc.getString("a.c.d.f"));
        CrossClusterDiffTablesVerification.compareTablesWithCRC(srcTable.getPath().toString(), dstTable.getPath().toString(), true, replPaths, false);
        srcTable.delete("key1");
        srcTable.flush();
        Thread.sleep(10000L);
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc);
        CrossClusterDiffTablesVerification.compareTablesWithCRC(srcTable.getPath().toString(), dstTable.getPath().toString(), true, replPaths, false);
    }
}

