/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tools;

import com.mapr.db.mapreduce.tools.DiffTablesWithCrc;
import com.mapr.fs.MapRFileSystem;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffStreamsWithCrc
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(DiffStreamsWithCrc.class);
    private static final String NAME = "DiffStreamsWithCrc";

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: DiffStreamsWithCrc\n  -src <source stream path>]\n  -dst <destination stream path>\n  -outdir <output directory>\n  [-first_exit] Exit when first difference is found\n");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        MapRFileSystem mfs;
        String[] cmdArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        String srcPath = null;
        String dstPath = null;
        String outDir = null;
        for (int i = 0; i < cmdArgs.length; ++i) {
            if (cmdArgs[i].equalsIgnoreCase("-src")) {
                srcPath = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-dst")) {
                dstPath = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-outdir")) {
                outDir = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-first_exit")) continue;
            this.Usage("Unknown option " + cmdArgs[i]);
        }
        if (srcPath == null || dstPath == null) {
            this.Usage("missing -src or -dst stream");
        }
        if (outDir == null) {
            this.Usage("missing -outdir");
        }
        if (!(mfs = (MapRFileSystem)FileSystem.get((Configuration)new Configuration())).isStream(new Path(srcPath))) {
            this.Usage("src " + srcPath + " is not a stream");
        }
        if (!mfs.isStream(new Path(dstPath))) {
            this.Usage("dst " + dstPath + " is not a stream");
        }
        int numDiffTableArgs = args.length;
        String[] diffTablesArgs = Arrays.copyOf(args, numDiffTableArgs);
        return ToolRunner.run((Configuration)this.getConf(), (Tool)new DiffTablesWithCrc(), (String[])diffTablesArgs);
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new DiffStreamsWithCrc(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

