/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.index.tools;

import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.mapreduce.tools.impl.FailureTracker;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyIndex
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyIndex.class);
    public static final String NAME = "verifyindex";
    String PriPath;
    Table priTable = null;
    String IndexName;
    String IndexFid;
    Table indexTable = null;
    int defaultNumThreads = 16;
    int numThreads = 0;
    String[] indexedFields = null;
    boolean exitOnFirstDiff;
    static final String priPathConf = "maprdb.mapreduce.inputtable";
    static final String indexNameConf = "indexNameconf";
    static final String exitOnFirstDiffConf = "exitonfirstdiffconf";

    public static String getOpsForTableName(String table) {
        return "OpsForTable_" + table;
    }

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        boolean ret = false;
        Configuration conf = this.getConf();
        this.setupConfParmas(conf);
        DoVerifyIndex dowork = new DoVerifyIndex();
        return dowork.runVerify();
    }

    private void setupConfParmas(Configuration conf) {
        conf.set(priPathConf, this.PriPath);
        conf.set(indexNameConf, this.IndexName);
        conf.setBoolean(exitOnFirstDiffConf, this.exitOnFirstDiff);
    }

    public void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                VerifyIndex.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-path")) {
                this.PriPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-index")) {
                this.IndexName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-first_exit")) {
                this.exitOnFirstDiff = true;
                continue;
            }
            VerifyIndex.Usage(null);
        }
        if (this.PriPath == null || this.IndexName == null) {
            VerifyIndex.Usage("missing table path or index name.");
        }
        if (this.numThreads == 0) {
            this.numThreads = this.defaultNumThreads;
        }
        Configuration conf = new Configuration();
        MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)conf);
        Admin admin = MapRDBImpl.newAdmin((Configuration)conf);
        Path priPath = new Path(this.PriPath);
        if (!mfs.exists(priPath)) {
            VerifyIndex.Usage("table: " + priPath + " does not exist");
        }
        if (!mfs.isJsonTable(priPath)) {
            VerifyIndex.Usage("table: " + priPath + " is not a JSON table. This tool only supports JSON tables");
        }
        Collection tableIndexList = admin.getTableIndexes(priPath);
        boolean isIndexFind = false;
        for (IndexDesc rd : tableIndexList) {
            if (!rd.getIndexName().equals(this.IndexName)) continue;
            this.IndexFid = rd.getIndexFid();
            List indexFields = rd.getIndexedFields();
            Collection nonindexFields = rd.getCoveredFields();
            ArrayList FieldList = new ArrayList();
            FieldList.addAll(indexFields);
            FieldList.addAll(nonindexFields);
            ArrayList<String> indexedFields = new ArrayList<String>();
            for (IndexFieldDesc id : FieldList) {
                List famattr = mfs.listColumnFamily(new Path(this.PriPath), false);
                Map cfQual = MapRDBTableImplHelper.getOneCFQualifier((FieldPath)id.getFieldPath(), (Map)MapRDBTableImplHelper.getCFIdPathMap((List)famattr), (boolean)false);
                Integer[] cfIdSet = cfQual.keySet().toArray(new Integer[1]);
                for (Dbserver.ColumnFamilyAttr cf : famattr) {
                    if (cf.getSchFamily().getId() != cfIdSet[0].intValue()) continue;
                    indexedFields.add(MapRDBTableImplHelper.cfQualifierToJsonPath((String)cf.getSchFamily().getName(), (String)((FieldPath)cfQual.get(cfIdSet[0])).asPathString(), (List)famattr).toString());
                }
            }
            this.indexedFields = indexedFields.toArray(new String[indexedFields.size()]);
            isIndexFind = true;
            this.indexTable = MapRDBImpl.getIndexTable((IndexDesc)rd);
        }
        if (!isIndexFind) {
            VerifyIndex.Usage("Index: " + this.IndexName + " is not a valid index of table " + this.PriPath);
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: verifyindex -path <table path> -index <index name>\n[-first_exit] Exit when first difference is found.\n[-numthreads <numThreads> (default:16)]\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new VerifyIndex(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private class DoVerifyIndex
    implements FailureTracker {
        private final Logger logger = LoggerFactory.getLogger(DoVerifyIndex.class);

        private DoVerifyIndex() {
        }

        public int runVerify() throws Exception {
            int i;
            VerifyIndex.this.priTable = MapRDBImpl.getTable((String)VerifyIndex.this.PriPath);
            TabletInfo[] tablets = VerifyIndex.this.priTable.getTabletInfos();
            TabletInfo[] itablets = VerifyIndex.this.indexTable.getTabletInfos();
            ExecutorService executor = Executors.newFixedThreadPool(VerifyIndex.this.numThreads);
            VerifyThread[] threads = tablets.length > itablets.length ? new VerifyThread[tablets.length] : new VerifyThread[itablets.length];
            VerifyIndexCounter c = new VerifyIndexCounter();
            for (int i2 = 0; i2 < tablets.length; ++i2) {
                threads[i2] = new VerifyThread(tablets[i2].getCondition(), c, true);
                executor.execute(threads[i2]);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            ExecutorService executor2 = Executors.newFixedThreadPool(VerifyIndex.this.numThreads);
            for (i = 0; i < threads.length; ++i) {
                if (threads[i].isCompleted()) continue;
                this.logger.error("Thread '{}' didnot finish successfully. Exiting...", (Object)i);
                System.exit(-1);
            }
            for (i = 0; i < itablets.length; ++i) {
                threads[i] = new VerifyThread(itablets[i].getCondition(), c, false);
                executor2.execute(threads[i]);
            }
            executor2.shutdown();
            while (!executor2.isTerminated()) {
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i].isCompleted()) continue;
                this.logger.error("Thread '{}' did not finish successfully. Exiting...", (Object)i);
                System.exit(-1);
            }
            if (VerifyIndex.this.exitOnFirstDiff) {
                System.out.println("Exiting after finding first mismatch");
            } else {
                System.out.println("Number of rows in table but not in index: " + c.getMissInIndex());
                System.out.println("Number of rows in index but not in table: " + c.getMissInPrimary());
                System.out.println("Mismatch row count: " + c.getMissMatch());
            }
            return -1;
        }

        @Override
        public void notifyMismatch() {
        }

        @Override
        public boolean shouldExit() {
            return VerifyIndex.this.exitOnFirstDiff;
        }

        class VerifyThread
        implements Runnable {
            private boolean completed = false;
            Iterator<Document> itr = null;
            VerifyIndexCounter vic = null;
            boolean ScanPri = false;

            public boolean isCompleted() {
                return this.completed;
            }

            public VerifyThread(QueryCondition qcond, VerifyIndexCounter vc, boolean direction) throws Exception {
                this.itr = direction ? VerifyIndex.this.priTable.find(qcond, VerifyIndex.this.indexedFields).iterator() : VerifyIndex.this.indexTable.find().iterator();
                this.vic = vc;
                this.ScanPri = direction;
            }

            @Override
            public void run() {
                Document siDoc = null;
                Document priDoc = null;
                if (this.ScanPri) {
                    while (this.itr.hasNext()) {
                        priDoc = this.itr.next();
                        if (priDoc.size() == 1) continue;
                        DocumentStream sistream = VerifyIndex.this.indexTable.find();
                        Iterator siitr = sistream.iterator();
                        boolean find = false;
                        while (siitr.hasNext()) {
                            siDoc = (Document)siitr.next();
                            if (!priDoc.getIdString().equals(siDoc.getIdString())) continue;
                            if (siDoc.equals(priDoc)) {
                                find = true;
                                break;
                            }
                            this.vic.incMissMatch();
                            System.out.println("Mismatch Document Found!!\nTable side-->" + priDoc + "\nIndex side-->" + siDoc);
                            if (!VerifyIndex.this.exitOnFirstDiff) continue;
                            this.completed = true;
                            return;
                        }
                        if (siitr.hasNext() || find) continue;
                        this.vic.incMissInIndex();
                        System.out.println("Missing Document in Index:\n" + priDoc + "\n");
                        if (!VerifyIndex.this.exitOnFirstDiff) continue;
                        this.completed = true;
                        return;
                    }
                } else {
                    while (this.itr.hasNext()) {
                        siDoc = this.itr.next();
                        priDoc = VerifyIndex.this.priTable.findById(siDoc.getIdString(), VerifyIndex.this.indexedFields);
                        if (priDoc != null) continue;
                        this.vic.incMissInPrimay();
                        System.out.println("Unknown Document in Index:\n" + siDoc + "\n");
                        if (!VerifyIndex.this.exitOnFirstDiff) continue;
                        this.completed = true;
                        return;
                    }
                }
                this.completed = true;
            }
        }
    }

    class VerifyIndexCounter {
        int missInPrimary = 0;
        int missInIndex = 0;
        int missMatch = 0;

        VerifyIndexCounter() {
        }

        int getMissInPrimary() {
            return this.missInPrimary;
        }

        void incMissInPrimay() {
            ++this.missInPrimary;
        }

        int getMissInIndex() {
            return this.missInIndex;
        }

        void incMissInIndex() {
            ++this.missInIndex;
        }

        int getMissMatch() {
            return this.missMatch;
        }

        void incMissMatch() {
            ++this.missMatch;
        }
    }

    public static enum COUNTERS {
        NUM_ROWS_MISSING_IN_PRIMARY,
        NUM_ROWS_MISSING_IN_INDEX,
        NUM_ROWS_MISMATCH;

    }
}

