/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.mapreduce.BulkLoadOutputFormat;
import com.mapr.db.mapreduce.BulkLoadRecordWriter;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.TableOutputFormat;
import com.mapr.db.mapreduce.impl.JsonImportMapper;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.mapreduce.impl.MarlinSplitter;
import com.mapr.db.mapreduce.impl.TableSplit;
import com.mapr.db.mapreduce.tools.DiffTablesMeta;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.IdValueComparator;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTable
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CopyTable.class);
    private static final String NAME = "CopyTable";
    public static final String TABLE_NAME = "import.table.name";
    private static String srcPath;
    private static String dstPath;
    private static boolean bulkLoad;
    private static boolean mapreduce;
    private static boolean isSuccess;
    private static boolean preserveTimestamps;
    private static boolean keepDeletes;
    private static boolean cmpMeta;
    private static boolean excludeEmbeddedCF;
    private static boolean isMarlin;
    private static boolean readAllCfs;
    private static String columnSpec;
    private static String startRow;
    private static String stopRow;
    private int numThreads = 16;

    private Job createSubmittableJob(String[] otherArgs) throws IOException {
        Job job = new Job(this.getConf(), "CopyTable_" + srcPath);
        job.setJarByClass(CopyTable.class);
        Configuration conf = job.getConfiguration();
        conf.set("maprdb.mapreduce.inputtable", srcPath);
        conf.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        conf.setBoolean("preserve.ts", preserveTimestamps);
        conf.setBoolean("maprdb.table.impl.get_deletes", keepDeletes);
        conf.setBoolean("maprdb.table.impl.decompress", false);
        conf.setBoolean("maprdb.exclude.embedded", excludeEmbeddedCF);
        conf.setBoolean("maprdb.read.all.cfs", readAllCfs);
        conf.setBoolean("BUFFERWRITE", false);
        if (startRow != null) {
            conf.set("maprdb.mapreduce.getall.startrow", startRow);
        }
        if (stopRow != null) {
            conf.set("maprdb.mapreduce.getall.stoprow", stopRow);
        }
        if (columnSpec != null) {
            conf.set("maprdb.mapreduce.fieldpath", columnSpec);
        }
        job.setInputFormatClass(TableInputFormat.class);
        job.setSpeculativeExecution(false);
        conf.set(TABLE_NAME, dstPath);
        job.setMapperClass(JsonImportMapper.class);
        MapReduceUtilMethods.setStartStopRow((Configuration)conf);
        job.setOutputKeyClass(KeyValue.class);
        job.setSortComparatorClass(IdValueComparator.class);
        job.setOutputValueClass(DBDocumentImpl.class);
        this.setupCopyTableSource();
        this.setupCopyTableDestination();
        if (!bulkLoad) {
            job.setOutputFormatClass(TableOutputFormat.class);
            conf.set("maprdb.mapred.outputtable", dstPath);
        } else {
            job.setOutputFormatClass(BulkLoadOutputFormat.class);
            conf.set("MapRDBImpl.mapreduce.bulkloadrecordwriter.outputTable", dstPath);
        }
        job.setNumReduceTasks(0);
        return job;
    }

    private void createTableForCopy(Admin maprAdmin, String dstPath, String srcPath) throws IOException {
        TableDescriptor dstTableDesc = maprAdmin.getTableDescriptor(srcPath);
        dstTableDesc.setPath(dstPath);
        dstTableDesc.setBulkLoad(bulkLoad);
        Table srcTable = MapRDBImpl.getTable((String)srcPath);
        TabletInfo[] tabletInfos = srcTable.getTabletInfos();
        ArrayList<KeyValue> startKeys = new ArrayList<KeyValue>(tabletInfos.length);
        boolean isFirst = true;
        for (TabletInfo ti : tabletInfos) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            List range = ((ConditionImpl)ti.getCondition()).getRowkeyRanges();
            startKeys.add(IdCodec.decode((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        }
        Value[] splits = null;
        if (startKeys.size() > 0) {
            splits = startKeys.toArray(new Value[startKeys.size()]);
        }
        ((AdminImpl)maprAdmin).createTable(dstTableDesc, splits);
    }

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: CopyTable [Options] -src <source table path> -dst <destination table path>\nOptions:\n[-fromID <start key>]\n[-toID <end key>]\n[-columns <JSON Fieldpaths specified as \"path1,...,pathN\">]\n[-bulkload <true|false> (default: false)]\n[-mapreduce <true|false> (default: true)]\n[-cmpmeta <true|false> (default: true)]\n[-numthreads <number of threads> (default: 16)");
        System.exit(1);
    }

    private void ParseArgs(String[] args) throws Exception {
        Path sPath;
        MapRFileSystem mfs;
        ArrayList<String> cmpArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                cmpArgs.add(args[i]);
                srcPath = args[++i];
                cmpArgs.add(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                cmpArgs.add(args[i]);
                dstPath = args[++i];
                cmpArgs.add(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-bulkload")) {
                boolean bulkLoadFlag;
                if (!MapReduceUtilMethods.checkBulkloadStatus((boolean)(bulkLoadFlag = Boolean.valueOf(args[++i]).booleanValue()), (String)dstPath)) {
                    this.Usage("Table " + dstPath + " is in bulkload mode and can't work with bulkload = false option.");
                }
                bulkLoad = bulkLoadFlag;
                continue;
            }
            if (args[i].equalsIgnoreCase("-startRow")) {
                startRow = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-stopRow")) {
                stopRow = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-preserve_ts")) {
                preserveTimestamps = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmpmeta")) {
                cmpMeta = Boolean.valueOf(args[++i]);
                continue;
            }
            this.Usage(null);
        }
        if (srcPath == null || dstPath == null) {
            this.Usage("missing -src or -dst.");
        }
        if (startRow != null && stopRow != null && startRow.compareTo(stopRow) < 0) {
            this.Usage("stopRow is smaller than startRow.");
        }
        Admin admin = MapRDBImpl.newAdmin();
        if (preserveTimestamps) {
            if (admin.tableExists(dstPath) && cmpMeta) {
                cmpArgs.add("-columns");
                cmpArgs.add("-Aces");
                int ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new DiffTablesMeta(false), (String[])cmpArgs.toArray(new String[cmpArgs.size()]));
                if (ret == 0) {
                    LOG.info("Metadata of the two tables matches.");
                } else if (ret == 1) {
                    throw new Exception("Metadata of " + srcPath + " and " + dstPath + " is different.");
                }
            }
        } else {
            keepDeletes = false;
        }
        if (!(mfs = (MapRFileSystem)FileSystem.get((Configuration)new Configuration())).exists(sPath = new Path(srcPath))) {
            this.Usage(sPath + " does not exist");
        }
        if (!mfs.isJsonTable(sPath)) {
            this.Usage(sPath + " is not a JSON table. This tool only supports JSON tables");
        }
        columnSpec = MapReduceUtilMethods.processColumnSpec((String)columnSpec, (String)srcPath);
        LOG.info("Copying {} column families from {} to {}.", new Object[]{columnSpec != null ? columnSpec : "all", srcPath, dstPath});
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(srcPath);
        if (desc.isStream()) {
            excludeEmbeddedCF = true;
            isMarlin = true;
        }
        if (admin.tableExists(dstPath)) {
            TableDescriptorImpl destDesc = (TableDescriptorImpl)admin.getTableDescriptor(dstPath);
            if (!bulkLoad && destDesc.isBulkLoad()) {
                LOG.info("Default bulkload is false...setting it to true");
                bulkLoad = true;
            }
        }
    }

    private void setupCopyTableSource() throws IOException {
        Admin maprAdmin = MapRDBImpl.newAdmin();
        if (((TableDescriptorImpl)maprAdmin.getTableDescriptor(srcPath)).isStream()) {
            bulkLoad = false;
        }
    }

    private void setupCopyTableDestination() throws IOException {
        Admin maprAdmin = MapRDBImpl.newAdmin();
        if (!maprAdmin.tableExists(dstPath)) {
            this.createTableForCopy(maprAdmin, dstPath, srcPath);
        }
    }

    private void Cleanup() throws IOException {
        Admin maprAdmin = MapRDBImpl.newAdmin();
        TableDescriptor dstTableDesc = maprAdmin.getTableDescriptor(dstPath);
        if (dstTableDesc.isBulkLoad()) {
            dstTableDesc.setBulkLoad(false);
            maprAdmin.alterTable(dstTableDesc);
        }
    }

    private int run_NoMR(String[] args) throws IOException, Exception {
        Configuration config = this.getConf();
        config.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        config.setBoolean("maprdb.table.impl.get_deletes", keepDeletes);
        config.setBoolean("maprdb.table.impl.exclude_embeddedfamily", excludeEmbeddedCF);
        config.setBoolean("maprdb.table.impl.decompress", false);
        config.setBoolean("BUFFERWRITE", true);
        config.setBoolean("maprdb.table.impl.read_all_cfs", readAllCfs);
        this.setupCopyTableSource();
        this.setupCopyTableDestination();
        Table srcTable = MapRDBImpl.getTable((String)srcPath);
        TabletInfo[] tabletInfos = srcTable.getTabletInfos();
        if (isMarlin) {
            List splits = MarlinSplitter.getMarlinSplits((String)srcTable.getName(), (TabletInfo[])tabletInfos);
            tabletInfos = new TabletInfo[splits.size()];
            int index = 0;
            for (InputSplit split : splits) {
                TableSplit thisSplit = (TableSplit)split;
                tabletInfos[index] = new TabletInfoImpl(thisSplit.getCondition(), thisSplit.getLocations(), thisSplit.getLength(), 0L);
                ++index;
            }
        }
        srcTable.close();
        int numSplits = tabletInfos.length;
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (int i = 0; i < numSplits; ++i) {
            Future<Integer> f = executor.submit(new LoaderThread(i, tabletInfos[i], config));
            futures.add(f);
        }
        int numFailures = 0;
        for (Future future : futures) {
            numFailures += ((Integer)future.get()).intValue();
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (numFailures == 0) {
            this.Cleanup();
        }
        return numFailures == 0 ? 0 : 1;
    }

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs.length < 2) {
            this.Usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        this.ParseArgs(otherArgs);
        if (!mapreduce) {
            return this.run_NoMR(otherArgs);
        }
        Job job = this.createSubmittableJob(otherArgs);
        job.submit();
        System.out.println("job_id: " + job.getJobID().toString());
        if (!job.waitForCompletion(true)) {
            LOG.error("CopyTable MapReduce job failed !!");
            return 1;
        }
        this.Cleanup();
        return 0;
    }

    public static boolean copy(final String[] args, String user) throws Exception {
        UserGroupInformation ugi = CopyTable.createUser(user);
        LOG.info("Running copytable job " + mapreduce + " as user: " + user);
        if (!mapreduce) {
            System.out.println("No map-reduce");
        }
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
                    if (status == 0) {
                        CopyTable.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while running copytable job: " + e);
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    static {
        bulkLoad = false;
        mapreduce = true;
        isSuccess = false;
        preserveTimestamps = true;
        keepDeletes = true;
        cmpMeta = true;
        excludeEmbeddedCF = false;
        isMarlin = false;
        readAllCfs = false;
        columnSpec = null;
        startRow = null;
        stopRow = null;
    }

    class LoaderThread
    extends BaseLoaderThread {
        LoaderThread(int id, TabletInfo t, Configuration config) {
            super(id, t, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() {
            BulkLoadRecordWriter writer = null;
            QueryCondition c = this.tabletInfo.getCondition();
            MapRDBTableImpl srcTable = null;
            MapRDBTableImpl destTable = null;
            try {
                srcTable = (MapRDBTableImpl)MapRDBImpl.getTable((Configuration)this.config, (Path)new Path(srcPath));
                DocumentStream rs = null;
                rs = columnSpec != null ? srcTable.find(c, columnSpec.split(",", -1)) : srcTable.find(c);
                Iterator iterator = rs.iterator();
                if (bulkLoad) {
                    writer = new BulkLoadRecordWriter(CopyTable.this.getConf(), new Path(dstPath));
                    while (iterator.hasNext()) {
                        Document r = (Document)iterator.next();
                        writer.write((Object)r.getId(), (Object)r);
                    }
                    writer.close(null);
                } else {
                    destTable = (MapRDBTableImpl)MapRDBImpl.getTable((Configuration)this.config, (Path)new Path(dstPath));
                    while (iterator.hasNext()) {
                        Document r = (Document)iterator.next();
                        destTable.insertOrReplace(r.getId(), r);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("CopyTable encountered an exception: " + e.getMessage());
                e.printStackTrace();
                Integer n = 1;
                return n;
            }
            finally {
                try {
                    if (srcTable != null) {
                        srcTable.close();
                    }
                    if (destTable != null) {
                        destTable.flush();
                        destTable.close();
                    }
                }
                catch (Exception e) {
                    LOG.error("CopyTable encountered an exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            return 0;
        }
    }

    abstract class BaseLoaderThread
    implements Callable<Integer> {
        protected TabletInfo tabletInfo;
        protected int myid;
        protected Configuration config;

        protected BaseLoaderThread(int id, TabletInfo t, Configuration config) {
            this.myid = id;
            this.tabletInfo = t;
            this.config = config;
        }
    }
}

