/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.ClusterTablePath;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.mapreduce.tools.DiffTablesMeta;
import com.mapr.db.mapreduce.tools.impl.RangeChecksum;
import com.mapr.fs.MapRFileSystem;
import com.mapr.security.JNISecurity;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DiffTablesWithCrc
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DiffTablesWithCrc.class);
    public final int NumThreads = 16;
    public static final String NAME = "Difftableswithcrc";
    public static final String SrcChecksumJobNAME = "DiffTablesComputeSrcChecksum";
    public static final String DstChecksumJobNAME = "DiffTablesComputeDstChecksum";
    public static String outputDir = null;
    public static String outputDiffCrcDir = null;
    public static String outputFileLocation = null;
    static String srcTableName = null;
    static String dstTableName = null;
    static ClusterTablePath outputDirCTPath = null;
    static ClusterTablePath srcCTPath = null;
    static ClusterTablePath dstCTPath = null;
    static String columnSpec = null;
    static boolean excludedEmbeddedFamily = false;
    static boolean exitOnFirstDiff = false;
    static String inputRegionKeyFile = null;
    static String inputSubRegionKeyFile = null;
    static boolean cmpMeta = true;
    static List<ByteBufWritableComparable> mismatchedStartKeys = null;

    public static void compareChecksum(String srcFileUri, String dstFileUri, String mismatchedFile) throws IOException {
        Configuration srcConf = new Configuration();
        Configuration dstConf = new Configuration();
        Configuration localConf = new Configuration();
        Path srcPath = new Path(srcFileUri);
        Path dstPath = new Path(dstFileUri);
        SequenceFile.Reader srcReader = new SequenceFile.Reader(srcConf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)srcPath)});
        SequenceFile.Reader dstReader = new SequenceFile.Reader(dstConf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)dstPath)});
        Path mismatchedFilePath = new Path(mismatchedFile);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)localConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)mismatchedFilePath), SequenceFile.Writer.keyClass(ByteBufWritableComparable.class), SequenceFile.Writer.valueClass(NullWritable.class)});
        ByteBufWritableComparable srcKey = new ByteBufWritableComparable();
        LongWritable srcVal = new LongWritable();
        ByteBufWritableComparable dstKey = new ByteBufWritableComparable();
        LongWritable dstVal = new LongWritable();
        boolean srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
        boolean dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
        while (srcHasNext && dstHasNext) {
            int cmpret = srcKey.compareTo(dstKey);
            if (cmpret < 0) {
                LOG.debug((Object)(srcFileUri + " has an extra key range with start key (" + srcKey.toString() + ")"));
                writer.append((Writable)srcKey, (Writable)NullWritable.get());
                srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
                continue;
            }
            if (cmpret > 0) {
                LOG.debug((Object)(dstFileUri + " has an extra key range with start key (" + dstKey.toString() + ")"));
                writer.append((Writable)dstKey, (Writable)NullWritable.get());
                dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
                continue;
            }
            if (!srcVal.equals((Object)dstVal)) {
                LOG.debug((Object)(dstFileUri + " checksum(" + srcVal.toString() + ") and " + srcFileUri + "  checksum(" + dstVal.toString() + ") are different for range start key (" + srcKey.toString() + ")"));
                writer.append((Writable)srcKey, (Writable)NullWritable.get());
            }
            srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
            dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
        }
        while (srcHasNext) {
            LOG.debug((Object)(srcFileUri + " has an extra key range with start key " + srcKey.toString()));
            writer.append((Writable)srcKey, (Writable)NullWritable.get());
            srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
        }
        while (dstHasNext) {
            LOG.debug((Object)(dstFileUri + " has an extra key range with start key " + dstKey.toString()));
            writer.append((Writable)dstKey, (Writable)NullWritable.get());
            dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
        }
        writer.close();
        srcReader.close();
        dstReader.close();
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length <= 0) {
            DiffTablesWithCrc.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equalsIgnoreCase("-h") || cmd.startsWith("--h")) {
                    DiffTablesWithCrc.printUsage(null);
                    return false;
                }
                if (cmd.equalsIgnoreCase("-src")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    srcTableName = args[++i];
                    srcCTPath = ClusterTablePath.parse((String)srcTableName);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-dst")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    dstTableName = args[++i];
                    dstCTPath = ClusterTablePath.parse((String)dstTableName);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-columns")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    columnSpec = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-exclude_embedded_families")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    excludedEmbeddedFamily = Boolean.valueOf(args[++i]);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-outdir")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    outputDir = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-first_exit")) {
                    exitOnFirstDiff = true;
                    continue;
                }
                if (cmd.equalsIgnoreCase("-useRegionKeyFile")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    inputRegionKeyFile = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-useSubRegionKeyFile")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    inputSubRegionKeyFile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-mapreduce")) {
                    String isMapreduce;
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    if (!(isMapreduce = args[++i]).equalsIgnoreCase("false")) continue;
                    DiffTablesWithCrc.printUsage("Non-mapreduce version is not supported.");
                    return false;
                }
                if (args[i].equalsIgnoreCase("-cmpmeta")) {
                    cmpMeta = Boolean.valueOf(args[++i]);
                    continue;
                }
                DiffTablesWithCrc.printUsage("unrecognized argument " + args[i]);
                return false;
            }
            if (srcTableName == null) {
                DiffTablesWithCrc.printUsage("Missing -src.");
                return false;
            }
            if (dstTableName == null) {
                DiffTablesWithCrc.printUsage("Missing -dst.");
                return false;
            }
            Configuration conf = new Configuration();
            MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)conf);
            Path srcPath = new Path(srcTableName);
            Path dstPath = new Path(dstTableName);
            if (!mfs.exists(srcPath)) {
                DiffTablesWithCrc.printUsage(srcPath + " does not exist");
                return false;
            }
            if (!mfs.isJsonTable(srcPath)) {
                DiffTablesWithCrc.printUsage(srcPath + " is not a JSON table. This tool only supports JSON tables");
                return false;
            }
            if (!mfs.exists(dstPath)) {
                DiffTablesWithCrc.printUsage(dstPath + " does not exist");
                return false;
            }
            if (!mfs.isJsonTable(dstPath)) {
                DiffTablesWithCrc.printUsage(dstPath + " is not a JSON table. This tool only supports JSON tables");
                return false;
            }
            if (ClusterTablePath.equal((ClusterTablePath)srcCTPath, (ClusterTablePath)dstCTPath)) {
                System.out.println("The tables match. " + srcTableName + " and " + dstTableName + " are the same table.");
                System.exit(0);
            }
            if (outputDir == null) {
                DiffTablesWithCrc.printUsage("Missing -outdir");
                return false;
            }
            if (!outputDir.endsWith("/")) {
                outputDir = outputDir + "/";
            }
            if (DiffTableUtils.checkPathExists((Configuration)conf, (ClusterTablePath)(outputDirCTPath = ClusterTablePath.parse((String)outputDir)))) {
                DiffTablesWithCrc.printUsage("Output directory " + outputDir + " already exists");
                return false;
            }
            outputDiffCrcDir = DiffTableUtils.getTmpDirName((Configuration)conf) + outputDir;
            columnSpec = MapReduceUtilMethods.processColumnSpec((String)columnSpec, (String)srcTableName);
            LOG.info((Object)("Comparing " + (columnSpec != null ? columnSpec : "all") + " column families from " + srcTableName + " to " + dstTableName));
            Admin admin = MapRDB.newAdmin();
            TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(srcTableName);
            if (desc.isStream()) {
                excludedEmbeddedFamily = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DiffTablesWithCrc.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkNextArg(String[] args, int i) {
        if (i + 1 >= args.length || args[i + 1].matches("-[cdefmnosu][a-zA-Z_]*")) {
            DiffTablesWithCrc.printUsage("Missing argument after " + args[i]);
            return false;
        }
        return true;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: maprdb difftableswithcrc\n-src <source table path>\n-dst <destination table path>\n-outdir <output directory>\n[-first_exit] Exit when first difference is found.\n[-columns <comma separated list of field paths> ]\n[-exclude_embedded_families <true|false>] (default: false)\n  Don't include the  other column families with path embedded in specified columns\n[-cmpmeta <true|false> (default: true)]\n");
    }

    public int run(String[] args) throws Exception {
        Job dstJob;
        Job srcJob;
        Path dstOutDiffCrcDirPath;
        FileSystem dstFs;
        Path srcOutDiffCrcDirPath;
        FileSystem srcFs;
        if (!DiffTablesWithCrc.doCommandLine(args)) {
            System.exit(-1);
        }
        int ret = 0;
        if (cmpMeta && (ret = this.compareMeta(args)) != 0) {
            return ret;
        }
        if (!cmpMeta) {
            System.out.println("Skip metadata check.");
        }
        Configuration conf = this.getConf();
        String srcTableNameWithoutSpecialChar = ((DiffTablesWithCrc.srcCTPath.clusterName == null ? "" : DiffTablesWithCrc.srcCTPath.clusterName) + DiffTablesWithCrc.srcCTPath.tablePathName).replace("/", "").replace(":", "");
        String dstTableNameWithoutSpecialChar = ((DiffTablesWithCrc.dstCTPath.clusterName == null ? "" : DiffTablesWithCrc.dstCTPath.clusterName) + DiffTablesWithCrc.dstCTPath.tablePathName).replace("/", "").replace(":", "");
        String srcOutDiffCrcDirName = srcCTPath.getClusterUri().toString() + outputDiffCrcDir;
        Configuration srcConf = new Configuration();
        String srcFullClusterName = srcCTPath.getClusterUri().toString();
        if (srcFullClusterName != null) {
            srcConf.set("fs.defaultFS", srcFullClusterName);
        }
        if ((srcFs = (srcOutDiffCrcDirPath = new Path(srcOutDiffCrcDirName)).getFileSystem(srcConf)).exists(srcOutDiffCrcDirPath)) {
            srcFs.delete(srcOutDiffCrcDirPath, true);
        }
        String srcKeyRangeDirName = new String(srcOutDiffCrcDirName + srcTableNameWithoutSpecialChar + ".keyrange/");
        String srcRegionKeyFilePathName = srcKeyRangeDirName + DiffTableUtils.getTabletKeyFileName((String)srcTableNameWithoutSpecialChar);
        String srcSubRegionKeyFilePathName = srcKeyRangeDirName + DiffTableUtils.getSegKeyFileName((String)srcTableNameWithoutSpecialChar);
        String dstOutDiffCrcDirName = dstCTPath.getClusterUri().toString() + outputDiffCrcDir;
        Configuration dstConf = new Configuration();
        String dstFullClusterName = dstCTPath.getClusterUri().toString();
        if (dstFullClusterName != null) {
            dstConf.set("fs.defaultFS", dstFullClusterName);
        }
        if ((dstFs = (dstOutDiffCrcDirPath = new Path(dstOutDiffCrcDirName)).getFileSystem(dstConf)).exists(dstOutDiffCrcDirPath)) {
            dstFs.delete(dstOutDiffCrcDirPath, true);
        }
        String dstKeyRangeDirName = new String(dstOutDiffCrcDirName + dstTableNameWithoutSpecialChar + ".keyrange/");
        String dstRegionKeyFilePathName = dstKeyRangeDirName + DiffTableUtils.getTabletKeyFileName((String)dstTableNameWithoutSpecialChar);
        String dstSubRegionKeyFilePathName = dstKeyRangeDirName + DiffTableUtils.getSegKeyFileName((String)dstTableNameWithoutSpecialChar);
        String diffTableOutDirPathName = outputDir;
        LOG.info((Object)("DiffTables output directory:" + diffTableOutDirPathName + "\nsrc side key range directory:" + srcKeyRangeDirName + ", mapper job split region file:" + srcRegionKeyFilePathName + ", checksum calculation subregion file:" + srcSubRegionKeyFilePathName + "\ndst side key range directory:" + dstKeyRangeDirName + ", mapper job split region file:" + dstRegionKeyFilePathName + ", checksum calculation subregion file:" + dstSubRegionKeyFilePathName));
        outputFileLocation = "DiffTables output are located at " + diffTableOutDirPathName + "\nsource table checksum output are located at " + srcOutDiffCrcDirName + "\ndestination table checksum output are located at " + dstOutDiffCrcDirName;
        if (inputRegionKeyFile != null) {
            DiffTableUtils.copyKeyRangeFile((Configuration)conf, (String)inputRegionKeyFile, (Configuration)conf, (String)srcRegionKeyFilePathName);
            DiffTableUtils.copyKeyRangeFile((Configuration)conf, (String)inputRegionKeyFile, (Configuration)conf, (String)dstRegionKeyFilePathName);
        } else {
            DiffTableUtils.writeTabletKeyRange((String)srcRegionKeyFilePathName, (String)srcTableName);
            DiffTableUtils.copyKeyRangeFile((Configuration)conf, (String)srcRegionKeyFilePathName, (Configuration)conf, (String)dstRegionKeyFilePathName);
        }
        int segnum = 0;
        if (inputSubRegionKeyFile != null) {
            DiffTableUtils.copyKeyRangeFile((Configuration)conf, (String)inputSubRegionKeyFile, (Configuration)conf, (String)srcSubRegionKeyFilePathName);
            DiffTableUtils.copyKeyRangeFile((Configuration)conf, (String)inputSubRegionKeyFile, (Configuration)conf, (String)dstSubRegionKeyFilePathName);
        } else {
            segnum = DiffTableUtils.writeSegKeyRange((String)srcSubRegionKeyFilePathName, (String)srcTableName);
            DiffTableUtils.copyKeyRangeFile((Configuration)conf, (String)srcSubRegionKeyFilePathName, (Configuration)conf, (String)dstSubRegionKeyFilePathName);
        }
        String localCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        boolean isSecureCluster = JNISecurity.IsSecurityEnabled((String)localCluster);
        if (segnum == 0) {
            return this.launchDiffTablesJob(diffTableOutDirPathName, null, null, args, isSecureCluster);
        }
        LOG.info((Object)(localCluster + " is " + (isSecureCluster ? "" : "not ") + "secure cluster."));
        if (isSecureCluster) {
            srcConf.setBoolean("fs.maprfs.impl.disable.cache", true);
            dstConf.setBoolean("fs.maprfs.impl.disable.cache", true);
        }
        String srcChecksumDirUri = srcOutDiffCrcDirName;
        String[] srcRCArgs = RangeChecksum.convertFromDiffTablesArg(true, srcRegionKeyFilePathName, srcSubRegionKeyFilePathName, null, srcChecksumDirUri, SrcChecksumJobNAME, args);
        String dstChecksumDirUri = dstOutDiffCrcDirName;
        String[] dstRCArgs = RangeChecksum.convertFromDiffTablesArg(false, dstRegionKeyFilePathName, dstSubRegionKeyFilePathName, null, dstChecksumDirUri, DstChecksumJobNAME, args);
        if (DiffTablesWithCrc.srcCTPath.clusterName != null && DiffTablesWithCrc.srcCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
            CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.srcCTPath.clusterName);
        }
        if ((srcJob = RangeChecksum.createSubmittableJob(srcConf, srcRCArgs)) == null) {
            LOG.error((Object)("Failed to create job on cluster " + (DiffTablesWithCrc.srcCTPath.clusterName == null ? "local" : DiffTablesWithCrc.srcCTPath.clusterName)));
            return 1;
        }
        srcJob.submit();
        if (DiffTablesWithCrc.dstCTPath.clusterName != null) {
            if (DiffTablesWithCrc.dstCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
                CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.dstCTPath.clusterName);
            }
        } else {
            CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        }
        if ((dstJob = RangeChecksum.createSubmittableJob(dstConf, dstRCArgs)) == null) {
            LOG.error((Object)("Failed to create job on cluster " + (DiffTablesWithCrc.dstCTPath.clusterName == null ? "local" : DiffTablesWithCrc.dstCTPath.clusterName)));
            return 1;
        }
        dstJob.submit();
        if (DiffTablesWithCrc.srcCTPath.clusterName != null) {
            if (DiffTablesWithCrc.srcCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
                CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.srcCTPath.clusterName);
            }
        } else {
            CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        }
        int n = ret = srcJob.waitForCompletion(true) ? 0 : 1;
        if (ret != 0) {
            LOG.error((Object)("Wait for job to complete failed on cluster " + (DiffTablesWithCrc.srcCTPath.clusterName == null ? "local" : DiffTablesWithCrc.srcCTPath.clusterName)));
            return ret;
        }
        if (DiffTablesWithCrc.dstCTPath.clusterName != null) {
            if (DiffTablesWithCrc.dstCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
                CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.dstCTPath.clusterName);
            }
        } else {
            CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        }
        int n2 = ret = dstJob.waitForCompletion(true) ? 0 : 1;
        if (ret != 0) {
            LOG.error((Object)("Wait for job to complete failed on cluster " + (DiffTablesWithCrc.dstCTPath.clusterName == null ? "local" : DiffTablesWithCrc.dstCTPath.clusterName)));
            return ret;
        }
        CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        String srcChecksumFileUri = RangeChecksum.getOutputPathName(srcChecksumDirUri, srcTableName) + "/" + "part-r-00000";
        String destChecksumFileUri = RangeChecksum.getOutputPathName(dstChecksumDirUri, dstTableName) + "/" + "part-r-00000";
        String mismatchedPathName = new String(outputDiffCrcDir + ((DiffTablesWithCrc.srcCTPath.clusterName == null ? "" : DiffTablesWithCrc.srcCTPath.clusterName) + DiffTablesWithCrc.srcCTPath.tablePathName).replace("/", "").replace(":", "") + ((DiffTablesWithCrc.dstCTPath.clusterName == null ? "" : DiffTablesWithCrc.dstCTPath.clusterName) + DiffTablesWithCrc.dstCTPath.tablePathName).replace("/", "").replace(":", "") + ".mismatchedkeyrange");
        LOG.info((Object)("srcChecksumFileUri=(" + srcChecksumFileUri + "), destChecksumFileUri=(" + destChecksumFileUri + "), mismatchedPathName=(" + mismatchedPathName + "), diffTableOutDirPathName =(" + diffTableOutDirPathName + ")"));
        DiffTablesWithCrc.compareChecksum(srcChecksumFileUri, destChecksumFileUri, mismatchedPathName);
        List mismatchedStartKeys = DiffTableUtils.readKeyRange((Configuration)conf, (Path)new Path(mismatchedPathName));
        if (mismatchedStartKeys.isEmpty()) {
            LOG.info((Object)"Succeed. Checksum for each range matches, skip row by row comparison. ");
            DiffTableUtils.writeStringToFile((Configuration)conf, (String)"", (String)(diffTableOutDirPathName + "_SUCCESS"));
            return 0;
        }
        return this.launchDiffTablesJob(diffTableOutDirPathName, srcSubRegionKeyFilePathName, mismatchedPathName, args, isSecureCluster);
    }

    public int launchDiffTablesJob(String diffTableOutDirPathName, String srcSubRegionKeyFilePathName, String mismatchedPathName, String[] args, boolean isSecureCluster) {
        int ret = 0;
        String[] diffRangeArgs = DiffTableUtils.diffTablesWithCrcArgToDiffTablesArg((String)diffTableOutDirPathName, (String)srcSubRegionKeyFilePathName, (String)mismatchedPathName, (String[])args);
        try {
            DiffTables diffTables = new DiffTables();
            diffTables.parseArgs(diffRangeArgs);
            Configuration diffTableConf = new Configuration();
            if (isSecureCluster) {
                diffTableConf.setBoolean("fs.maprfs.impl.disable.cache", true);
            }
            ret = ToolRunner.run((Configuration)diffTableConf, (Tool)diffTables, (String[])diffRangeArgs);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        if (ret != 0) {
            LOG.error((Object)"DiffTables job failed on this cluster.");
        }
        return ret;
    }

    private int compareMeta(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)this.getConf(), (Tool)new DiffTablesMeta(true), (String[])args);
        if (ret == 1) {
            System.out.println("ERROR: Metadata is different.");
            System.out.println("To skip metadata comparison, use the option -cmpmeta false.");
            System.exit(ret);
        } else if (ret == 0) {
            System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int ret;
        block2: {
            Configuration conf = new Configuration();
            ret = 0;
            try {
                ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTablesWithCrc(), (String[])args);
            }
            catch (Exception e) {
                ret = 1;
                e.printStackTrace();
                if (outputFileLocation == null) break block2;
                System.err.println(outputFileLocation);
            }
        }
        System.exit(ret);
    }
}

