/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.tools.CopyTable;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestCopyTable
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCopyTable.class);
    private static final String SRC_PATH = "/testtable-TestCopyTableSrc";
    private static final String DST_PATH = "/testtable-TestCopyTableDst";
    private static AdminImpl admin = null;
    private static MapRDBTableImpl srcTable = null;
    private static MapRDBTableImpl dstTable = null;
    private static boolean mapreduce = false;
    private static boolean bulkload = false;
    private static boolean isMarlin = false;
    private static boolean cmpmeta = true;
    private static String columnSpec = null;
    private static String startRow = null;
    private static String stopRow = null;
    private static Integer numThreads = -1;

    @Before
    public void setupTestCopyTable() throws Exception {
        admin = (AdminImpl)MapRDB.newAdmin();
        TableDescriptor tableDesc = MapRDB.newTableDescriptor((String)SRC_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"a.b")).addFamily(MapRDB.newFamilyDescriptor((String)"cf2", (String)"a.b.c.d")).addFamily(MapRDB.newFamilyDescriptor((String)"cf3", (String)"x.y"));
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        srcTable = (MapRDBTableImpl)admin.createTable(tableDesc);
        this.loadJSONData(srcTable);
    }

    @After
    public void cleanupTestCopyTable() throws Exception {
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
    }

    private String[] getCopyTableCmdParams() {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("-src");
        cmdArgsList.add(SRC_PATH);
        cmdArgsList.add("-dst");
        cmdArgsList.add(DST_PATH);
        cmdArgsList.add("-mapreduce");
        cmdArgsList.add(Boolean.toString(mapreduce));
        cmdArgsList.add("-bulkload");
        cmdArgsList.add(Boolean.toString(bulkload));
        cmdArgsList.add("-cmpmeta");
        cmdArgsList.add(Boolean.toString(cmpmeta));
        if (columnSpec != null) {
            cmdArgsList.add("-columns");
            cmdArgsList.add(columnSpec);
        }
        if (startRow != null) {
            cmdArgsList.add("-startRow");
            cmdArgsList.add(startRow);
        }
        if (stopRow != null) {
            cmdArgsList.add("-stopRow");
            cmdArgsList.add(stopRow);
        }
        if (numThreads > 0) {
            cmdArgsList.add("-numthreads");
            cmdArgsList.add(Integer.toString(numThreads));
        }
        String[] cmdArgs = new String[cmdArgsList.size()];
        return cmdArgsList.toArray(cmdArgs);
    }

    private String[] getDiffTableCmdParams() {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("-src");
        cmdArgsList.add(SRC_PATH);
        cmdArgsList.add("-dst");
        cmdArgsList.add(DST_PATH);
        cmdArgsList.add("-mapreduce");
        cmdArgsList.add(Boolean.toString(mapreduce));
        cmdArgsList.add("-cmpmeta");
        cmdArgsList.add(Boolean.toString(cmpmeta));
        if (columnSpec != null) {
            cmdArgsList.add("-columns");
            cmdArgsList.add(columnSpec);
        }
        cmdArgsList.add("-outdir");
        cmdArgsList.add("/tmp/difftables/logs_" + System.currentTimeMillis());
        if (numThreads > 0) {
            cmdArgsList.add("-numthreads");
            cmdArgsList.add(Integer.toString(numThreads));
        }
        String[] cmdArgs = new String[cmdArgsList.size()];
        return cmdArgsList.toArray(cmdArgs);
    }

    void verifyIO(String tblpath) {
        Table tbl = MapRDB.getTable((String)tblpath);
        Document r = MapRDB.newDocument();
        r.set("f1", "abc");
        tbl.insertOrReplace("key", r);
        tbl.flush();
        Document d = tbl.findById("key");
        Assert.assertEquals((Object)"abc", (Object)d.getString("f1"));
    }

    private void loadJSONData(MapRDBTableImpl table) throws Exception {
        Integer start = 100000;
        if (table != null) {
            while (start < 200000) {
                Integer n = start;
                Integer n2 = start = Integer.valueOf(start + 1);
                String key = Integer.toString(n);
                Document d = MapRDB.newDocument();
                d.set("a.b.d", true).setArray("a.b.c.d.e", new Object[]{1, 2, 3, 4}).set("x.y.z", "value1");
                table.insertOrReplace(key, d);
                table.flush();
            }
        }
    }

    private void runCopyTable(Configuration config, boolean mapReduce, boolean bulkLoad, String columnSpec) throws Exception {
        mapreduce = mapReduce;
        bulkload = bulkLoad;
        TestCopyTable.columnSpec = columnSpec;
        String[] args = this.getCopyTableCmdParams();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)config, (Tool)new CopyTable(), (String[])args);
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("CopyTable with mapreduce=" + Boolean.toString(mapreduce) + " bulkload=" + Boolean.toString(bulkload) + " for src=" + SRC_PATH + ", dst=" + DST_PATH + " failed.");
            throw e;
        }
    }

    private void runDiffTables(Configuration config, boolean mapReduce, String columnSpec) throws Exception {
        mapreduce = mapReduce;
        TestCopyTable.columnSpec = columnSpec;
        String[] args = this.getDiffTableCmdParams();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)config, (Tool)new DiffTables(), (String[])args);
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("DiffTables with mapreduce=" + Boolean.toString(mapreduce) + " bulkload=" + Boolean.toString(bulkload) + " for src=" + SRC_PATH + ", dst=" + DST_PATH + " failed.");
            throw e;
        }
    }

    @Test
    public void testCopyTableJSON_No_MR_No_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, false, false, null);
        this.runDiffTables(config, false, null);
        this.verifyIO(DST_PATH);
    }

    @Ignore(value="Enable after bug 20120 is fixed.")
    @Test
    public void testCopyTableJSON_MR_No_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, true, false, null);
        this.runDiffTables(config, false, null);
        this.verifyIO(DST_PATH);
    }

    @Test
    public void testCopyTableJSON_No_MR_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, false, true, null);
        this.runDiffTables(config, false, null);
        this.verifyIO(DST_PATH);
    }

    @Ignore(value="Enable after bug 20120 is fixed.")
    @Test
    public void testCopyTableJSON_MR_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, true, true, null);
        this.runDiffTables(config, true, null);
        this.verifyIO(DST_PATH);
    }

    @Ignore(value="Enable after fixing FormatResult.")
    @Test
    public void testCopyTableJSON_No_MR_With_Projection() throws Exception {
        Configuration config = new Configuration();
        String columnspec = new String("a.b.c, x.y, a.b.d");
        this.runCopyTable(config, false, false, columnspec);
        this.runDiffTables(config, false, columnspec);
        this.verifyIO(DST_PATH);
    }

    @Test
    public void testCopyTableJSON_Asymmetric_CFs_Compare_Meta() throws Exception {
        Configuration config = new Configuration();
        if (admin == null) {
            admin = (AdminImpl)MapRDB.newAdmin();
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        TableDescriptor tableDesc = MapRDB.newTableDescriptor((String)DST_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"a.b"));
        dstTable = (MapRDBTableImpl)admin.createTable(tableDesc);
        try {
            this.runCopyTable(config, false, false, null);
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("CopyTable failed : " + e.getMessage(), (Throwable)e);
        }
        this.verifyIO(DST_PATH);
    }

    @Test
    public void testCopyTableJSON_Asymmetric_CFs_No_Compare_Meta() throws Exception {
        Configuration config = new Configuration();
        cmpmeta = false;
        if (admin == null) {
            admin = (AdminImpl)MapRDB.newAdmin();
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        TableDescriptor srcTableDesc = MapRDB.newTableDescriptor((String)SRC_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor());
        srcTable = (MapRDBTableImpl)admin.createTable(srcTableDesc);
        this.loadJSONData(srcTable);
        TableDescriptor dstTableDesc = MapRDB.newTableDescriptor((String)DST_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"a.b"));
        dstTable = (MapRDBTableImpl)admin.createTable(dstTableDesc);
        try {
            this.runCopyTable(config, false, false, null);
        }
        catch (Exception e) {
            _logger.error("CopyTable failed : " + e.getMessage());
            throw e;
        }
        this.runDiffTables(config, false, null);
        this.verifyIO(DST_PATH);
    }

    @Test
    public void testCopyTableJSON_NoMR_With_Fieldpath_Projections() throws Exception {
        Configuration config = new Configuration();
        String copyPaths = "a.b.d,x.y";
        try {
            this.runCopyTable(config, false, false, copyPaths);
        }
        catch (Exception e) {
            _logger.error("CopyTable failed : " + e.getMessage());
            throw e;
        }
        this.runDiffTables(config, false, copyPaths);
        dstTable = (MapRDBTableImpl)MapRDB.getTable((String)DST_PATH);
        DocumentStream ds = dstTable.find();
        for (Document readDoc : ds) {
            Assert.assertNull((Object)readDoc.getValue("a.b.c.d.e"));
            Assert.assertTrue((boolean)readDoc.getBoolean("a.b.d"));
            Assert.assertEquals((Object)"value1", (Object)readDoc.getString("x.y.z"));
        }
        this.verifyIO(DST_PATH);
    }

    @Test
    public void testCopyTableJSON_NoMR_With_ReadAllCFs_Flag() throws Exception {
        String columnSpec;
        Configuration config = new Configuration();
        String srcTablePath = "/t1";
        String dstTable1Path = "/c1";
        String dstTable2Path = "/c2";
        Table srcTable = DBTests.createOrReplaceTable((String)srcTablePath);
        Table dstTable1 = DBTests.createOrReplaceTable((String)dstTable1Path);
        Table dstTable2 = DBTests.createOrReplaceTable((String)dstTable2Path);
        Document doc1 = MapRDB.newDocument();
        doc1.set("a.b.c", "abc").set("a.c.d", "acd").set("x.y.z", "xyz");
        Document doc2 = MapRDB.newDocument();
        doc2.set("a.b.c", "abc").set("a.b.d", "abd").set("x.y.z", "xyz");
        int numRecords = 100;
        int lastKey = 2 * numRecords;
        int count = numRecords;
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        while (count++ < lastKey) {
            String key = "key" + Integer.toString(count);
            srcTable.insert(key, count % 2 == 1 ? doc1 : doc2);
            if (count % 2 == 1) {
                list1.add(key);
                continue;
            }
            list2.add(key);
        }
        int ret = 0;
        try {
            columnSpec = "a.c.d";
            ret = ToolRunner.run((Configuration)config, (Tool)new CopyTable(), (String[])new String[]{"-src", srcTable.getPath().toString(), "-dst", dstTable1.getPath().toString(), "-mapreduce", "false", "-bulkload", "false", "-columns", columnSpec});
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("CopyTable with mapreduce=" + Boolean.toString(mapreduce) + " bulkload=" + Boolean.toString(bulkload) + " for src=" + srcTable + ", dst=" + dstTable + " failed.");
            throw e;
        }
        try {
            columnSpec = "a.b.d";
            ret = ToolRunner.run((Configuration)config, (Tool)new CopyTable(), (String[])new String[]{"-src", srcTable.getPath().toString(), "-dst", dstTable2.getPath().toString(), "-mapreduce", "false", "-bulkload", "false", "-columns", columnSpec});
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("CopyTable with mapreduce=" + Boolean.toString(mapreduce) + " bulkload=" + Boolean.toString(bulkload) + " for src=" + srcTable + ", dst=" + dstTable + " failed.");
            throw e;
        }
        DocumentStream ds = dstTable1.find();
        for (Document readDoc : ds) {
            Assert.assertNull((Object)readDoc.getValue("a.b.d"));
            Assert.assertNotNull((Object)readDoc.getValue("a.c.d"));
            Assert.assertTrue((boolean)list1.contains(readDoc.getIdString()));
            Assert.assertTrue((!list2.contains(readDoc.getIdString()) ? 1 : 0) != 0);
        }
        ds.close();
        ds = dstTable2.find();
        for (Document readDoc : ds) {
            Assert.assertNull((Object)readDoc.getValue("a.c.d"));
            Assert.assertNotNull((Object)readDoc.getValue("a.b.d"));
            Assert.assertTrue((boolean)list2.contains(readDoc.getIdString()));
            Assert.assertTrue((!list1.contains(readDoc.getIdString()) ? 1 : 0) != 0);
        }
        ds.close();
        MapRDBTableImpl srcTableImpl = (MapRDBTableImpl)srcTable;
        srcTableImpl.setPrivateOption(MapRDBTableImpl.TablePrivateOption.READ_ALL_CFS, false);
        srcTableImpl.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, true);
        ds = srcTableImpl.find(new String[]{"a.b.d"});
        for (Document readDoc : ds) {
            Assert.assertTrue((boolean)list2.contains(readDoc.getIdString()));
            Assert.assertTrue((!list1.contains(readDoc.getIdString()) ? 1 : 0) != 0);
        }
        ds.close();
        srcTableImpl.setPrivateOption(MapRDBTableImpl.TablePrivateOption.READ_ALL_CFS, true);
        ds = srcTableImpl.find(new String[]{"a.c.d"});
        for (Document readDoc : ds) {
            if (!list2.contains(readDoc.getIdString())) {
                Assert.assertTrue((boolean)list1.contains(readDoc.getIdString()));
                Assert.assertNotNull((Object)readDoc.getValue("a.c.d"));
                continue;
            }
            Assert.assertTrue((boolean)list2.contains(readDoc.getIdString()));
            Assert.assertNull((Object)readDoc.getString("a.c.d"));
        }
    }
}

