package com.mapr.db.mapreduce.tools.impl;

import java.io.IOException;
import java.util.Iterator;

import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.QueryCondition;

import com.mapr.db.MapRDB;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.MapRDBTableImpl.TablePrivateOption;
import com.mapr.db.rowcol.DBDocumentImpl;

/*
 * document scanner with functionality to peek
 * rows without taking it off the scanner
 */
public class DocScanner {
  DocumentStream s;
  Iterator<Document> iter;
  DBDocumentImpl lastDocument;
  MapRDBTableImpl table;
  boolean preserveTimestamp = true;
  boolean decodeTimestamp = true;
  boolean getDeletes = true;

  public DocScanner(String tablePath,
      QueryCondition c /*rowKeyCond*/,
      String []fields, boolean excludedEmbeddedFamily) throws IOException {
    table = (MapRDBTableImpl) MapRDB.getTable(tablePath);
    table.setPrivateOption(TablePrivateOption.PRESERVE_TIMESTAMP, preserveTimestamp);
    table.setPrivateOption(TablePrivateOption.GET_DELETES, getDeletes);
    table.setPrivateOption(TablePrivateOption.DECODE_TIMESTAMP, decodeTimestamp);
    table.setPrivateOption(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, excludedEmbeddedFamily);

    if (fields != null) {
      s = table.find(c, fields);
    } else {
      s = table.find(c);
    }
    iter = s.iterator();
  }


  /* returns current record and moved to next record */
  public DBDocumentImpl getNext() {
    if (lastDocument != null) {
      DBDocumentImpl d = lastDocument;
      lastDocument = null;
      return d;
    }

    if (iter.hasNext()) {
      return (DBDocumentImpl) iter.next();
    }
    return null;
  }

  /*
   * returns current record but doesn't move to next record
   * consume() needs to be called to consume record returned
   * by peek
   */
  public DBDocumentImpl peekNext() {
    if (lastDocument != null) {
      return lastDocument;
    }
    if (iter.hasNext()) {
      lastDocument = (DBDocumentImpl) iter.next();
    }
    return lastDocument;
  }

  public boolean hasNext() {
    // getNext and hasNext should match each other. Should this code be
    // return (lastDocument != null) || iter.hasNext() ?
    // since when there is only one doc left, if user run peekNext, then iter.hasNext() will be false,
    // but getNext() still can return the last doc.
    // If we keep this behavior, user will be very confused by (hasNext() is already false, but getNext() still returns a doc.
    return iter.hasNext();
  }

  public void consume() {
    lastDocument = null;
  }

  public void close() throws IOException {
    table.close();
  }
}
