/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.impl.IdCodec;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatResultNonMR {
    private int numThreads;
    private Path outDir;
    private Path inDir;
    private FileSystem fs;
    private Configuration conf;
    private static final Logger logger = LoggerFactory.getLogger(FormatResultNonMR.class);

    public FormatResultNonMR(Configuration conf, Path inDir, Path outDir, int numThreads) throws IOException {
        this.numThreads = numThreads;
        this.outDir = outDir;
        this.inDir = inDir;
        this.conf = conf;
        this.fs = FileSystem.get((Configuration)conf);
    }

    private int validateAndCreateDirs() throws Exception {
        try {
            if (this.fs.exists(this.outDir)) {
                System.err.println("Output dir " + this.outDir + " already exists");
                return -1;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to check the status of dir " + this.outDir);
            throw e;
        }
        try {
            if (!this.fs.mkdirs(this.outDir)) {
                System.err.println("Failed to create dir " + this.outDir);
                return -1;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create dir " + this.outDir);
            throw e;
        }
        return 0;
    }

    public static String printDiffRow(ByteBuffer row, DBDocumentImpl doc) {
        StringBuilder sb = new StringBuilder();
        if (doc != null) {
            String rowKeyString = IdCodec.decode((ByteBuffer)row).toString();
            String docStringWithTs = doc.getStringWithTs(doc.getJsonPathMap());
            sb.append("\"row\":{ \"_id\":" + rowKeyString + ", \"value\":{" + docStringWithTs + "}}");
        }
        sb.append("\n");
        return sb.toString();
    }

    public int runWithoutMapReduce() throws Exception {
        int i;
        int err = 0;
        err = this.validateAndCreateDirs();
        if (err != 0) {
            return err;
        }
        FileStatus[] files = this.fs.listStatus(this.inDir);
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        ArrayList<FormatResultThread> threads = new ArrayList<FormatResultThread>();
        for (i = 0; i < files.length; ++i) {
            if (files[i].getLen() == 0L) continue;
            FormatResultThread t = new FormatResultThread(files[i]);
            threads.add(t);
            executor.execute(t);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        for (i = 0; i < threads.size(); ++i) {
            if (((FormatResultThread)threads.get(i)).completed()) continue;
            System.err.println("Thread '" + i + "' didnot finish successfully. Exiting...");
            System.exit(-1);
        }
        System.out.println("Successfully created files in " + this.outDir);
        return 0;
    }

    class FormatResultThread
    implements Runnable {
        FileStatus inFile;
        private boolean completed;

        public FormatResultThread(FileStatus inFile) throws Exception {
            this.inFile = inFile;
        }

        public boolean completed() {
            return this.completed;
        }

        @Override
        public void run() {
            String outFile = this.inFile.getPath().getName();
            outFile = outFile + ".txt";
            FSDataOutputStream out = null;
            try {
                out = FormatResultNonMR.this.fs.create(new Path(FormatResultNonMR.this.outDir, outFile));
            }
            catch (IOException e) {
                System.err.println("Failed to create file " + new Path(FormatResultNonMR.this.outDir, outFile));
                e.printStackTrace();
            }
            try {
                SequenceFile.Reader r = new SequenceFile.Reader(FormatResultNonMR.this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)this.inFile.getPath())});
                ByteBufWritableComparable key = new ByteBufWritableComparable();
                ByteBufWritableComparable value = new ByteBufWritableComparable();
                while (r.next((Writable)key, (Writable)value)) {
                    DBDocumentImpl doc = (DBDocumentImpl)SequenceFileRowColCodec.decode((ByteBuffer)value.getByteBuf());
                    String s = FormatResultNonMR.printDiffRow(key.getByteBuf(), doc);
                    out.write(s.getBytes());
                }
                out.close();
                this.completed = true;
            }
            catch (IOException e) {
                System.err.println("Failed to read from file " + this.inFile.getPath());
                e.printStackTrace();
            }
        }
    }
}

