/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test.repl;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.tools.CopyTable;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.mapreduce.tools.Import;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestRepl
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestRepl.class);
    private static final String SRC_TABLE_NAME = "/srctable";
    private static final String DST_TABLE_NAME = "/dsttable";
    private static final String DIFF_TABLE_OUT_DIR = "/tmp/difftables";
    private static final int REPL_SLEEP_INTERVAL = 15000;
    private static final boolean KEEP_INSERTION_ORDER = true;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables((String[])new String[]{SRC_TABLE_NAME});
        DBTests.deleteTables((String[])new String[]{DST_TABLE_NAME});
    }

    private static void waitForReplication() throws InterruptedException {
        _logger.info("Waiting for replication to complete...");
        Thread.sleep(15000L);
    }

    public static void setupReplication(String srcTable, String dstTable, Boolean paused, String columns) throws InterruptedException, IOException {
        String read;
        ProcessBuilder proc = null;
        String[] addCmd = new String[]{"maprcli", "table", "replica", "add", "-path", srcTable, "-replica", dstTable, "-paused", paused.toString()};
        ArrayList<String> addCmdList = new ArrayList<String>(Arrays.asList(addCmd));
        if (columns != null) {
            addCmdList.add("-columns");
            addCmdList.add(columns);
        }
        proc = new ProcessBuilder(addCmdList.toArray(new String[addCmdList.size()]));
        Process replicaAdd = proc.start();
        replicaAdd.waitFor();
        InputStream is = replicaAdd.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        System.out.println(sb.toString());
        _logger.info("Replica add process exit code: {}", (Object)replicaAdd.exitValue());
        String[] upstreamCmd = new String[]{"maprcli", "table", "upstream", "add", "-path", dstTable, "-upstream", srcTable};
        ArrayList<String> upstreamCmdList = new ArrayList<String>(Arrays.asList(upstreamCmd));
        proc = new ProcessBuilder(upstreamCmdList.toArray(new String[upstreamCmdList.size()]));
        Process upstreamAdd = proc.start();
        upstreamAdd.waitFor();
        _logger.info("Upstream add process exit code: {}", (Object)upstreamAdd.exitValue());
        Assert.assertEquals((long)0L, (long)upstreamAdd.exitValue());
        TestRepl.waitForReplication();
    }

    String addReplica(String srcTable, String dstTable, boolean paused, String columns) throws InterruptedException, IOException {
        String read;
        String[] addCmd = new String[]{"maprcli", "table", "replica", "add", "-path", srcTable, "-replica", dstTable, "-paused", Boolean.toString(paused), "-json"};
        ArrayList<String> addCmdList = new ArrayList<String>(Arrays.asList(addCmd));
        if (columns != null) {
            addCmdList.add("-columns");
            addCmdList.add(columns);
        }
        ProcessBuilder proc = new ProcessBuilder(addCmdList.toArray(new String[addCmdList.size()]));
        Process replicaAdd = proc.start();
        replicaAdd.waitFor();
        InputStream is = replicaAdd.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        return sb.toString();
    }

    public static String listReplication(String srcTable) throws InterruptedException, IOException {
        String read;
        String[] listCmd = new String[]{"maprcli", "table", "replica", "list", "-path", srcTable, "-json"};
        ProcessBuilder proc = new ProcessBuilder(listCmd).redirectErrorStream(true);
        Process replicaList = proc.start();
        replicaList.waitFor();
        InputStream is = replicaList.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        System.out.println(sb.toString());
        _logger.info("Replica add process exit code: {}", (Object)replicaList.exitValue());
        Assert.assertEquals((long)0L, (long)replicaList.exitValue());
        return sb.toString();
    }

    void pauseReplication(String srcTable, String dstTable) throws InterruptedException, IOException {
        ProcessBuilder proc = new ProcessBuilder("maprcli", "table", "replica", "pause", "-path", srcTable, "-replica", dstTable);
        Process replicaPause = proc.start();
        replicaPause.waitFor();
        InputStream is = replicaPause.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String read = null;
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        if (sb.length() != 0) {
            _logger.error("Replication failed to pause with error: " + sb.toString());
            return;
        }
        String listOutput = TestRepl.listReplication(srcTable);
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)true);
        _logger.info("Paused replication for " + srcTable + " and " + dstTable);
    }

    void resumeReplication(String srcTable, String dstTable) throws InterruptedException, IOException {
        ProcessBuilder proc = new ProcessBuilder("maprcli", "table", "replica", "resume", "-path", srcTable, "-replica", dstTable);
        Process replicaResume = proc.start();
        replicaResume.waitFor();
        InputStream is = replicaResume.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String read = null;
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        if (sb.length() != 0) {
            _logger.error("Replication failed to resume with error: " + sb.toString());
            return;
        }
        String listOutput = TestRepl.listReplication(srcTable);
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        _logger.info("Resumed replication for " + srcTable + " and " + dstTable);
    }

    void createCF(String table, String cfname, String jsonpath) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("maprcli", "table", "cf", "create", "-path", table, "-cfname", cfname, "-jsonpath", jsonpath, "-force", "true");
        Process createCfProc = proc.start();
        createCfProc.waitFor();
        InputStream is = createCfProc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String read = null;
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        if (sb.length() != 0) {
            _logger.error("Failed to create new CF with error: " + sb.toString());
            return;
        }
    }

    public static void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rmr", path);
        Process p = proc.start();
        p.waitFor();
    }

    public static void comapreTables(String srcTable, String dstTable, boolean expectedPass) throws Exception {
        TestRepl.compareTables(srcTable, dstTable, false, expectedPass, null, true);
    }

    public static void compareTables(String srcTable, String dstTable, boolean mapreduce, boolean expectedPass, String columns, boolean cmpmeta) throws Exception {
        String outdir = DIFF_TABLE_OUT_DIR;
        TestRepl.rmDir(outdir);
        String[] diffCmd = new String[]{"-src", srcTable, "-dst", dstTable, "-outdir", outdir, "-mapreduce", Boolean.toString(mapreduce), "-cmpmeta", cmpmeta ? "true" : "false"};
        ArrayList<String> diffCmdList = new ArrayList<String>(Arrays.asList(diffCmd));
        if (columns != null) {
            diffCmdList.add("-columns");
            diffCmdList.add(columns);
        }
        int ret = ToolRunner.run(null, (Tool)new DiffTables(), (String[])diffCmdList.toArray(diffCmd));
        if (expectedPass) {
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    private void importFromDir(String dstTableName, String srcDir) throws IOException, InterruptedException, Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", srcDir, "-dst", dstTableName, "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void formatResult(String inDir, String outDir) throws IOException, InterruptedException {
        TestRepl.rmDir(outDir);
        ProcessBuilder proc = new ProcessBuilder("mapr", "formatresult", "-indir", inDir, "-outdir", outDir);
        _logger.info("Running command {}", proc.command());
        Process p = proc.start();
        p.waitFor();
        _logger.info("formatresult process exit code: {}", (Object)p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    @Test
    public void testSingleFamilyReplication() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.FALSE, null);
        Document d = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        TestRepl.waitForReplication();
        _logger.info("Comparing tables");
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
    }

    @Test
    public void testSingleColumnFamily2() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.FALSE, null);
        Document d = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Thread.sleep(30000L);
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false);
        this.formatResult("/tmp/difftables/OpsForDstTable", "/tmp/difftables/OpsForDstTableDecoded");
        this.formatResult("/tmp/difftables/OpsForSrcTable", "/tmp/difftables/OpsForSrcTableDecoded");
        this.importFromDir(dstTable.getPath().toString(), "/tmp/difftables/OpsForDstTable");
        this.importFromDir(srcTable.getPath().toString(), "/tmp/difftables/OpsForSrcTable");
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
        DocumentStream s = srcTable.find();
        Iterator siter = s.iterator();
        DocumentStream d2 = dstTable.find();
        Iterator diter = d2.iterator();
        for (int i = 0; i < 100000; ++i) {
            Document sdoc = (Document)siter.next();
            Document ddoc = (Document)diter.next();
            Assert.assertEquals((Object)sdoc, (Object)ddoc);
        }
    }

    @Test
    public void testSingleColumnFamilyWithColumns() throws Exception {
        HashMap<String, String> cfPathMap = new HashMap<String, String>();
        cfPathMap.put("cf1", "a.b");
        cfPathMap.put("cf2", "x.y");
        cfPathMap.put("cf3", "a.b.c.d");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, cfPathMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, cfPathMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String[] replJsonPaths = new String[]{"a.b.c", "a.b.c.d", "", "x.y"};
        String replJsonPathString = "";
        for (String path : replJsonPaths) {
            replJsonPathString = replJsonPathString.length() > 0 ? replJsonPathString + "," + path : path;
        }
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.TRUE, replJsonPathString);
        Document d = MapRDB.newDocument().set("a.b.c", "abc").set("a.b.d", "abd").set("a.b.c.d", "abcd").set("a.c.d", "acd").set("x.y.z", "xyz");
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Thread.sleep(30000L);
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false);
        this.formatResult("/tmp/difftables/OpsForDstTable", "/tmp/difftables/OpsForDstTableDecoded");
        this.formatResult("/tmp/difftables/OpsForSrcTable", "/tmp/difftables/OpsForSrcTableDecoded");
        this.importFromDir(dstTable.getPath().toString(), "/tmp/difftables/OpsForDstTable");
        this.importFromDir(srcTable.getPath().toString(), "/tmp/difftables/OpsForSrcTable");
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
        DocumentStream s = srcTable.find();
        Iterator siter = s.iterator();
        DocumentStream d2 = dstTable.find();
        Iterator diter = d2.iterator();
        for (int i = 0; i < 100000; ++i) {
            Document sdoc = (Document)siter.next();
            Document ddoc = (Document)diter.next();
            Assert.assertEquals((Object)sdoc, (Object)ddoc);
        }
    }

    @Test
    public void testMultipleColumnFamily2() throws Exception {
        ImmutableMap sm = ImmutableMap.of((Object)"map", (Object)"map", (Object)"Friends", (Object)"Friends", (Object)"dummy", (Object)"dummy");
        ImmutableMap dm = ImmutableMap.of((Object)"Friends", (Object)"Friends", (Object)"dummy", (Object)"dummy", (Object)"map", (Object)"map");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)sm);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dm);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.TRUE, null);
        Document d = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Thread.sleep(30000L);
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false);
        this.formatResult("/tmp/difftables/OpsForDstTable", "/tmp/difftables/OpsForDstTableDecoded");
        this.formatResult("/tmp/difftables/OpsForSrcTable", "/tmp/difftables/OpsForSrcTableDecoded");
        this.importFromDir(dstTable.getPath().toString(), "/tmp/difftables/OpsForDstTable");
        this.importFromDir(srcTable.getPath().toString(), "/tmp/difftables/OpsForSrcTable");
        _logger.info("src table" + srcTable.getName().toString() + "dst table" + dstTable.getPath().toString() + " " + DIFF_TABLE_OUT_DIR + "/" + "OpsForDstTable");
        TestRepl.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
        DocumentStream s = srcTable.find();
        Iterator siter = s.iterator();
        DocumentStream d2 = dstTable.find();
        Iterator diter = d2.iterator();
        for (int i = 0; i < 100000; ++i) {
            Document sdoc = (Document)siter.next();
            Document ddoc = (Document)diter.next();
            Assert.assertEquals((Object)sdoc, (Object)ddoc);
        }
    }

    @Test
    public void testCliReplicationSetupWithJsonPath() throws Exception {
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"a.b.c.d", (Object)"cf3", (Object)"x.y");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf3", (Object)"x.y", (Object)"cf4", (Object)"c.d");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dstMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,a.b.c.d,,x.y.z.w,a.c.b,c.d,c.d.e.f,a.b.d";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        String listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        System.err.println("data[0].table = " + listDoc.getString("data[0].table"));
        System.err.println("dstTable = " + dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getString("data[0].table"), (Object)dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        String replColumns = listDoc.getString("data[0].Columns");
        Assert.assertNotNull((Object)replColumns);
        String[] replColList = replColumns.split(",");
        String[] origReplColList = replPaths.split(",");
        ArrayList<String> verified = new ArrayList<String>();
        block0: for (String replCol : replColList) {
            for (String origReplCol : origReplColList) {
                if (!replCol.equals(origReplCol)) continue;
                verified.add(replCol);
                continue block0;
            }
        }
        Assert.assertEquals((long)(origReplColList.length - 3), (long)verified.size());
    }

    @Test
    public void testReplicationWithMultiCFProjection() throws Exception {
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"a.b.c.d", (Object)"cf3", (Object)"x.y");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf3", (Object)"x.y", (Object)"cf4", (Object)"c.d");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dstMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,x.y.z,x.y,a.c.d";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        String listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getString("data[0].table"), (Object)dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        String replColumns = listDoc.getString("data[0].Columns");
        Assert.assertNotNull((Object)replColumns);
        Document doc = MapRDB.newDocument().set("a.b.c", "abc").set("a.b.d", "abd").set("x.y.z", "xyz").set("x.y.w", "xyw").set("a.c.d", "acd").set("a.c.e", "ace");
        try {
            int n;
            int key = n = 100000;
            while (n++ < 200000) {
                String keyStr = "key" + key++;
                srcTable.insertOrReplace(keyStr, doc);
            }
        }
        catch (Exception e) {
            _logger.error("Failed to load 100K documents into table " + srcTable.getPath().toString());
            throw e;
        }
        srcTable.flush();
        TestRepl.waitForReplication();
        listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getString("data[0].table"), (Object)dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        String replConfigColumns = listDoc.getString("data[0].Columns");
        Assert.assertNotNull((Object)replConfigColumns);
        Assert.assertNull((Object)listDoc.getString("data[0].errors.Code"));
        DocumentStream ds = dstTable.find();
        Iterator docItr = ds.iterator();
        int count = 0;
        while (docItr.hasNext()) {
            Document rec = (Document)docItr.next();
            Assert.assertNull((Object)rec.getValue("a.b.d"));
            Assert.assertNull((Object)rec.getValue("a.c.e"));
            Assert.assertEquals((Object)"abc", (Object)rec.getString("a.b.c"));
            Assert.assertEquals((Object)"acd", (Object)rec.getString("a.c.d"));
            Assert.assertEquals((Object)"xyz", (Object)rec.getString("x.y.z"));
            Assert.assertEquals((Object)"xyw", (Object)rec.getString("x.y.w"));
            ++count;
        }
        Assert.assertEquals((long)100000L, (long)count);
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
    }

    @Test
    public void testReplicationWithJsonPathMismatch() throws Exception {
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"a.b.c.d", (Object)"cf3", (Object)"x.y");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf3", (Object)"x.y", (Object)"cf4", (Object)"c.d");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dstMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, null);
        String listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getString("data[0].table"), (Object)dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        Document doc = MapRDB.newDocument().set("a.b.c", "abc").set("a.b.d", "abd").set("x.y.z", "xyz").set("x.y.w", "xyw").set("a.c.d", "acd").set("a.c.e", "ace");
        try {
            int n;
            int key = n = 100000;
            while (n++ < 200000) {
                String keyStr = "key" + key++;
                srcTable.insertOrReplace(keyStr, doc);
            }
        }
        catch (Exception e) {
            _logger.error("Failed to load 100K documents into table " + srcTable.getPath().toString());
            throw e;
        }
        srcTable.flush();
        this.pauseReplication(srcTable.getPath().toString(), dstTable.getPath().toString());
        this.createCF(dstTable.getPath().toString(), "cf2", "a.b.c.d");
        this.resumeReplication(srcTable.getPath().toString(), dstTable.getPath().toString());
        listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        TestRepl.waitForReplication();
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        Assert.assertNull((Object)listDoc.getString("data[0].errors.Code"));
        DocumentStream ds = dstTable.find();
        Iterator docItr = ds.iterator();
        int count = 0;
        while (docItr.hasNext()) {
            Document rec = (Document)docItr.next();
            Assert.assertEquals((Object)"abd", (Object)rec.getString("a.b.d"));
            Assert.assertEquals((Object)"ace", (Object)rec.getString("a.c.e"));
            Assert.assertEquals((Object)"abc", (Object)rec.getString("a.b.c"));
            Assert.assertEquals((Object)"acd", (Object)rec.getString("a.c.d"));
            Assert.assertEquals((Object)"xyz", (Object)rec.getString("x.y.z"));
            Assert.assertEquals((Object)"xyw", (Object)rec.getString("x.y.w"));
            ++count;
        }
        Assert.assertEquals((long)100000L, (long)count);
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, null, false);
    }

    @Test
    public void testReplicationWithJsonPathWithArray() throws Exception {
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"a.b.c.d", (Object)"cf3", (Object)"x.y");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf3", (Object)"x.y", (Object)"cf4", (Object)"c.d");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dstMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,x.y.z[10],a.c.d";
        String addOutput = this.addReplica(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        Document outDoc = MapRDB.newDocument((String)addOutput);
        Assert.assertTrue((outDoc != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ERROR", (Object)outDoc.getString("status"));
        Assert.assertEquals((double)22.0, (double)outDoc.getDouble("errors[0].id"), (double)0.0);
    }

    @Test
    public void testReplicationUpdatesWithMultiCFProjection() throws Exception {
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y", (Object)"cf3", (Object)"c.d");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dstMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,x.y.z,x.y,a.c.d,a.m";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        String listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getString("data[0].table"), (Object)dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        String replColumns = listDoc.getString("data[0].Columns");
        Assert.assertNotNull((Object)replColumns);
        Document doc = MapRDB.newDocument();
        doc.set("a.b.c", "abc").set("a.b.d", "abd").set("x.y.z", "xyz").set("x.y.w", "xyw").setArray("x.y.a", new Object[]{"One", 2, "Three"}).set("a.m", "am").set("c.d.e", "cde");
        srcTable.insert("key1", doc);
        srcTable.flush();
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
        Document readDoc = dstTable.findById("key1");
        Assert.assertEquals((Object)"abc", (Object)readDoc.getString("a.b.c"));
        Assert.assertEquals((Object)"xyz", (Object)readDoc.getString("x.y.z"));
        Assert.assertEquals((Object)"xyw", (Object)readDoc.getString("x.y.w"));
        Assert.assertEquals((Object)Value.Type.ARRAY, (Object)readDoc.getValue("x.y.a").getType());
        Assert.assertEquals((Object)"One", (Object)readDoc.getString("x.y.a[0]"));
        Assert.assertEquals((long)2L, (long)readDoc.getInt("x.y.a[1]"));
        Assert.assertEquals((Object)"Three", (Object)readDoc.getString("x.y.a[2]"));
        Assert.assertEquals((Object)"am", (Object)readDoc.getString("a.m"));
        Assert.assertNull((Object)readDoc.getString("a.b.d"));
        Assert.assertNull((Object)readDoc.getString("c.d.e"));
        Assert.assertNull((Object)readDoc.getString("a.c.d"));
        DocumentMutation mut = MapRDB.newMutation();
        mut.delete("a.b.d").delete("m");
        srcTable.update("key1", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
        mut.empty();
        mut.setOrReplace("a.b", "ab");
        srcTable.update("key1", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("a.b.d"));
        Assert.assertEquals((Object)"xyz", (Object)readDoc.getString("x.y.z"));
        Assert.assertEquals((Object)"xyw", (Object)readDoc.getString("x.y.w"));
        Assert.assertEquals((Object)Value.Type.ARRAY, (Object)readDoc.getValue("x.y.a").getType());
        Assert.assertEquals((Object)"One", (Object)readDoc.getString("x.y.a[0]"));
        Assert.assertEquals((long)2L, (long)readDoc.getInt("x.y.a[1]"));
        Assert.assertEquals((Object)"Three", (Object)readDoc.getString("x.y.a[2]"));
        Assert.assertEquals((Object)"am", (Object)readDoc.getString("a.m"));
        mut.empty();
        mut.delete("a.m").setOrReplace("x.y", "xy").setOrReplace("a.c.d.f", "acdf").setOrReplace("a.c.dd.f", "acddf");
        srcTable.update("key1", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("a.b.d"));
        Assert.assertNull((Object)readDoc.getValue("x.y.z"));
        Assert.assertNull((Object)readDoc.getValue("x.y.w"));
        Assert.assertNull((Object)readDoc.getValue("a.c.dd.f"));
        Assert.assertNull((Object)readDoc.getValue("a.m"));
        Assert.assertEquals((Object)"xy", (Object)readDoc.getString("x.y"));
        Assert.assertEquals((Object)"acdf", (Object)readDoc.getString("a.c.d.f"));
        mut.empty();
        mut.delete("x.y");
        srcTable.update("key1", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("x.y"));
        Assert.assertEquals((Object)"acdf", (Object)readDoc.getString("a.c.d.f"));
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
        srcTable.delete("key1");
        srcTable.flush();
        TestRepl.waitForReplication();
        readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("c.d"));
        Assert.assertNull((Object)readDoc.getValue("x.y"));
        Assert.assertNull((Object)readDoc.getValue("a.c.d"));
        Assert.assertNull((Object)readDoc.getValue("a.m"));
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
    }

    @Test
    public void testReplicationSingleFieldPathProjection() throws Exception {
        String key;
        ImmutableMap cfMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y", (Object)"cf3", (Object)"c.d", (Object)"cf4", (Object)"a.b.c");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)cfMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)cfMap);
        String replPaths = "a.b.d.e,x.y.z.w,c.d.e.f,a.b.c.d,m.n.o";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        Document doc = MapRDB.newDocument();
        doc.set("a.b.d.e", "abde").set("x.y.z.w", "xyzw").set("c.d.e.f", "cdef").set("a.b.c.d", "abcd").set("m.n.o", "mno");
        int numRecords = 5;
        int maxKey = 2 * numRecords;
        int count = numRecords;
        while (count++ < maxKey) {
            key = "key" + Integer.toString(count);
            srcTable.insertOrReplace(key, doc);
            srcTable.flush();
        }
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, true);
        count = numRecords;
        while (count++ < maxKey) {
            key = "key" + Integer.toString(count);
            srcTable.delete(key);
            srcTable.flush();
        }
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, true);
    }

    @Test
    public void testAutoSetup() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        Document doc = MapRDB.newDocument().set("a", "b").set("c", "d");
        srcTable.insertOrReplace("key", doc);
        String[] autosetup = new String[]{"maprcli", "table", "replica", "autosetup", "-path", srcTable.getPath().toString(), "-replica", "/tmp/dst", "-columns", "a"};
        ArrayList<String> autosetupCmdList = new ArrayList<String>(Arrays.asList(autosetup));
        ProcessBuilder proc = new ProcessBuilder(autosetupCmdList.toArray(new String[autosetupCmdList.size()]));
        Process setupAuto = proc.start();
        setupAuto.waitFor();
        TestRepl.compareTables(srcTable.getPath().toString(), "/tmp/dst", false, true, "a", true);
        String[] autosetupdup = new String[]{"maprcli", "table", "replica", "autosetup", "-path", srcTable.getPath().toString(), "-replica", "/tmp/dstdup", "-columns", "a,a"};
        ArrayList<String> autosetupdupCmdList = new ArrayList<String>(Arrays.asList(autosetupdup));
        proc = new ProcessBuilder(autosetupdupCmdList.toArray(new String[autosetupdupCmdList.size()]));
        setupAuto = proc.start();
        setupAuto.waitFor();
        TestRepl.compareTables(srcTable.getPath().toString(), "/tmp/dstdup", false, true, "a,a", true);
        String[] autosetupdupdef = new String[]{"maprcli", "table", "replica", "autosetup", "-path", srcTable.getPath().toString(), "-replica", "/tmp/dstdupdef", "-columns", "a,,"};
        ArrayList<String> autosetupdupdefCmdList = new ArrayList<String>(Arrays.asList(autosetupdupdef));
        proc = new ProcessBuilder(autosetupdupdefCmdList.toArray(new String[autosetupdupdefCmdList.size()]));
        setupAuto = proc.start();
        setupAuto.waitFor();
        TestRepl.compareTables(srcTable.getPath().toString(), "/tmp/dstdupdef", false, true, "a,,", true);
        String[] autosetupdupseg = new String[]{"maprcli", "table", "replica", "autosetup", "-path", srcTable.getPath().toString(), "-replica", "/tmp/dstdupseg", "-columns", "a,a,"};
        ArrayList<String> autosetupdupsegCmdList = new ArrayList<String>(Arrays.asList(autosetupdupseg));
        proc = new ProcessBuilder(autosetupdupsegCmdList.toArray(new String[autosetupdupsegCmdList.size()]));
        setupAuto = proc.start();
        setupAuto.waitFor();
        TestRepl.compareTables(srcTable.getPath().toString(), "/tmp/dstdupseg", false, true, "a,a,", true);
        String[] autosetupfull = new String[]{"maprcli", "table", "replica", "autosetup", "-path", srcTable.getPath().toString(), "-replica", "/tmp/dstdupfull", "-columns", "a,c"};
        ArrayList<String> autosetupfullCmdList = new ArrayList<String>(Arrays.asList(autosetupfull));
        proc = new ProcessBuilder(autosetupfullCmdList.toArray(new String[autosetupfullCmdList.size()]));
        setupAuto = proc.start();
        setupAuto.waitFor();
        TestRepl.compareTables(srcTable.getPath().toString(), "/tmp/dstdupfull", false, true, "a,c", true);
        String[] autosetupsingleseg = new String[]{"maprcli", "table", "replica", "autosetup", "-path", srcTable.getPath().toString(), "-replica", "/tmp/dstseg", "-columns", ","};
        ArrayList<String> autosetupsinglesegCmdList = new ArrayList<String>(Arrays.asList(autosetupsingleseg));
        proc = new ProcessBuilder(autosetupsinglesegCmdList.toArray(new String[autosetupsinglesegCmdList.size()]));
        setupAuto = proc.start();
        setupAuto.waitFor();
        TestRepl.compareTables(srcTable.getPath().toString(), "/tmp/dstseg", false, true, ",", true);
    }

    @Test
    public void testReplicationOfIncrementalBulkloadDestination() throws Exception {
        ImmutableMap cfMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y", (Object)"cf3", (Object)"c.d", (Object)"cf4", (Object)"a.b.c");
        Table copySrc = DBTests.createOrReplaceTable((String)"/srctable_copyorigin", (Map)cfMap);
        Table replSrc = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)cfMap);
        Table replDst = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)cfMap);
        replSrc.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        replDst.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        copySrc.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,x.y.z,x.y,a.c.d,a.m";
        TestRepl.setupReplication(replSrc.getPath().toString(), replDst.getPath().toString(), false, replPaths);
        Document doc = MapRDB.newDocument();
        doc.set("a.b.c", "abc").set("a.b.d", "abd").set("x.y.z", "xyz").set("x.y.w", "xyw").setArray("x.y.a", new Object[]{"One", 2, "Three"}).set("a.m", "am").set("c.d.e", "cde");
        int nRows = 100000;
        int maxCount = 2 * nRows;
        int count = nRows;
        while (count++ < maxCount) {
            copySrc.insertOrReplace("key" + count, doc);
        }
        copySrc.flush();
        copySrc.close();
        String[] copyCmd = new String[]{"-src", copySrc.getPath().toString(), "-dst", replSrc.getPath().toString(), "-bulkload", "true", "-mapreduce", "false", "-preserve_ts", "true"};
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])copyCmd);
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("CopyTable with mapreduce=false, bulkload=true  for src=/srctable, dst=/dsttable failed.");
            throw e;
        }
        TestRepl.waitForReplication();
        TestRepl.compareTables(copySrc.getPath().toString(), replSrc.getPath().toString(), false, true, null, true);
        TestRepl.compareTables(replSrc.getPath().toString(), replDst.getPath().toString(), false, true, replPaths, true);
        String notInReplProjection = "c.d.e,a.b.d";
        DocumentStream ds = replSrc.find(notInReplProjection.split(","));
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        while (itr.hasNext()) {
            Document readDoc = (Document)itr.next();
            Assert.assertEquals((Object)"abd", (Object)readDoc.getString("a.b.d"));
            Assert.assertEquals((Object)"cde", (Object)readDoc.getString("c.d.e"));
        }
        ds.close();
        ds = replDst.find(notInReplProjection.split(","));
        for (Document readDoc : ds) {
            Assert.assertNull((Object)readDoc.getValue("a.b.d"));
            Assert.assertNull((Object)readDoc.getValue("c.d.e"));
        }
        ds.close();
    }

    @Test
    public void testReplicationDiffPatchWorkflowWithProjection() throws Exception {
        int count;
        ImmutableMap srcMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y", (Object)"cf3", (Object)"c.d", (Object)"cf4", (Object)"a.b.c");
        ImmutableMap dstMap = ImmutableMap.of((Object)"cf1", (Object)"a.b", (Object)"cf2", (Object)"x.y", (Object)"cf3", (Object)"c.d", (Object)"cf4", (Object)"a.b.c");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)srcMap);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dstMap);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b,a.b.c.d,x.y.z,x.y,a.c.d,a.m,c.d.e";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        String listOutput = TestRepl.listReplication(srcTable.getPath().toString());
        Document listDoc = MapRDB.newDocument((String)listOutput);
        Assert.assertNotNull((Object)listDoc);
        Assert.assertEquals((Object)listDoc.getString("data[0].table"), (Object)dstTable.getPath().toString());
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].paused"), (Object)false);
        Assert.assertEquals((Object)listDoc.getBoolean("data[0].isUptodate"), (Object)true);
        String replColumns = listDoc.getString("data[0].Columns");
        Assert.assertNotNull((Object)replColumns);
        int nRows = 100000;
        Document doc = MapRDB.newDocument();
        doc.set("a.b.c.d", "abcd").set("a.b.d", "abd").set("x.y.z", "xyz").set("x.y.w", "xyw").setArray("x.y.a", new Object[]{"One", 2, "Three"}).set("a.m", "am").set("c.d.e", "cde");
        int maxKey = 200000;
        System.out.println("Inserting " + Integer.toString(100000) + " records...");
        for (count = 100000; count < 200000; ++count) {
            srcTable.insert("key" + Integer.toString(count), doc);
        }
        srcTable.flush();
        TestRepl.waitForReplication();
        System.out.println("Comparing the tables, should match...");
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, true);
        count = 100000;
        DocumentMutation mut = MapRDB.newMutation();
        while (count < 200000) {
            mut.empty();
            mut.setOrReplace("a.b", "ab");
            srcTable.update("key" + Integer.toString(count++), mut);
            mut.empty();
            mut.delete("a.m").setOrReplace("x.y", "xy").setOrReplace("a.c.d.f", "acdf").setOrReplace("a.c.dd.f", "acddf");
            srcTable.update("key" + Integer.toString(count++), mut);
            mut.empty();
            mut.delete("x.y");
            srcTable.update("key" + Integer.toString(count++), mut);
        }
        srcTable.flush();
        TestRepl.waitForReplication();
        TestRepl.compareTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false, true, replPaths, false);
    }

    @Test
    public void testReplicationWithAsymmetricReplicaUpdates() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,a.b.d,x.y";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        Document doc2 = MapRDB.newDocument();
        doc2.set("a.b.c", "dst_abc").set("a.b.d", "dst_abd").set("a.b.e", "dst_abe").set("a.c.d", "dst_acd");
        dstTable.insertOrReplace("key1", doc2);
        dstTable.insertOrReplace("key2", doc2);
        dstTable.insertOrReplace("key3", doc2);
        dstTable.insertOrReplace("key4", doc2);
        dstTable.insertOrReplace("key5", doc2);
        dstTable.flush();
        doc2.set("a.b", 10);
        srcTable.insertOrReplace("key1", doc2);
        srcTable.flush();
        TestRepl.waitForReplication();
        doc2 = dstTable.findById("key1");
        Assert.assertNull((Object)doc2.getValue("a.b.c"));
        Assert.assertNull((Object)doc2.getValue("a.b.d"));
        Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
        Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
        doc2.empty();
        Document subDoc = MapRDB.newDocument();
        subDoc.set("c.d", "abcd");
        DocumentMutation mut = MapRDB.newMutation();
        mut.set("a.b", subDoc);
        srcTable.update("key2", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        doc2 = dstTable.findById("key2");
        Assert.assertEquals((Object)Value.Type.MAP, (Object)doc2.getValue("a.b.c").getType());
        Assert.assertEquals((Object)"abcd", (Object)doc2.getString("a.b.c.d"));
        Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
        Assert.assertNotNull((Object)doc2.getValue("a.b.d"));
        Assert.assertNotNull((Object)doc2.getValue("a.b.e"));
        doc2.empty();
        subDoc.empty();
        subDoc = MapRDB.newDocument();
        subDoc.set("e.c", "abec");
        doc2.set("a.b", subDoc);
        srcTable.insertOrReplace("key3", doc2);
        srcTable.flush();
        TestRepl.waitForReplication();
        doc2 = dstTable.findById("key3");
        Assert.assertNull((Object)doc2.getValue("a.b.c"));
        Assert.assertNull((Object)doc2.getValue("a.b.d"));
        Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
        Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
        Assert.assertNull((Object)doc2.getValue("a.b.e.c"));
        mut.empty();
        mut.delete("a.b.c");
        srcTable.update("key2", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        doc2 = dstTable.findById("key2");
        Assert.assertNull((Object)doc2.getValue("a.b.c"));
        Assert.assertEquals((Object)"dst_abd", (Object)doc2.getString("a.b.d"));
        Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
        Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
        mut.empty();
        mut.delete("a.b");
        srcTable.update("key2", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        doc2 = dstTable.findById("key2");
        Assert.assertNull((Object)doc2.getValue("a.b.c"));
        Assert.assertNull((Object)doc2.getValue("a.b.d"));
        Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
        Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
        mut.empty();
        mut.delete("a.c");
        srcTable.update("key5", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        doc2 = dstTable.findById("key5");
        Assert.assertEquals((Object)"dst_abc", (Object)doc2.getString("a.b.c"));
        Assert.assertEquals((Object)"dst_abd", (Object)doc2.getString("a.b.d"));
        Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
        srcTable.delete("key1");
        srcTable.delete("key2");
        srcTable.delete("key3");
        srcTable.delete("key4");
        srcTable.delete("key5");
        srcTable.flush();
        TestRepl.waitForReplication();
        DocumentStream ds = dstTable.find();
        block13: for (Document doc2 : ds) {
            String key;
            Assert.assertNull((Object)doc2.getValue("a.b.c"));
            Assert.assertNull((Object)doc2.getValue("a.b.d"));
            Assert.assertNull((Object)doc2.getValue("x.y"));
            switch (key = doc2.getIdString()) {
                case "key1": 
                case "key2": {
                    Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
                    Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
                    continue block13;
                }
                case "key3": {
                    Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
                    Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
                    continue block13;
                }
                case "key4": {
                    Assert.assertEquals((Object)"dst_abe", (Object)doc2.getString("a.b.e"));
                    Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
                    continue block13;
                }
                case "key5": {
                    Assert.assertEquals((Object)"dst_acd", (Object)doc2.getString("a.c.d"));
                    continue block13;
                }
            }
            Assert.assertNull((Object)doc2.getId().toString());
        }
    }

    @Test
    public void testReplicationWithFieldOrderFPDelete() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        MapRDBTableImpl dstTable = (MapRDBTableImpl)DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        dstTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, true);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.d.e,a.b.e.f,a.b.c.d,a.c.d.e,a.d.e.f";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        Document doc = MapRDB.newDocument();
        doc.set("a.c.d.e", "dst_acde");
        dstTable.insertOrReplace("key1", doc);
        dstTable.flush();
        DocumentMutation mut = MapRDB.newMutation();
        mut.set("a.e.f.g", "aefg");
        dstTable.update("key1", mut);
        dstTable.flush();
        mut.empty();
        mut.set("a.d.e.f", "dst_adef");
        dstTable.update("key1", mut);
        dstTable.flush();
        doc.empty();
        doc.set("a.b", "10").set("a.c", "ac").set("a.d", "ad");
        srcTable.insertOrReplace("key1", doc);
        srcTable.flush();
        TestRepl.waitForReplication();
        DocumentStream ds = dstTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        while (itr.hasNext()) {
            DBDocumentImpl readDoc = (DBDocumentImpl)itr.next();
            KeyValue kv = readDoc.getKeyValue("a.b.c");
            Assert.assertTrue((kv.getOrderOfField() == 0 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.b.d");
            Assert.assertTrue((kv.getOrderOfField() == 1 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.b.e");
            Assert.assertTrue((kv.getOrderOfField() == 2 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.b");
            Assert.assertTrue((kv.getOrderOfField() == 3 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.c");
            Assert.assertTrue((kv.getOrderOfField() == 0 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.d");
            Assert.assertTrue((kv.getOrderOfField() == 2 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.e");
            Assert.assertTrue((kv.getOrderOfField() == 1 ? 1 : 0) != 0);
            System.out.println(readDoc);
        }
    }

    @Test
    public void testReplicationWithFieldOrderRowDelete() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        MapRDBTableImpl dstTable = (MapRDBTableImpl)DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        dstTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, true);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.d.e,a.b.e.f,a.b.c.d,a.c.d.e,a.d.e.f";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        Document doc = MapRDB.newDocument();
        doc.set("b.c.d", "dst_bcd").set("x.y.z", "dst_xyz");
        dstTable.insertOrReplace("key1", doc);
        dstTable.flush();
        DocumentMutation mut = MapRDB.newMutation();
        mut.set("a.c.d.e", "dst_acde");
        dstTable.update("key1", mut);
        dstTable.flush();
        mut.empty();
        mut.set("a.e.f.g", "dst_aefg");
        dstTable.update("key1", mut);
        dstTable.flush();
        mut.empty();
        mut.set("a.d.e.f", "dst_adef");
        dstTable.update("key1", mut);
        dstTable.flush();
        srcTable.delete("key1");
        srcTable.flush();
        TestRepl.waitForReplication();
        DocumentStream ds = dstTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        while (itr.hasNext()) {
            DBDocumentImpl readDoc = (DBDocumentImpl)itr.next();
            KeyValue kv = readDoc.getKeyValue("a.b.c");
            Assert.assertTrue((kv.getOrderOfField() == 0 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.b.d");
            Assert.assertTrue((kv.getOrderOfField() == 1 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.b.e");
            Assert.assertTrue((kv.getOrderOfField() == 2 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.b");
            Assert.assertTrue((kv.getOrderOfField() == 3 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.c");
            Assert.assertTrue((kv.getOrderOfField() == 0 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.d");
            Assert.assertTrue((kv.getOrderOfField() == 2 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a.e");
            Assert.assertTrue((kv.getOrderOfField() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"dst_aefg", (Object)readDoc.getString("a.e.f.g"));
            kv = readDoc.getKeyValue("b");
            Assert.assertTrue((kv.getOrderOfField() == 0 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("x");
            Assert.assertTrue((kv.getOrderOfField() == 1 ? 1 : 0) != 0);
            kv = readDoc.getKeyValue("a");
            Assert.assertTrue((kv.getOrderOfField() == 2 ? 1 : 0) != 0);
            System.out.println(readDoc);
        }
    }

    @Test
    public void testReplicationUpdatesWithSingleCFProjection() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        MapRDBTableImpl dstTable = (MapRDBTableImpl)DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        srcTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        dstTable.setOption(Table.TableOption.KEEPINSERTIONORDER, true);
        String replPaths = "a.b.c,x.y.z";
        TestRepl.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), false, replPaths);
        Document doc = MapRDB.newDocument();
        doc.set("a.b.c", "abc");
        srcTable.insertOrReplace("key1", doc);
        TestRepl.waitForReplication();
        doc.empty();
        doc.set("a.b.d", "abd");
        srcTable.insertOrReplace("key1", doc);
        TestRepl.waitForReplication();
        Document readDoc = dstTable.findById("key1");
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("a.b.d"));
        Assert.assertNull((Object)readDoc.getValue("x.y.z"));
        DocumentMutation mut = MapRDB.newMutation();
        mut.setOrReplace("a.b.c.d", "abcd");
        srcTable.update("key1", mut);
        srcTable.flush();
        TestRepl.waitForReplication();
        readDoc = dstTable.findById("key1");
        Assert.assertEquals((Object)"abcd", (Object)readDoc.getString("a.b.c.d"));
        doc.empty();
        doc.set("a.c.d", "dst_acd").set("x.z.y", "dst_xzy");
        dstTable.insertOrReplace("key1", doc);
        dstTable.flush();
        srcTable.delete("key1");
        srcTable.flush();
        readDoc = dstTable.findById("key1");
        Assert.assertEquals((Object)"dst_acd", (Object)readDoc.getString("a.c.d"));
        Assert.assertEquals((Object)"dst_xzy", (Object)readDoc.getString("x.z.y"));
        Assert.assertNull((Object)readDoc.getValue("a.b.c"));
        Assert.assertNull((Object)readDoc.getValue("x.y.z"));
    }
}

