/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.MapRDB;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.test.TestDiffCrc;
import com.mapr.db.mapreduce.tools.Import;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.ojai.Document;
import org.ojai.types.ODate;

public class TestDiffCornerCases
extends Configured
implements Tool {
    private String outdir = "/tmp/testdiff/";
    private static AdminImpl admin = (AdminImpl)MapRDB.newAdmin();
    private static String columnSpec = null;
    private static final Log LOG = LogFactory.getLog(TestDiffCrc.class);

    private MapRDBTableImpl createtable(String tPath, int srcSplitNum) {
        TableDescriptor tableDesc = MapRDB.newTableDescriptor((String)tPath).addFamily(MapRDB.newDefaultFamilyDescriptor());
        if (admin.tableExists(tPath)) {
            admin.deleteTable(tPath);
        }
        System.out.println("create table " + tPath + " with " + srcSplitNum + " splits ");
        Integer count = 1000;
        String[] srcSplitPoints = new String[srcSplitNum];
        for (int i = 1; i < srcSplitNum + 1; ++i) {
            srcSplitPoints[i - 1] = Integer.toString(i * count);
            System.out.println("\t" + (i - 1) + ": " + srcSplitPoints[i - 1]);
        }
        return (MapRDBTableImpl)admin.createTable(tableDesc, srcSplitPoints);
    }

    private void loadJSONData(MapRDBTableImpl table, int rowNum, int startRow) {
        int end = startRow + rowNum;
        if (table != null) {
            for (int start = startRow; start < end; ++start) {
                String key = Integer.toString(start);
                byte bvalue = (byte)(start % 128);
                String nvalue = new String("n" + key);
                Document d = MapRDB.newDocument();
                d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
                table.insertOrReplace(key, d);
                table.flush();
            }
        }
    }

    private void insertChanges(MapRDBTableImpl sTable, int insertBeforeKeyNum) {
        Random random = new Random();
        int key1 = random.nextInt(insertBeforeKeyNum);
        String key = Integer.toString(key1);
        byte bvalue = (byte)(key1 % 128);
        String nvalue = new String("n" + key);
        Document d = MapRDB.newDocument();
        d.set("name", nvalue).set("fbyte", bvalue).set("dvalue", ODate.parse((String)"2015-11-20")).setArray("farray", new Object[]{1, 2, 3, 4}).set("fbool", false);
        sTable.insertOrReplace(key, d);
        sTable.flush();
        System.out.println("inserted/replaced row " + key + " to table " + sTable.getName());
    }

    private static void importFromDir(String dstTableName, String srcDir) throws IOException, InterruptedException, Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", srcDir, "-dst", dstTableName, "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private static void formatResult(String inDir, String outDir) throws IOException, InterruptedException {
        TestDiffCornerCases.rmDir(outDir);
        ProcessBuilder proc = new ProcessBuilder("mapr", "formatresult", "-indir", inDir, "-outdir", outDir);
        System.out.println("Running command " + proc.command());
        Process p = proc.start();
        p.waitFor();
        System.out.println("formatresult process exit code: " + p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    private List<String> getDiffTablesWithCrcCmdParams(String outsubdir, String sPath, String dPath) {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("hadoop");
        cmdArgsList.add("com.mapr.db.mapreduce.tools.DiffTablesWithCrc");
        cmdArgsList.add("-src");
        cmdArgsList.add(sPath);
        cmdArgsList.add("-dst");
        cmdArgsList.add(dPath);
        if (columnSpec != null) {
            cmdArgsList.add("-columns");
            cmdArgsList.add(columnSpec);
        }
        cmdArgsList.add("-outdir");
        cmdArgsList.add(this.outdir + "/" + outsubdir);
        return cmdArgsList;
    }

    private void runDiffTablesWithCrc(Configuration config, String columnSpec, String srcPath, String dstPath, String outsubdir) throws Exception {
        List<String> diffArgs = this.getDiffTablesWithCrcCmdParams(outsubdir, srcPath, dstPath);
        ProcessBuilder proc = new ProcessBuilder(diffArgs);
        proc.inheritIO();
        System.out.println("Running command " + proc.command());
        Process p = proc.start();
        p.waitFor();
        System.out.println("DiffTablesWithCrc process exit code: " + p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    static int ls(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-ls", path);
        Process p = proc.start();
        p.waitFor();
        return p.exitValue();
    }

    static void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rmr", path);
        Process p = proc.start();
        p.waitFor();
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("This test difftableswithcrc with single column family.\nUsage:   hadoop com.mapr.db.mapreduce.test.TestDiffCrc -src srcTablePath -dst dstTablePath -outdir outputDirectory\n");
        System.exit(-1);
    }

    private boolean doCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                TestDiffCornerCases.printUsage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-outdir")) {
                this.outdir = args[++i];
                continue;
            }
            TestDiffCornerCases.printUsage("Unrecognized parameter " + args[i]);
        }
        return true;
    }

    public int run(String[] args) throws Exception {
        if (!this.doCommandLine(args)) {
            return -1;
        }
        String tNoRowNoSplitName = "/tmp/testtable-TestDiffNoRowNoSplit";
        String t0Row0SplitName = "/tmp/testtable-TestDiff0Row0Split";
        String t0Row1SplitName = "/tmp/testtable-TestDiff0Row1Split";
        String t0Row2SplitName = "/tmp/testtable-TestDiff0Row2Split";
        String t1Row0SplitName = "/tmp/testtable-TestDiff1Row0Split";
        String t1Row1SplitName = "/tmp/testtable-TestDiff1Row1Split";
        String t1Row2SplitName = "/tmp/testtable-TestDiff1Row2Split";
        String t2Row0SplitName = "/tmp/testtable-TestDiff2Row0Split";
        String t2Row1SplitName = "/tmp/testtable-TestDiff2Row1Split";
        String t2Row2SplitName = "/tmp/testtable-TestDiff2Row2Split";
        Configuration conf = this.getConf();
        try {
            MapRDBTableImpl tNoRowNoSplit = this.createtable(tNoRowNoSplitName, 0);
            MapRDBTableImpl t0Row0Split = this.createtable(t0Row0SplitName, 0);
            MapRDBTableImpl t0Row1Split = this.createtable(t0Row1SplitName, 1);
            MapRDBTableImpl t0Row2Split = this.createtable(t0Row2SplitName, 2);
            MapRDBTableImpl t1Row0Split = this.createtable(t1Row0SplitName, 0);
            MapRDBTableImpl t1Row1Split = this.createtable(t1Row1SplitName, 1);
            MapRDBTableImpl t1Row2Split = this.createtable(t1Row2SplitName, 2);
            MapRDBTableImpl t2Row0Split = this.createtable(t2Row0SplitName, 0);
            MapRDBTableImpl t2Row1Split = this.createtable(t2Row1SplitName, 1);
            MapRDBTableImpl t2Row2Split = this.createtable(t2Row2SplitName, 2);
            System.out.println("tables are created at the tmp directory,  please check the table splits");
            this.loadJSONData(t1Row0Split, 1, 1);
            this.loadJSONData(t1Row1Split, 1, 1);
            this.loadJSONData(t1Row2Split, 1, 1);
            this.loadJSONData(t2Row0Split, 2, 1);
            this.loadJSONData(t2Row1Split, 2, 1500);
            this.loadJSONData(t2Row2Split, 2, 2500);
            Thread.sleep(20000L);
            System.out.println("tables are loaded with data,  please check the table splits");
            System.out.println("-----Test1: run difftableswithcrc with both src and dst as empty table with no split-----");
            String outdiffdir = "samerun0Row0Split";
            this.runDiffTablesWithCrc(conf, null, tNoRowNoSplitName, t0Row0SplitName, outdiffdir);
            System.out.println("Should contain no diffs for all column families. Check the formatresult at " + this.outdir);
            int ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            System.out.println("-----Test2: run difftableswithcrc with both src and dst are the same table-----");
            outdiffdir = "sametable";
            this.runDiffTablesWithCrc(conf, null, t0Row0SplitName, t0Row0SplitName, outdiffdir);
            System.out.println("Should contain no diffs for all column families. Check the formatresult at " + this.outdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            System.out.println("-----Test3: run difftableswithcrc with both src and dst as empty table with 1 src split, 2 dst split-----");
            outdiffdir = "samerun0Row2Split";
            this.runDiffTablesWithCrc(conf, null, t0Row1SplitName, t0Row2SplitName, outdiffdir);
            System.out.println("Should contain no diffs for all column families. Check the formatresult at " + this.outdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            System.out.println("-----Test4: run difftableswithcrc with both src as empty table, dst with 1 row at first split-----");
            outdiffdir = "diffrun0Row1Row";
            this.runDiffTablesWithCrc(conf, null, t0Row0SplitName, t1Row0SplitName, outdiffdir);
            System.out.println("Should contain diffs for 1 row. Check the formatresult at " + this.outdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertEquals((long)0L, (long)ret);
            System.out.println(this.outdir + "/" + outdiffdir + "/OpsForSrcTable Should contain difference from all columnspec. Check the formatresult.");
            TestDiffCornerCases.formatResult(this.outdir + "/" + outdiffdir + "/OpsForSrcTable", this.outdir + "/" + outdiffdir + "/OpsForSrcTableDecoded");
            System.out.println("Import the result from the diff results at " + outdiffdir);
            TestDiffCornerCases.importFromDir(t0Row0SplitName, this.outdir + "/" + outdiffdir + "/" + "OpsForSrcTable");
            System.out.println("Run diff again after imported results");
            outdiffdir = "diffrun0Row1Rowsamerun3";
            this.runDiffTablesWithCrc(conf, null, t0Row0SplitName, t1Row0SplitName, outdiffdir);
            System.out.println("There should be no difference. Check the formatresult at " + outdiffdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            System.out.println("-----Test5: run difftableswithcrc with both dst as empty table, src with 2 row at second  split-----");
            outdiffdir = "diffrun2RowNoRow";
            this.runDiffTablesWithCrc(conf, null, t2Row0SplitName, tNoRowNoSplitName, outdiffdir);
            System.out.println("Should contain diffs for 1 row. Check the formatresult at " + this.outdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            TestDiffCornerCases.formatResult(this.outdir + "/" + outdiffdir + "/OpsForDstTable", this.outdir + "/" + outdiffdir + "/OpsForDstTableDecoded");
            System.out.println("Import the result from the diff results at " + outdiffdir + "diffrun2");
            TestDiffCornerCases.importFromDir(tNoRowNoSplitName, this.outdir + "/" + outdiffdir + "/" + "OpsForDstTable");
            System.out.println("Run diff again after imported results");
            outdiffdir = "diffrun2RowNoRowsamerun3";
            this.runDiffTablesWithCrc(conf, null, t2Row0SplitName, tNoRowNoSplitName, outdiffdir);
            System.out.println("There should be no difference. Check the formatresult at " + outdiffdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            System.out.println("-----Test6: run difftableswithcrc with src with 1 row at first split, dst with 2 rows at third split-----");
            outdiffdir = "diffrun1Row2Row";
            this.runDiffTablesWithCrc(conf, null, t1Row2SplitName, t2Row2SplitName, outdiffdir);
            System.out.println("Should contain diffs for 1 row. Check the formatresult at " + this.outdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertEquals((long)0L, (long)ret);
            TestDiffCornerCases.formatResult(this.outdir + "/" + outdiffdir + "/OpsForSrcTable", this.outdir + "/" + outdiffdir + "/OpsForSrcTableDecoded");
            TestDiffCornerCases.formatResult(this.outdir + "/" + outdiffdir + "/OpsForDstTable", this.outdir + "/" + outdiffdir + "/OpsForDstTableDecoded");
            System.out.println("Import the result from the diff results at " + outdiffdir);
            TestDiffCornerCases.importFromDir(t1Row2SplitName, this.outdir + "/" + outdiffdir + "/" + "OpsForSrcTable");
            TestDiffCornerCases.importFromDir(t2Row2SplitName, this.outdir + "/" + outdiffdir + "/" + "OpsForDstTable");
            outdiffdir = "diffrun1Row2Rowsamerun3";
            System.out.println("Run diff again after imported results");
            this.runDiffTablesWithCrc(conf, null, t1Row2SplitName, t2Row2SplitName, outdiffdir);
            System.out.println("There should be no difference. Check the formatresult at " + this.outdir + "/" + outdiffdir);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForDstTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            ret = TestDiffCornerCases.ls(this.outdir + "/" + outdiffdir + "/OpsForSrcTable");
            Assert.assertNotEquals((long)0L, (long)ret);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new TestDiffCornerCases(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

