/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.DocEmptySerialization;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(Export.class);
    private static final String NAME = "exporttable";
    private static boolean mapreduce = true;
    private static String tableName = null;
    private static String destPath = null;
    private static boolean preserveTimestamps = true;
    private static boolean getDeletes = true;
    private static boolean readAllCfs = false;
    private static int numThreads = 16;
    private static String columnSpec = null;
    private static String fileNamePrefix = "part";

    private static Job createSubmittableJob(Configuration conf) throws IOException {
        conf.set("maprdb.mapreduce.inputtable", tableName);
        if (columnSpec != null) {
            conf.set("maprdb.mapreduce.fieldpath", columnSpec);
            conf.setBoolean("maprdb.read.all.cfs", readAllCfs);
        }
        conf.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        conf.setBoolean("maprdb.table.impl.decompress", false);
        conf.setBoolean("maprdb.table.impl.get_deletes", getDeletes);
        Path path = new Path(destPath);
        Job job = new Job(conf, "exporttable_" + tableName);
        job.setJarByClass(Export.class);
        Configuration config = job.getConfiguration();
        config.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DocEmptySerialization.class.getName()});
        job.setMapperClass(Exporter.class);
        job.setInputFormatClass(TableInputFormat.class);
        MapReduceUtilMethods.setStartStopRow((Configuration)config);
        job.setSpeculativeExecution(false);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(ByteBufWritableComparable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)path);
        return job;
    }

    private void ParseArgs(String[] args) throws Exception {
        Path tablePath;
        Configuration conf;
        MapRFileSystem mfs;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-src")) {
                    tableName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-dst")) {
                    destPath = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-mapreduce")) {
                    mapreduce = Boolean.valueOf(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-columns")) {
                    columnSpec = args[++i];
                    continue;
                }
                System.err.println("Invalid argument: " + args[i]);
                this.Usage(null);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Invalid command line arguments.");
            this.Usage(null);
        }
        if (tableName == null || destPath == null) {
            this.Usage("missing -src or -dst.");
        }
        if (!(mfs = (MapRFileSystem)FileSystem.get((Configuration)(conf = new Configuration()))).exists(tablePath = new Path(tableName))) {
            this.Usage(tablePath + " does not exist");
        }
        if (!mfs.isJsonTable(tablePath)) {
            this.Usage(tablePath + " is not a JSON table. This tool only supports JSON tables");
        }
    }

    private void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: exporttable [options] -src <Input table name> -dst <dest directory>\n[-columns <JSON Fieldpaths specified as \"path1,...,pathN\">][-mapreduce : <true|false> (default: true)]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new Export(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private int run_NonMR(String[] args) throws Exception {
        Path dirPath = new Path(destPath);
        Configuration config = this.getConf();
        if (dirPath.getFileSystem(config).exists(dirPath)) {
            throw new FileAlreadyExistsException("Output directory " + dirPath + " already exists");
        }
        dirPath = dirPath.getFileSystem(config).makeQualified(dirPath);
        config.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        config.setBoolean("maprdb.table.impl.decompress", false);
        config.setBoolean("maprdb.table.impl.get_deletes", getDeletes);
        Table srcTable = MapRDB.getTable((String)tableName);
        TabletInfo[] tabletInfos = srcTable.getTabletInfos();
        int numSplits = tabletInfos.length;
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (int i = 0; i < numSplits; ++i) {
            Future<Integer> f = executor.submit(new ExporterThread(i, tabletInfos[i], config));
            futures.add(f);
        }
        int numFailures = 0;
        for (Future future : futures) {
            numFailures += ((Integer)future.get()).intValue();
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (numFailures == 0) {
            Export.doCleanup();
        }
        return numFailures == 0 ? 0 : 1;
    }

    private static void doCleanup() {
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        this.ParseArgs(otherArgs);
        if (!mapreduce) {
            return this.run_NonMR(otherArgs);
        }
        Job job = Export.createSubmittableJob(conf);
        int retval = job.waitForCompletion(true) ? 0 : 1;
        return retval;
    }

    public static class Exporter
    extends Mapper<Value, Document, ByteBufWritableComparable, ByteBufWritableComparable> {
        public void map(Value key, Document value, Mapper.Context context) throws IOException, InterruptedException {
            ByteBufWritableComparable serializedDoc = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)value));
            ByteBufWritableComparable serializedKey = new ByteBufWritableComparable(IdCodec.encode((Value)key));
            context.write((Object)serializedKey, (Object)serializedDoc);
        }
    }

    class ExporterThread
    implements Callable<Integer> {
        protected TabletInfo tabletInfo;
        protected int myid;
        protected Configuration config;

        ExporterThread(int id, TabletInfo t, Configuration config) {
            this.tabletInfo = t;
            this.myid = id;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() {
            QueryCondition c = this.tabletInfo.getCondition();
            MapRDBTableImpl srcTable = null;
            try {
                srcTable = new MapRDBTableImpl(new Path(tableName), this.config);
                DocumentStream rs = null;
                if (columnSpec != null) {
                    srcTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.READ_ALL_CFS, readAllCfs);
                    rs = srcTable.find(c, MapReduceUtilMethods.getFieldPaths((String)columnSpec));
                } else {
                    rs = srcTable.find(c);
                }
                Iterator iterator = rs.iterator();
                if (!destPath.endsWith("/")) {
                    destPath = destPath + "/";
                }
                Path outputPath = new Path(destPath + fileNamePrefix + Integer.toString(this.myid));
                FileSystem fs = MapRFileSystem.get((Configuration)this.config);
                SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.config, (Path)outputPath, ByteBufWritableComparable.class, ByteBufWritableComparable.class);
                ByteBufWritableComparable key = null;
                ByteBufWritableComparable value = null;
                while (iterator.hasNext()) {
                    Document doc = (Document)iterator.next();
                    key = new ByteBufWritableComparable(IdCodec.encode((Value)doc.getId()));
                    value = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc));
                    writer.append((Writable)key, (Writable)value);
                }
                writer.close();
            }
            catch (Exception e) {
                LOG.error("exporttable encountered an exception: " + e.getMessage());
                e.printStackTrace();
                Integer n = 1;
                return n;
            }
            finally {
                try {
                    if (srcTable != null) {
                        srcTable.close();
                    }
                }
                catch (Exception e) {
                    LOG.error("exporttable encountered an exception: " + e.getMessage());
                    e.printStackTrace();
                    return 1;
                }
            }
            return 0;
        }
    }
}

