/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import com.mapr.db.mapreduce.impl.DocEmptySerialization;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.mapreduce.impl.TableSplit;
import com.mapr.db.mapreduce.tools.DiffTablesMeta;
import com.mapr.db.mapreduce.tools.impl.DiffTableComparator;
import com.mapr.db.mapreduce.tools.impl.DiffTableCounterCollector;
import com.mapr.db.mapreduce.tools.impl.DiffTableNonMR;
import com.mapr.db.mapreduce.tools.impl.DocScanner;
import com.mapr.db.mapreduce.tools.impl.FailureTracker;
import com.mapr.db.mapreduce.tools.impl.RowDiff;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffTables
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(DiffTables.class);
    public static final String NAME = "difftables";
    static String table1Path;
    static String table2Path;
    static String columnSpec;
    static boolean mapreduce;
    static int defaultNumThreads;
    static int numThreads;
    static String outDir;
    static boolean exitOnFirstDiff;
    static boolean cmpMeta;
    static boolean excludedEmbeddedFamily;
    static String splitKeyRangeFileName;
    static String includeKeyRangeFileName;
    static final String table1PathConf = "maprdb.mapreduce.inputtable";
    static final String table2PathConf = "table2Pathconf";
    static final String outDirConf = "outdirconf";
    static final String columnSpecConf = "columnspeccconf";
    static final String exitOnFirstDiffConf = "exitonfirstdiffconf";

    public static String getOpsForTableName(String table) {
        return "OpsForTable_" + table;
    }

    private Job setupJobWithMR() throws Exception {
        Configuration conf = this.getConf();
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DocEmptySerialization.class.getName()});
        Job job = Job.getInstance((Configuration)conf, (String)NAME);
        job.setJarByClass(DiffTables.class);
        job.setInputFormatClass(TableInputFormat.class);
        job.setMapperClass(DiffTableMapper.class);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(ByteBufWritableComparable.class);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(conf.get(outDirConf)));
        job.setSpeculativeExecution(false);
        LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    public int run(String[] args) throws Exception {
        DiffTables.parseArgs(args);
        int ret = 0;
        if (cmpMeta && (ret = this.compareMeta(args)) != 0) {
            return ret;
        }
        if (!cmpMeta) {
            System.out.println("Skip metadata check.");
        }
        Configuration conf = this.getConf();
        this.setupConfParmas(conf);
        String[] fields = null;
        if (columnSpec != null) {
            fields = columnSpec.split(",");
        }
        if (!mapreduce) {
            DiffTableNonMR d = new DiffTableNonMR(conf, table1Path, table2Path, fields, numThreads, exitOnFirstDiff, excludedEmbeddedFamily, outDir);
            return d.runWithoutMapReduce();
        }
        Job job = this.setupJobWithMR();
        int n = ret = job.waitForCompletion(true) ? 0 : 1;
        if (ret == 0) {
            Path srcDir = new Path(outDir);
            FileSystem fs = srcDir.getFileSystem(conf);
            boolean mv1 = DiffTableUtils.copyFileWithPrefix((FileSystem)fs, (Path)srcDir, (Path)new Path(outDir + "/OpsForDstTable"), (Configuration)conf, (String)"OpsForDstTable", (Logger)LOG);
            boolean mv2 = DiffTableUtils.copyFileWithPrefix((FileSystem)fs, (Path)srcDir, (Path)new Path(outDir + "/OpsForSrcTable"), (Configuration)conf, (String)"OpsForSrcTable", (Logger)LOG);
            if (!mv1 || !mv2) {
                LOG.info("Failed to move output diff results " + outDir + " into its sub folder opsForSrc or opsForDst");
            }
            Counters counters = job.getCounters();
            Counter srcMismatch = counters.findCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_SRC);
            Counter dstMismatch = counters.findCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_DST);
            System.out.print("Mapreduce job " + (ret == 0 ? "completed. " : "failed. "));
            boolean printcounter = false;
            if (ret == 0) {
                if (srcMismatch.getValue() == 0L && dstMismatch.getValue() == 0L) {
                    System.out.println("The tables match.");
                } else {
                    System.out.println("The tables mismatch.");
                    printcounter = true;
                }
            } else {
                printcounter = true;
            }
            if (printcounter) {
                System.out.println(srcMismatch.getDisplayName() + ":" + srcMismatch.getValue() + "; " + dstMismatch.getDisplayName() + ":" + dstMismatch.getValue() + ". Please check diff in " + outDir);
            }
        }
        return ret;
    }

    private int compareMeta(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)this.getConf(), (Tool)new DiffTablesMeta(true), (String[])args);
        if (ret == 1) {
            System.out.println("ERROR: Metadata is different.");
            System.out.println("To skip metadata comparison, use the option -cmpmeta false.");
            System.exit(ret);
        } else if (ret == 0) {
            System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
        }
        return ret;
    }

    private void setupConfParmas(Configuration conf) {
        conf.set(table1PathConf, table1Path);
        conf.set(table2PathConf, table2Path);
        conf.set(outDirConf, outDir);
        if (columnSpec != null) {
            conf.set(columnSpecConf, columnSpec);
            conf.set("maprdb.mapreduce.fieldpath", columnSpec);
        }
        conf.setBoolean(exitOnFirstDiffConf, exitOnFirstDiff);
        conf.setBoolean("maprdb.exclude.embedded", excludedEmbeddedFamily);
        if (splitKeyRangeFileName != null) {
            conf.set("splitfilename", splitKeyRangeFileName);
        }
        if (includeKeyRangeFileName != null) {
            conf.set("includedregionfilename", includeKeyRangeFileName);
        }
    }

    public static void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                DiffTables.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-src")) {
                table1Path = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                table2Path = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-exclude_embedded_families")) {
                excludedEmbeddedFamily = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                System.out.println("M/R difftables");
                mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-outdir")) {
                outDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-first_exit")) {
                exitOnFirstDiff = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmpmeta")) {
                cmpMeta = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-split_keyrange")) {
                splitKeyRangeFileName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-keyrange_included")) {
                includeKeyRangeFileName = args[++i];
                continue;
            }
            DiffTables.Usage(null);
        }
        if (table1Path == null || table2Path == null) {
            DiffTables.Usage("missing -src or -dst table path.");
        }
        if (table1Path.equals(table2Path)) {
            System.out.println("Source table " + table1Path + " and destination table " + table2Path + " refers to the same table");
            System.exit(-1);
        }
        if (outDir == null) {
            DiffTables.Usage("Missing -outdir");
        }
        if (mapreduce && numThreads != 0) {
            DiffTables.Usage("-numthreads can't be specified when -mapreduce is true");
        }
        if (!mapreduce && numThreads == 0) {
            numThreads = defaultNumThreads;
        }
        Configuration conf = new Configuration();
        MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)conf);
        Path t1Path = new Path(table1Path);
        Path t2Path = new Path(table2Path);
        if (!mfs.exists(t1Path)) {
            DiffTables.Usage(t1Path + " does not exist");
        }
        if (!mfs.isJsonTable(t1Path)) {
            DiffTables.Usage(t1Path + " is not a JSON table. This tool only supports JSON tables");
        }
        if (!mfs.exists(t2Path)) {
            DiffTables.Usage(t2Path + " does not exist");
        }
        if (!mfs.isJsonTable(t2Path)) {
            DiffTables.Usage(t2Path + " is not a JSON table. This tool only supports JSON tables");
        }
        columnSpec = MapReduceUtilMethods.processColumnSpec((String)columnSpec, (String)table1Path);
        LOG.info("Comparing {} column families from {} to {}.", new Object[]{columnSpec != null ? columnSpec : "all", table1Path, table2Path});
        Admin admin = MapRDB.newAdmin();
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(table1Path);
        if (desc.isStream()) {
            excludedEmbeddedFamily = true;
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: difftables -src <source table path> -dst <destination table path> -outdir <output directory>\n[-first_exit] Exit when first difference is found.\n[-columns <comma separated list of field paths> ]\n[-exclude_embedded_families <true|false>] (default: false)\n  Don't include the  other column families with path embedded in specified columns\n[-mapreduce] <true|false> (default: true)]\n[-numthreads <numThreads> (default:16, valid only when -mapreduce is false)]\n[-cmpmeta <true|false> (default: true)]\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTables(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    static {
        mapreduce = true;
        defaultNumThreads = 16;
        numThreads = 0;
        cmpMeta = true;
        splitKeyRangeFileName = null;
        includeKeyRangeFileName = null;
    }

    public static class DiffTableMapper
    extends Mapper<Value, DBDocumentImpl, ByteBufWritableComparable, ByteBufWritableComparable>
    implements FailureTracker {
        private DocScanner scanner2 = null;
        private Path opsTable1Dir = null;
        private Path opsTable2Dir = null;
        private DiffTableCounterCollector counter = null;
        private DiffTableComparator comparator = null;
        private boolean exitOnFirstMismatch = false;
        private boolean shouldExit = false;
        private MultipleOutputs<ByteBufWritableComparable, ByteBufWritableComparable> mos = null;

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            String table2Path = conf.get(DiffTables.table2PathConf);
            boolean exclude_embeddedFamily = Boolean.valueOf(conf.get("exclude_embeddedfamily"));
            String[] fields = null;
            String cols = conf.get(DiffTables.columnSpecConf);
            if (cols != null) {
                fields = cols.split(",");
            }
            TableSplit currentSplit = (TableSplit)context.getInputSplit();
            this.scanner2 = new DocScanner(table2Path, (QueryCondition)currentSplit.getCondition(), fields, exclude_embeddedFamily);
            String outDir = conf.get(DiffTables.outDirConf);
            Path[] paths = DiffTableUtils.createOutputDirs((FileSystem)FileSystem.get((Configuration)conf), (Path)new Path(outDir));
            this.opsTable1Dir = paths[0];
            this.opsTable2Dir = paths[1];
            this.counter = new DiffTableCounterCollector(FileSystem.get((Configuration)conf), this.opsTable1Dir, this.opsTable2Dir, conf, this);
            this.comparator = new DiffTableComparator(conf.get(DiffTables.table1PathConf), conf.get(DiffTables.table2PathConf), this.counter);
            this.exitOnFirstMismatch = conf.getBoolean(DiffTables.exitOnFirstDiffConf, false);
            if (this.mos == null) {
                this.mos = new MultipleOutputs((TaskInputOutputContext)context);
            }
        }

        public void map(Value key, DBDocumentImpl value, Mapper.Context context) throws IOException, InterruptedException {
            this.counter.incTable1Rows();
            ArrayList<RowDiff> diffs = this.comparator.processNextRowAndReturnDiff(value, this.scanner2);
            this.writeDiffsToFile(diffs, context);
        }

        private void writeDiffsToFile(ArrayList<RowDiff> diffs, Mapper.Context context) throws IOException, InterruptedException {
            for (RowDiff d : diffs) {
                if (d.forSrc != null) {
                    this.writeDiff(d.key, d.forSrc, true, context);
                }
                if (d.forDst == null) continue;
                this.writeDiff(d.key, d.forDst, false, context);
            }
        }

        private void writeDiff(ByteBufWritableComparable key, ByteBufWritableComparable value, boolean isSrc, Mapper.Context context) throws IOException, InterruptedException {
            LOG.debug(this.opsTable1Dir.getName());
            LOG.debug(this.opsTable2Dir.getName());
            if (isSrc) {
                this.mos.write((Object)key, (Object)value, this.opsTable1Dir.getName());
                context.getCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_SRC).increment(1L);
            } else {
                this.mos.write((Object)key, (Object)value, this.opsTable2Dir.getName());
                context.getCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_DST).increment(1L);
            }
        }

        @Override
        public void notifyMismatch() {
            if (this.exitOnFirstMismatch) {
                this.shouldExit = true;
            }
        }

        @Override
        public boolean shouldExit() {
            return this.shouldExit;
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            ArrayList<RowDiff> remainingRows = this.dumpRemainingRows();
            LOG.debug("cleanup find " + remainingRows.size() + " remaining rows");
            this.writeDiffsToFile(remainingRows, context);
            this.mos.close();
        }

        private ArrayList<RowDiff> dumpRemainingRows() {
            DBDocumentImpl doc2 = this.scanner2.getNext();
            ArrayList<RowDiff> diffs = new ArrayList<RowDiff>();
            while (doc2 != null) {
                RowDiff d = new RowDiff();
                d.key = new ByteBufWritableComparable(IdCodec.encode((Value)doc2.getId()));
                d.forSrc = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc2));
                diffs.add(d);
                doc2 = this.scanner2.getNext();
            }
            return diffs;
        }
    }

    public static enum COUNTERS {
        NUM_ROWS_MISMATCH_IN_SRC,
        NUM_ROWS_MISMATCH_IN_DST;

    }
}

