/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestDiffTableUtils
extends Configured
implements Tool {
    static String tableFileName = null;
    static String segKeyRangeFileName = null;
    static String segKeyRangeDirName = null;
    static Operation operation = Operation.READ;
    private static final Log LOG = LogFactory.getLog(TestDiffTableUtils.class);

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("This utility is used to read and write segment key ranges.\nUsage:To print this message:\n   hadoop com.mapr.db.mapreduce.test.TestDiffTableUtils [-h, --help]\nTo write the segment key range file for a table:\n   hadoop com.mapr.db.mapreduce.test.TestDiffTableUtils [-w, --write] tablename segkeyfilename\nTo read the segment key range from a file:\n   hadoop com.mapr.db.mapreduce.test.TestDiffTableUtils [-r, --read] segkeyfilename\nTo dump the segment key ranges (first write then read keyrange) from a table:\n   hadoop com.mapr.db.mapreduce.test.TestDiffTableUtils [-d, --dump] tablename segkeyfilename\nTo split the segment key ranges by tablet (each table's keys will be written to a seperate file ):\n   hadoop com.mapr.db.mapreduce.test.TestDiffTableUtils [-s, --split] tablename segkeyoutdir\n");
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 1) {
            TestDiffTableUtils.printUsage(null);
            return false;
        }
        try {
            String cmd = args[0];
            if (cmd.equals("-h") || cmd.startsWith("--h")) {
                TestDiffTableUtils.printUsage(null);
                return false;
            }
            if (cmd.equals("-w") || cmd.startsWith("--write")) {
                if (args.length < 3) {
                    TestDiffTableUtils.printUsage(null);
                    return false;
                }
                operation = Operation.WRITE;
                tableFileName = args[1];
                segKeyRangeFileName = args[2];
                return true;
            }
            if (cmd.equals("-r") || cmd.startsWith("--read")) {
                if (args.length < 2) {
                    TestDiffTableUtils.printUsage(null);
                    return false;
                }
                operation = Operation.READ;
                segKeyRangeFileName = args[1];
                return true;
            }
            if (cmd.equals("-d") || cmd.startsWith("--dump")) {
                if (args.length < 3) {
                    TestDiffTableUtils.printUsage(null);
                    return false;
                }
                operation = Operation.DUMP;
                tableFileName = args[1];
                segKeyRangeFileName = args[2];
                return true;
            }
            if (cmd.equals("-s") || cmd.startsWith("--split")) {
                if (args.length < 3) {
                    TestDiffTableUtils.printUsage(null);
                    return false;
                }
                operation = Operation.SPLIT;
                tableFileName = args[1];
                segKeyRangeDirName = args[2];
                return true;
            }
            TestDiffTableUtils.printUsage(null);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            TestDiffTableUtils.printUsage("Can't start because " + e.getMessage());
            return false;
        }
    }

    public int run(String[] args) throws Exception {
        if (!TestDiffTableUtils.doCommandLine(args)) {
            return 1;
        }
        Configuration conf = this.getConf();
        try {
            if (operation == Operation.READ) {
                LOG.info((Object)("Read segment key ranges from file" + segKeyRangeFileName.toString()));
                List startKeys = DiffTableUtils.readKeyRange((Configuration)conf, (String)segKeyRangeFileName);
                DiffTableUtils.printKeyRange((List)startKeys);
            } else if (operation == Operation.WRITE) {
                LOG.info((Object)("Write segment key ranges of table " + tableFileName + " to file " + segKeyRangeFileName.toString()));
                DiffTableUtils.writeSegKeyRange((String)segKeyRangeFileName, (String)tableFileName);
            } else if (operation == Operation.DUMP) {
                LOG.info((Object)("Get segment key ranges of table " + tableFileName + ", outputfile is " + segKeyRangeFileName.toString()));
                DiffTableUtils.writeSegKeyRange((String)segKeyRangeFileName, (String)tableFileName);
                List startKeys2 = DiffTableUtils.readKeyRange((Configuration)conf, (String)segKeyRangeFileName);
                System.out.println("\nStartKeys read back from file " + segKeyRangeFileName + " :\n");
                DiffTableUtils.printKeyRange((List)startKeys2);
                System.out.println("\nStart End Keys from the table");
                Table table = MapRDB.getTable((String)tableFileName);
                TabletInfo[] tabletInfos = table.getTabletInfos();
                ArrayList<ConditionNode.RowkeyRange> ret = new ArrayList<ConditionNode.RowkeyRange>(tabletInfos.length);
                for (TabletInfo tInfo : tabletInfos) {
                    ret.add(((TabletInfoImpl)tInfo).getRowKeyRange());
                }
                table.close();
                DiffTableUtils.printKeyRanges(ret);
                System.out.println("\nStart End Keys generated from start keys");
                List gensekeys = DiffTableUtils.GenStartEndKeys((List)startKeys2);
                DiffTableUtils.printKeyRanges((List)gensekeys);
            } else if (operation == Operation.SPLIT) {
                LOG.info((Object)("segKeyRangeDirName = (" + segKeyRangeDirName + ")"));
                DiffTableUtils.writeSegKeyRange((String)(segKeyRangeDirName + "/" + DiffTableUtils.getSegKeyFileName((String)tableFileName)), (String)tableFileName);
                DiffTableUtils.writeTabletKeyRange((String)(segKeyRangeDirName + "/" + DiffTableUtils.getTabletKeyFileName((String)tableFileName)), (String)tableFileName);
                DiffTableUtils.splitSubRegionKeysbyRegionKeys((String)(segKeyRangeDirName + "/" + DiffTableUtils.getTabletKeyFileName((String)tableFileName)), (String)(segKeyRangeDirName + "/" + DiffTableUtils.getSegKeyFileName((String)tableFileName)), (String)(segKeyRangeDirName + "/" + DiffTableUtils.getReSplitedTabletKeyFileName((String)tableFileName)), (String)(segKeyRangeDirName + "/" + DiffTableUtils.getSegKeyDirName((String)tableFileName)));
            } else {
                System.err.println("Operation is not Recognized.");
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new TestDiffTableUtils(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    static enum Operation {
        READ,
        WRITE,
        DUMP,
        SPLIT;

    }
}

