/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.MapRDB;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.tools.CopyTable;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestCopyTable
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCopyTable.class);
    private static final String SRC_PATH = "/testtable-TestCopyTableSrc";
    private static final String DST_PATH = "/testtable-TestCopyTableDst";
    private static AdminImpl admin = null;
    private static MapRDBTableImpl srcTable = null;
    private static MapRDBTableImpl dstTable = null;
    private static boolean mapreduce = false;
    private static boolean bulkload = false;
    private static boolean isMarlin = false;
    private static boolean cmpmeta = true;
    private static String columnSpec = null;
    private static String startRow = null;
    private static String stopRow = null;
    private static Integer numThreads = -1;

    @Before
    public void setupTestCopyTable() throws Exception {
        admin = (AdminImpl)MapRDB.newAdmin();
        TableDescriptor tableDesc = MapRDB.newTableDescriptor((String)SRC_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"a.b")).addFamily(MapRDB.newFamilyDescriptor((String)"cf2", (String)"a.b.c.d")).addFamily(MapRDB.newFamilyDescriptor((String)"cf3", (String)"x.y"));
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        srcTable = (MapRDBTableImpl)admin.createTable(tableDesc);
        this.loadJSONData(srcTable);
    }

    @After
    public void cleanupTestCopyTable() throws Exception {
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
    }

    private String[] getCopyTableCmdParams() {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("-src");
        cmdArgsList.add(SRC_PATH);
        cmdArgsList.add("-dst");
        cmdArgsList.add(DST_PATH);
        cmdArgsList.add("-mapreduce");
        cmdArgsList.add(Boolean.toString(mapreduce));
        cmdArgsList.add("-bulkload");
        cmdArgsList.add(Boolean.toString(bulkload));
        cmdArgsList.add("-cmpmeta");
        cmdArgsList.add(Boolean.toString(cmpmeta));
        if (columnSpec != null) {
            cmdArgsList.add("-columns");
            cmdArgsList.add(columnSpec);
        }
        if (startRow != null) {
            cmdArgsList.add("-startRow");
            cmdArgsList.add(startRow);
        }
        if (stopRow != null) {
            cmdArgsList.add("-stopRow");
            cmdArgsList.add(stopRow);
        }
        if (numThreads > 0) {
            cmdArgsList.add("-numthreads");
            cmdArgsList.add(Integer.toString(numThreads));
        }
        String[] cmdArgs = new String[cmdArgsList.size()];
        return cmdArgsList.toArray(cmdArgs);
    }

    private String[] getDiffTableCmdParams() {
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        cmdArgsList.add("-src");
        cmdArgsList.add(SRC_PATH);
        cmdArgsList.add("-dst");
        cmdArgsList.add(DST_PATH);
        cmdArgsList.add("-mapreduce");
        cmdArgsList.add(Boolean.toString(mapreduce));
        cmdArgsList.add("-cmpmeta");
        cmdArgsList.add(Boolean.toString(cmpmeta));
        if (columnSpec != null) {
            cmdArgsList.add("-columns");
            cmdArgsList.add(columnSpec);
        }
        cmdArgsList.add("-outdir");
        cmdArgsList.add("/tmp/difftables/logs_" + System.currentTimeMillis());
        if (numThreads > 0) {
            cmdArgsList.add("-numthreads");
            cmdArgsList.add(Integer.toString(numThreads));
        }
        String[] cmdArgs = new String[cmdArgsList.size()];
        return cmdArgsList.toArray(cmdArgs);
    }

    private void loadJSONData(MapRDBTableImpl table) throws Exception {
        Integer start = 100000;
        if (table != null) {
            while (start < 200000) {
                Integer n = start;
                Integer n2 = start = Integer.valueOf(start + 1);
                String key = Integer.toString(n);
                Document d = MapRDB.newDocument();
                d.set("a.b.d", true).setArray("a.b.c.d.e", new Object[]{1, 2, 3, 4}).set("x.y.z", "value1");
                table.insertOrReplace(key, d);
                table.flush();
            }
        }
    }

    private void runCopyTable(Configuration config, boolean mapReduce, boolean bulkLoad, String columnSpec) throws Exception {
        mapreduce = mapReduce;
        bulkload = bulkLoad;
        TestCopyTable.columnSpec = columnSpec;
        String[] args = this.getCopyTableCmdParams();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)config, (Tool)new CopyTable(), (String[])args);
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("CopyTable with mapreduce=" + Boolean.toString(mapreduce) + " bulkload=" + Boolean.toString(bulkload) + " for src=" + SRC_PATH + ", dst=" + DST_PATH + " failed.");
            throw e;
        }
    }

    private void runDiffTables(Configuration config, boolean mapReduce, String columnSpec) throws Exception {
        mapreduce = mapReduce;
        TestCopyTable.columnSpec = columnSpec;
        String[] args = this.getDiffTableCmdParams();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)config, (Tool)new DiffTables(), (String[])args);
            Assert.assertEquals((long)ret, (long)0L);
        }
        catch (Exception e) {
            _logger.error("DiffTables with mapreduce=" + Boolean.toString(mapreduce) + " bulkload=" + Boolean.toString(bulkload) + " for src=" + SRC_PATH + ", dst=" + DST_PATH + " failed.");
            throw e;
        }
    }

    @Test
    public void testCopyTableJSON_No_MR_No_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, false, false, null);
        this.runDiffTables(config, false, null);
    }

    @Ignore(value="Enable after bug 20120 is fixed.")
    @Test
    public void testCopyTableJSON_MR_No_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, true, false, null);
        this.runDiffTables(config, false, null);
    }

    @Test
    public void testCopyTableJSON_No_MR_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, false, true, null);
        this.runDiffTables(config, false, null);
    }

    @Ignore(value="Enable after bug 20120 is fixed.")
    @Test
    public void testCopyTableJSON_MR_BulkLoad() throws Exception {
        Configuration config = new Configuration();
        this.runCopyTable(config, true, true, null);
        this.runDiffTables(config, true, null);
    }

    @Ignore(value="Enable after fixing FormatResult.")
    @Test
    public void testCopyTableJSON_No_MR_With_Projection() throws Exception {
        Configuration config = new Configuration();
        String columnspec = new String("a.b.c, x.y, a.b.d");
        this.runCopyTable(config, false, false, columnspec);
        this.runDiffTables(config, false, columnspec);
    }

    @Test
    public void testCopyTableJSON_Asymmetric_CFs_Compare_Meta() throws Exception {
        Configuration config = new Configuration();
        if (admin == null) {
            admin = (AdminImpl)MapRDB.newAdmin();
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        TableDescriptor tableDesc = MapRDB.newTableDescriptor((String)DST_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"a.b"));
        dstTable = (MapRDBTableImpl)admin.createTable(tableDesc);
        try {
            this.runCopyTable(config, false, false, null);
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("CopyTable failed : " + e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testCopyTableJSON_Asymmetric_CFs_No_Compare_Meta() throws Exception {
        Configuration config = new Configuration();
        cmpmeta = false;
        if (admin == null) {
            admin = (AdminImpl)MapRDB.newAdmin();
        }
        if (admin.tableExists(DST_PATH)) {
            admin.deleteTable(DST_PATH);
        }
        if (admin.tableExists(SRC_PATH)) {
            admin.deleteTable(SRC_PATH);
        }
        TableDescriptor srcTableDesc = MapRDB.newTableDescriptor((String)SRC_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor());
        srcTable = (MapRDBTableImpl)admin.createTable(srcTableDesc);
        this.loadJSONData(srcTable);
        TableDescriptor dstTableDesc = MapRDB.newTableDescriptor((String)DST_PATH).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"a.b"));
        dstTable = (MapRDBTableImpl)admin.createTable(dstTableDesc);
        try {
            this.runCopyTable(config, false, false, null);
        }
        catch (Exception e) {
            _logger.error("CopyTable failed : " + e.getMessage());
            throw e;
        }
        this.runDiffTables(config, false, null);
    }
}

