/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl;

import com.mapr.baseutils.Errno;
import com.mapr.fs.ShimLoader;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.DuplicateSequenceException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.WakeupException;

public class MarlinClient {
    public static RuntimeException jniErrToException(int errCode, String msg) {
        if (errCode < 0) {
            errCode = -errCode;
        }
        switch (errCode) {
            case 0: {
                return null;
            }
            case 1: {
                return new UnknownTopicOrPartitionException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 2: {
                return new UnknownTopicOrPartitionException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 116: {
                return new UnknownTopicOrPartitionException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 13: {
                return new IllegalArgumentException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 62: {
                return new TimeoutException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 5: {
                return new CorruptRecordException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 22: {
                return new IllegalArgumentException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 17: {
                return new DuplicateSequenceException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 127: {
                return new UnknownProducerIdException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
            }
            case 4: {
                return new WakeupException();
            }
        }
        return new KafkaException(Errno.toString((int)errCode) + " (" + errCode + ") " + msg);
    }

    static {
        ShimLoader.load();
    }
}

