/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerBasicTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerBasicTest.class);
    private static final String STREAM = "/jtest-" + ProducerBasicTest.class.getSimpleName();
    private static Admin madmin;
    private static final int numParts = 10;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        try {
            madmin.deleteStream(STREAM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(10);
        madmin.createStream(STREAM, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        madmin.deleteStream(STREAM);
    }

    @Test
    public void testSendOneSmallMessageWithMulHeaders() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 1, 10, 0, 10, 1, 10000L, true, false, 200, 0x2000000L, 300000L));
    }

    @Test
    public void testSendMulSmallMessageWithMulHeader() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 10, 10, 0, 10, 1, 10000L, true, false, 200, 0x2000000L, 300000L));
    }

    @Test
    public void testSendOneSmallMessage() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 1, 1, 0, 10, 1, 10000L, true, false, 200, 0x2000000L, 300000L));
    }

    @Test
    public void testSendOneLargeMessage() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 1, 1, 0, 10, 1, 10000L, true, false, 0x200000, 0x100000L, 300000L));
    }

    @Test
    public void testSendOneMediumMessage() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 1, 1, 0, 10, 1, 10000L, true, false, 943718, 0x100000L, 300000L));
    }

    @Test
    public void testSendThousandTopics() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 1000, 1000, 0, 10, 1, 10000L, true, true, 200, 0x2000000L, 300000L));
    }

    @Test
    public void testSendThousandTopicsWithRefresh() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 1000, 1011, 0, 10, 1, 10000L, true, true, 200, 0x2000000L, 1000L));
    }

    @Test
    public void testSendTenTopicsMediumMessages() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 100, 10, 0, 10, 1, 10000L, true, true, 943718, 0x100000L, 300000L));
    }

    @Test
    public void testSendTenTopicsLargeMessages() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 100, 10, 0, 10, 1, 10000L, true, true, 0x200000, 0x100000L, 300000L));
    }

    @Test
    public void testMixedSpeedTopics() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runBasicTest(STREAM, 10000, 100, 100, 10, 1, 10000L, true, true, 200, 0x2000000L, 300000L));
    }
}

