/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.listener;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class TestConsumerInterceptor
implements ConsumerInterceptor<byte[], byte[]> {
    private static AtomicInteger onConsumeCount = new AtomicInteger(0);
    private static AtomicInteger onCommitCount = new AtomicInteger(0);
    private static AtomicInteger numPartitionsOnCommit = new AtomicInteger(0);
    private static AtomicInteger numRecordsOnConsume = new AtomicInteger(0);

    public void resetCounters() {
        onConsumeCount.set(0);
        onCommitCount.set(0);
        numPartitionsOnCommit.set(0);
        numRecordsOnConsume.set(0);
    }

    public int getNumParttionsOnCommit() {
        return numPartitionsOnCommit.get();
    }

    public int getNumRecordsOnConsume() {
        return numRecordsOnConsume.get();
    }

    public int getOnConsumeCount() {
        return onConsumeCount.get();
    }

    public int getOnCommitCount() {
        return onCommitCount.get();
    }

    public void configure(Map<String, ?> configs) {
    }

    public ConsumerRecords<byte[], byte[]> onConsume(ConsumerRecords<byte[], byte[]> records) {
        onConsumeCount.getAndIncrement();
        numRecordsOnConsume.getAndAdd(records.count());
        return records;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        onCommitCount.getAndIncrement();
        numPartitionsOnCommit.getAndAdd(offsets.size());
    }

    public void close() {
    }
}

