/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.xcr;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.listener.ListenerPerformance;
import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class CopyTableTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(CopyTableTest.class);
    private static final String SRCSTREAM = "/jtest-src-" + CopyTableTest.class.getSimpleName();
    private static final String DSTSTREAM = "/jtest-dst-" + CopyTableTest.class.getSimpleName();
    private static final String SRCSTREAMMR = SRCSTREAM + "MR";
    private static final String DSTSTREAMMR = DSTSTREAM + "MR";
    private static final String SRCSTREAMNOMR = SRCSTREAM + "NOMR";
    private static final String DSTSTREAMNOMR = DSTSTREAM + "NOMR";
    private static Admin madmin;
    private static final int numParts = 1;
    private static final int numMsgs = 100000;
    private static final int numTopics = 30;
    private static boolean NoMRfailed;
    private static boolean MRfailed;

    @BeforeClass
    public static void setupTestClass() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        try {
            madmin.deleteStream(SRCSTREAMMR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            madmin.deleteStream(DSTSTREAMMR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            madmin.deleteStream(SRCSTREAMNOMR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            madmin.deleteStream(DSTSTREAMNOMR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(1);
        madmin.createStream(SRCSTREAMMR, sdesc);
        ProcessBuilder proc = new ProcessBuilder("maprcli", "table", "edit", "-path", SRCSTREAMMR, "-regionsizemb", "512");
        Process process = proc.start();
        int errorCode = process.waitFor();
        System.out.println("Set region size, completed with return code " + errorCode);
        madmin.createStream(DSTSTREAMMR, sdesc);
        madmin.createStream(SRCSTREAMNOMR, sdesc);
        proc = new ProcessBuilder("maprcli", "table", "edit", "-path", SRCSTREAMNOMR, "-regionsizemb", "512");
        process = proc.start();
        errorCode = process.waitFor();
        System.out.println("Set region size, completed with return code " + errorCode);
        madmin.createStream(DSTSTREAMNOMR, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        if (!MRfailed) {
            madmin.deleteStream(SRCSTREAMMR);
            madmin.deleteStream(DSTSTREAMMR);
        }
        if (!NoMRfailed) {
            madmin.deleteStream(SRCSTREAMNOMR);
            madmin.deleteStream(DSTSTREAMNOMR);
        }
    }

    @Test
    public void testCopyTableMROrder() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(SRCSTREAMMR, 100000, 30, 1, 1, 10000L, true, false, true, false, false));
        try {
            ListenerPerformance lp = new ListenerPerformance(DSTSTREAMMR, SRCSTREAMMR, 30, 1, 100000, 1, true, true, false, false, true, null, "CopyTableTest", false);
            Thread lt = new Thread(lp);
            lt.start();
            ProcessBuilder proc = new ProcessBuilder("hadoop", "jar", "/opt/mapr/lib/mapr-tools-7.7.0.5-mapr.jar", "com.mapr.db.mapreduce.tools.CopyTable", "-src", SRCSTREAMMR, "-dst", DSTSTREAMMR, "-bulkload", "false", "-mapreduce", "true");
            Process copyTableProc = proc.start();
            lt.join();
            MRfailed = !lp.status;
            Assert.assertTrue((boolean)lp.status);
            copyTableProc.waitFor();
            System.out.println("CopyTable process exit code: " + copyTableProc.exitValue());
        }
        catch (InterruptedException e) {
            System.out.println(e);
            MRfailed = true;
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testCopyTableNonMROrder() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(SRCSTREAMNOMR, 100000, 30, 1, 1, 10000L, true, false, true, false, false));
        try {
            ListenerPerformance lp = new ListenerPerformance(DSTSTREAMNOMR, SRCSTREAMNOMR, 30, 1, 100000, 1, true, true, false, false, true, null, "CopyTableTest", false);
            Thread lt = new Thread(lp);
            lt.start();
            ProcessBuilder proc = new ProcessBuilder("hadoop", "jar", "/opt/mapr/lib/mapr-tools-7.7.0.5-mapr.jar", "com.mapr.db.mapreduce.tools.CopyTable", "-src", SRCSTREAMNOMR, "-dst", DSTSTREAMNOMR, "-bulkload", "false", "-mapreduce", "false");
            Process copyTableProc = proc.start();
            copyTableProc.waitFor();
            System.out.println("CopyTable process exit code: " + copyTableProc.exitValue());
            lt.join();
            NoMRfailed = !lp.status;
            Assert.assertTrue((boolean)lp.status);
        }
        catch (InterruptedException e) {
            System.out.println(e);
            NoMRfailed = true;
            Assert.assertTrue((boolean)false);
        }
    }

    static {
        NoMRfailed = false;
        MRfailed = false;
    }
}

