/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.tests.producer.ProducerMultiTest;
import com.mapr.streams.tests.producer.SendMessagesToProducer;
import com.mapr.streams.tests.producer.TestProducerInterceptor;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ProducerInterceptors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerV10Test
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerV10Test.class);
    private static final String PREFIX = "/jtest-" + ProducerV10Test.class.getSimpleName() + "-";
    private static Admin madmin;
    private static final int numParts = 4;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        String sname = PREFIX + "producerinterceptoronsend";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sname = PREFIX + "producerinterceptoronack";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void interceptorProduceAndConsumeMsgs(String topicName, KafkaProducer<byte[], byte[]> kafkaproducer, KafkaConsumer<byte[], byte[]> kafkaconsumer, int numMsgs, int numPartitions) {
        ProducerMultiTest.CountCallback cb = new ProducerMultiTest.CountCallback(numMsgs * 1);
        SendMessagesToProducer producer = new SendMessagesToProducer(kafkaproducer, cb, topicName, numPartitions, numMsgs);
        producer.run();
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topicName);
        kafkaconsumer.subscribe(topics);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        ConsumerRecords recs = kafkaconsumer.poll(0L);
        Assert.assertEquals((long)0L, (long)recs.count());
        recs = kafkaconsumer.poll(0L);
        Assert.assertEquals((long)(numMsgs * numPartitions), (long)recs.count());
    }

    @Test
    public void testInterceptorOnSend() throws Exception {
        ArrayList<TestProducerInterceptor> interceptorList = new ArrayList<TestProducerInterceptor>();
        TestProducerInterceptor interceptor1 = new TestProducerInterceptor();
        interceptorList.add(interceptor1);
        ProducerInterceptors interceptors = new ProducerInterceptors(interceptorList);
        String sname = PREFIX + "producerinterceptoronsend";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        madmin.createStream(sname, sdesc);
        String topicName = ":t";
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("interceptor.classes", TestProducerInterceptor.class.getName());
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        Properties listenerProps = new Properties();
        listenerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("fetch.min.bytes", "1");
        listenerProps.put("auto.offset.reset", "earliest");
        listenerProps.put("enable.auto.commit", (Object)false);
        KafkaConsumer kafkaconsumer = new KafkaConsumer(listenerProps);
        madmin.createTopic(sname, "t", 4);
        int numMsgs = 10;
        interceptor1.resetCounters();
        this.interceptorProduceAndConsumeMsgs(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, (KafkaConsumer<byte[], byte[]>)kafkaconsumer, numMsgs, 4);
        Assert.assertEquals((long)(numMsgs * 4), (long)interceptor1.getOnSendCount());
        interceptors.close();
        kafkaconsumer.unsubscribe();
        kafkaconsumer.close();
        kafkaproducer.close();
        madmin.deleteStream(sname);
    }

    @Test
    public void testInterceptorOnAcknowledgement() throws Exception {
        ArrayList<TestProducerInterceptor> interceptorList = new ArrayList<TestProducerInterceptor>();
        TestProducerInterceptor interceptor1 = new TestProducerInterceptor();
        interceptorList.add(interceptor1);
        ProducerInterceptors interceptors = new ProducerInterceptors(interceptorList);
        String sname = PREFIX + "producerinterceptoronack";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        madmin.createStream(sname, sdesc);
        String topicName = ":t";
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("interceptor.classes", TestProducerInterceptor.class.getName());
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        Properties listenerProps = new Properties();
        listenerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("fetch.min.bytes", "1");
        listenerProps.put("auto.offset.reset", "earliest");
        listenerProps.put("enable.auto.commit", (Object)false);
        KafkaConsumer kafkaconsumer = new KafkaConsumer(listenerProps);
        madmin.createTopic(sname, "t", 4);
        int numMsgs = 10;
        interceptor1.resetCounters();
        this.interceptorProduceAndConsumeMsgs(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, (KafkaConsumer<byte[], byte[]>)kafkaconsumer, numMsgs, 4);
        Assert.assertEquals((long)(numMsgs * 4), (long)interceptor1.getOnAckCount());
        interceptors.close();
        kafkaconsumer.unsubscribe();
        kafkaconsumer.close();
        kafkaproducer.close();
        madmin.deleteStream(sname);
    }
}

