/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.listener;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.listener.ListenerTest;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ListenerStressTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ListenerStressTest.class);
    private static final String STREAM = "/jtest-" + ListenerStressTest.class.getSimpleName();
    private static Admin madmin;
    private static final int numParts = 4;

    @BeforeClass
    public static void setupTestClass() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
    }

    @Before
    public void setupTest() throws Exception {
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(4);
        madmin.createStream(STREAM, sdesc);
    }

    @After
    public void cleanupTest() throws Exception {
        madmin.deleteStream(STREAM);
    }

    @Test
    public void testOrderedListenerPerformance() throws IOException {
        Assert.assertTrue((boolean)ListenerTest.runStressTest(STREAM, 10000, 2, 4, 2, 10000L, true));
    }

    @Test
    public void testOutOfOrderListenerPerformance() throws IOException {
        Assert.assertTrue((boolean)ListenerTest.runStressTest(STREAM, 10000, 2, 4, 2, 10000L, false));
    }
}

