/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.impl.producer.MarlinFuture;
import com.mapr.streams.tests.producer.ProducerMultiTest;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class SendMessagesToProducer
implements Runnable {
    private String streamTopicName;
    private int numPartitions;
    private int numMsgsPerPartition;
    private KafkaProducer producer;
    private ProducerMultiTest.CountCallback callback;
    private byte[] key;
    private byte[] value;
    private boolean shouldClose;
    private Future<RecordMetadata>[][] recordMetadataFutures;

    public SendMessagesToProducer(KafkaProducer p, ProducerMultiTest.CountCallback cb, String topicName, int numparts, int numMessagesPerPartition) {
        this(p, cb, topicName, numparts, numMessagesPerPartition, 20);
    }

    public SendMessagesToProducer(KafkaProducer p, ProducerMultiTest.CountCallback cb, String topicName, int numparts, int numMessagesPerPartition, int kvSize) {
        this(p, cb, topicName, numparts, numMessagesPerPartition, kvSize, true);
    }

    public SendMessagesToProducer(KafkaProducer p, ProducerMultiTest.CountCallback cb, String topicName, int numparts, int numMessagesPerPartition, int kvSize, boolean shouldCl) {
        this.streamTopicName = topicName;
        this.numPartitions = numparts;
        this.numMsgsPerPartition = numMessagesPerPartition;
        this.producer = p;
        this.callback = cb;
        if (kvSize != 0) {
            this.key = new byte[kvSize];
            this.value = new byte[kvSize];
        } else {
            this.key = null;
            this.value = null;
        }
        this.shouldClose = shouldCl;
    }

    @Override
    public void run() {
        this.recordMetadataFutures = new MarlinFuture[this.numMsgsPerPartition][];
        for (int i = 0; i < this.numMsgsPerPartition; ++i) {
            this.recordMetadataFutures[i] = new MarlinFuture[this.numPartitions];
            for (int j = 0; j < this.numPartitions; ++j) {
                ProducerRecord<byte[], byte[]> record = this.getProducerRecord(this.streamTopicName, j, this.key, this.value);
                this.recordMetadataFutures[i][j] = this.producer.send(record, (Callback)this.callback);
            }
        }
        try {
            this.callback.waitOnCompletion();
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        if (this.shouldClose) {
            this.producer.close();
        }
    }

    public Future<RecordMetadata> getRecordMetadataFuture(int i, int j) {
        return this.recordMetadataFutures[i][j];
    }

    protected ProducerRecord<byte[], byte[]> getProducerRecord(String topic, int partition, byte[] key, byte[] value) {
        return new ProducerRecord(topic, Integer.valueOf(partition), (Object)key, (Object)value);
    }
}

