/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.perf;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class ProducerSinglePartitionTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerSinglePartitionTest.class);
    private static final String streamName = "/jtest-" + ProducerSinglePartitionTest.class.getSimpleName();
    private static Admin madmin;
    private static int numMsgs;
    private static int numPartitions;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(numPartitions);
        madmin.createStream(streamName, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        madmin.deleteStream(streamName);
    }

    @Test
    public void test() throws IOException {
        ProducerPerformance.runStressTest(streamName, numMsgs / numPartitions, 1, numPartitions, 1, 1L, false, true, true, false, false);
    }

    static {
        numMsgs = 1000000;
        numPartitions = 1;
    }
}

