/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.admin;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.store.DocumentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class AdminTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(AdminTest.class);
    private static final String PREFIX = "/jtest-" + AdminTest.class.getSimpleName() + "-";
    private static Admin madmin;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        madmin.close();
    }

    @Test
    public void testNullStreamNameAndDesc() throws Exception {
        Admin streamAdmin = Streams.newAdmin((Configuration)new Configuration());
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        String streamName = "/dummystream";
        try {
            streamAdmin.createStream(null, sdesc);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            streamAdmin.createStream(streamName, null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        streamAdmin.close();
    }

    @Test
    public void testMarlinAdminClient() throws Exception {
        Admin streamAdmin = Streams.newAdmin((Configuration)new Configuration());
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        String streamName = "/marlinstream";
        try {
            streamAdmin.deleteStream(streamName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)streamAdmin.streamExists(streamName));
        streamAdmin.createStream(streamName, sdesc);
        Assert.assertTrue((boolean)streamAdmin.streamExists(streamName));
        Properties adminConfig = new Properties();
        adminConfig.put("streams.admin.default.stream", "/marlinstream");
        AdminClient adminClient = AdminClient.create((Properties)adminConfig);
        String clusterId = (String)adminClient.describeCluster(null).clusterId().get();
        Assert.assertEquals((long)0L, (long)streamAdmin.countTopics(streamName));
        KafkaFuture future1 = adminClient.createTopics(Collections.singleton(new NewTopic(streamName + ":myTopic", 1, -1)), null).all();
        Assert.assertEquals((long)1L, (long)streamAdmin.countTopics(streamName));
        HashMap<CallSite, NewPartitions> partitionMap = new HashMap<CallSite, NewPartitions>();
        partitionMap.put((CallSite)((Object)(streamName + ":myTopic")), NewPartitions.increaseTo((int)3));
        Assert.assertEquals((long)1L, (long)streamAdmin.getTopicDescriptor(streamName, "myTopic").getPartitions());
        KafkaFuture future2 = adminClient.createPartitions(partitionMap, null).all();
        Assert.assertEquals((long)3L, (long)streamAdmin.getTopicDescriptor(streamName, "myTopic").getPartitions());
        KafkaFuture future3 = adminClient.describeTopics(Collections.singleton(streamName + ":myTopic"), null).all();
        Assert.assertEquals((Object)false, (Object)((TopicDescription)((Map)future3.get()).get(streamName + ":myTopic")).isInternal());
        Assert.assertEquals((long)3L, (long)((TopicDescription)((Map)future3.get()).get(streamName + ":myTopic")).partitions().size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((TopicPartitionInfo)((TopicDescription)((Map)future3.get()).get(streamName + ":myTopic")).partitions().get(0)).leader().host());
        KafkaFuture future4 = adminClient.listTopics("/marlinstream", null).namesToListings();
        Assert.assertEquals((Object)false, (Object)((TopicListing)((Map)future4.get()).get("myTopic")).isInternal());
        Assert.assertEquals((long)1L, (long)streamAdmin.countTopics(streamName));
        KafkaFuture future5 = adminClient.deleteTopics(Collections.singleton("myTopic"), null).all();
        Assert.assertEquals((long)0L, (long)streamAdmin.countTopics(streamName));
        streamAdmin.deleteStream(streamName);
        Assert.assertFalse((boolean)streamAdmin.streamExists(streamName));
        adminClient.close();
        streamAdmin.close();
    }

    @Test
    public void testCompression() throws IOException {
        String sname = PREFIX + "compression";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("Verify default compression is lz4");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"lz4");
        _logger.info("switch compression to zlib");
        sdesc.setCompressionAlgo("zlib");
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"zlib");
        _logger.info("switch off compression");
        sdesc.setCompressionAlgo("off");
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"off");
        _logger.info("test bad compression type");
        Exception ex = null;
        try {
            sdesc.setCompressionAlgo("zlibspecial");
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"off");
        madmin.deleteStream(sname);
    }

    @Test
    public void testTTL() throws IOException {
        String sname = PREFIX + "TTL";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("Verify default ttl is 7 days");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getTimeToLiveSec(), (long)604800L);
        _logger.info("switch TTL to 1 day");
        long rsec = 86400L;
        sdesc.setTimeToLiveSec(rsec);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getTimeToLiveSec(), (long)rsec);
        _logger.info("test bad TTL");
        Exception ex = null;
        try {
            sdesc.setTimeToLiveSec(-1L);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getTimeToLiveSec(), (long)rsec);
        madmin.deleteStream(sname);
    }

    @Test
    public void testPerms() throws IOException {
        String sname = PREFIX + "Perms";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        _logger.info("test produce/listen/topic/copy perms");
        sdesc.setProducePerms("u:2001 | g:2001");
        sdesc.setConsumePerms("u:2002 | g:2002");
        sdesc.setTopicPerms("u:2003 | g:2003");
        sdesc.setCopyPerms("u:2002 | g:2003");
        madmin.createStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getProducePerms(), (Object)"u:2001 | g:2001");
        Assert.assertEquals((Object)sdesc.getConsumePerms(), (Object)"u:2002 | g:2002");
        Assert.assertEquals((Object)sdesc.getTopicPerms(), (Object)"u:2003 | g:2003");
        Assert.assertEquals((Object)sdesc.getCopyPerms(), (Object)"u:2002 | g:2003");
        _logger.info("test admin perms");
        String adminPerm = new String(sdesc.getAdminPerms() + " | u:2005");
        sdesc.setAdminPerms(adminPerm);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAdminPerms(), (Object)adminPerm);
        Assert.assertEquals((Object)sdesc.getProducePerms(), (Object)"u:2001 | g:2001");
        Assert.assertEquals((Object)sdesc.getConsumePerms(), (Object)"u:2002 | g:2002");
        Assert.assertEquals((Object)sdesc.getTopicPerms(), (Object)"u:2003 | g:2003");
        Assert.assertEquals((Object)sdesc.getCopyPerms(), (Object)"u:2002 | g:2003");
        _logger.info("test bad perms");
        Exception ex = null;
        try {
            sdesc.setAdminPerms("k:0");
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IOException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAdminPerms(), (Object)adminPerm);
        madmin.deleteStream(sname);
    }

    @Test
    public void testAutoCreateTopic() throws IOException {
        String sname = PREFIX + "autoCreate";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("test autoCreate is on by default");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAutoCreateTopics(), (Object)true);
        _logger.info("switch off autocreate");
        sdesc.setAutoCreateTopics(false);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAutoCreateTopics(), (Object)false);
        madmin.deleteStream(sname);
    }

    @Test
    public void testFeedsPerTopic() throws IOException {
        String sname = PREFIX + "feedsPerTopic";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("test numPartitions=1 on by default");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)1L);
        _logger.info("test numPartitions=4");
        sdesc.setDefaultPartitions(4);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)4L);
        _logger.info("test bad numPartitions=-1");
        Exception ex = null;
        try {
            sdesc.setDefaultPartitions(0);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)4L);
        _logger.info("test bad numPartitions=8192");
        ex = null;
        try {
            sdesc.setDefaultPartitions(8192);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)4L);
        madmin.deleteStream(sname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamImpersonation() throws IOException, InterruptedException {
        String IMPERSONATIONUSER = "m7user1";
        final String streamName = PREFIX + "impersonation";
        String streamName1 = PREFIX + "impersonation_new";
        Configuration conf = new Configuration();
        Admin streamAdmin = Streams.newAdmin((Configuration)conf);
        try {
            streamAdmin.deleteStream(streamName1);
            streamAdmin.deleteStream(streamName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor desc = Streams.newStreamDescriptor();
        try {
            streamAdmin.createStream(streamName, desc);
            UserGroupInformation ugi1 = UserGroupInformation.createProxyUser((String)"m7user1", (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    Boolean exception = false;
                    try (DocumentStore documentStore = null;){
                        documentStore = Streams.getMessageStore((String)streamName);
                    }
                    Assert.assertTrue((boolean)exception);
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            _logger.error("exception impersonating user");
            Assert.assertTrue((boolean)false);
        }
        finally {
            if (streamAdmin != null) {
                streamAdmin.close();
            }
        }
        Admin streamAdmin1 = Streams.newAdmin((Configuration)conf);
        try {
            String topicName = "t";
            StreamDescriptor desc1 = Streams.newStreamDescriptor();
            _logger.info("Creating stream: " + streamName1 + " and topic: " + topicName);
            streamAdmin1.createStream(streamName1, desc1);
            streamAdmin1.createTopic(streamName1, topicName);
            Assert.assertTrue((streamAdmin1.countTopics(streamName1) == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            _logger.error("exception with new stream");
            Assert.assertTrue((boolean)false);
        }
        finally {
            streamAdmin1.deleteStream(streamName);
            streamAdmin1.deleteStream(streamName1);
            streamAdmin1.close();
        }
    }

    @Test
    public void testLogCompaction() throws IOException {
        String sname = PREFIX + "LogCompaction";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Exception ex = null;
        try {
            sdesc.setCompact(true);
            madmin.createStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc.setCompact(false);
        madmin.createStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)false);
        sdesc.setCompact(true);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)true);
        madmin.deleteStream(sname);
    }

    @Test
    public void testLogCompactionDisable() throws IOException {
        String sname = PREFIX + "LogCompactionDisable";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)false);
        sdesc.setCompact(true);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)true);
        sdesc.setCompact(false);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)false);
        madmin.deleteStream(sname);
    }

    @Test
    public void testLogCompactionTunables() throws IOException {
        String sname = PREFIX + "LogCompaction";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("Verify default tunables for og compaction.");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getMinCompactionLagMS(), (long)0L);
        Assert.assertEquals((long)sdesc.getDeleteRetentionMS(), (long)86400000L);
        _logger.info("switch min.compaction.lag.ms to 1 day");
        _logger.info("switch delete.retention.ms to 7 days");
        long lag = 86400L;
        long rten = 604800L;
        sdesc.setMinCompactionLagMS(lag);
        sdesc.setDeleteRetentionMS(rten);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getMinCompactionLagMS(), (long)lag);
        Assert.assertEquals((long)sdesc.getDeleteRetentionMS(), (long)rten);
        madmin.deleteStream(sname);
    }

    @Test
    public void testBadValuesForLogCompactionTunables() throws IOException {
        String sname = PREFIX + "LogCompaction";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        StreamDescriptor gooddesc = Streams.newStreamDescriptor();
        Exception ex = null;
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sdesc.setMinCompactionLagMS(-1L);
            madmin.createStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        try {
            sdesc.setMinCompactionLagMS(Long.MIN_VALUE);
            madmin.createStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        try {
            sdesc.setDeleteRetentionMS(-1L);
            madmin.createStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        try {
            sdesc.setDeleteRetentionMS(Long.MIN_VALUE);
            madmin.createStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        madmin.createStream(sname, gooddesc);
        try {
            sdesc.setMinCompactionLagMS(-1L);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        try {
            sdesc.setDeleteRetentionMS(-1L);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        madmin.deleteStream(sname);
    }

    @Test
    public void testForceLogCompactionForTopic() throws IOException {
        String sname = PREFIX + "LogCompaction";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Exception ex = null;
        try {
            sdesc.setCompact(true);
            madmin.createStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc.setCompact(false);
        madmin.createStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)false);
        sdesc.setCompact(true);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompact(), (Object)true);
        String topicName = "t";
        madmin.createTopic(sname, topicName);
        madmin.compactTopicNow(sname, topicName);
        madmin.deleteStream(sname);
    }
}

