/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.TimestampType;
import com.mapr.streams.TopicDescriptor;
import com.mapr.streams.tests.producer.ProducerBasicTest;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerRecordMetadataTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerRecordMetadataTest.class);
    private static final String STREAM = "/jtest-" + ProducerBasicTest.class.getSimpleName();
    private static Admin madmin;
    private static final String topicname = "t";
    private static final String topicname2 = "t2";
    private static final String fullName;
    private static final long eventTime = 1000L;
    private static final int numParts = 1;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        try {
            madmin.deleteStream(STREAM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(1);
        sdesc.setTimeToLiveSec(0L);
        madmin.createStream(STREAM, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        madmin.deleteStream(STREAM);
    }

    @Test
    public void testRecordMetadata() throws Exception {
        madmin.createTopic(STREAM, topicname);
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        byte[] key = new byte[20];
        byte[] value = new byte[20];
        Future record = kafkaproducer.send(new ProducerRecord(fullName, Integer.valueOf(0), Long.valueOf(1000L), (Object)key, (Object)value));
        Assert.assertTrue((((RecordMetadata)record.get()).timestamp() == 1000L ? 1 : 0) != 0);
        TopicDescriptor desc = Streams.newTopicDescriptor();
        desc.setTimestampType(TimestampType.LOG_APPEND_TIME);
        madmin.createTopic(STREAM, topicname2, desc);
        record = kafkaproducer.send(new ProducerRecord(STREAM + ":" + topicname2, Integer.valueOf(0), Long.valueOf(1000L), (Object)key, (Object)value));
        Assert.assertTrue((((RecordMetadata)record.get()).timestamp() != 1000L ? 1 : 0) != 0);
    }

    static {
        fullName = STREAM + ":" + topicname;
    }
}

