/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.listener;

import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.TopicRefreshListListener;
import com.mapr.streams.TopicRefreshRegexListener;
import com.mapr.streams.impl.MarlinClient;
import com.mapr.streams.impl.listener.ListenerRecord;
import com.mapr.streams.impl.listener.MarlinConsumerCoordinator;
import com.mapr.streams.impl.listener.MarlinListenerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinListener<K, V>
extends MarlinClient
implements Consumer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(MarlinListener.class);
    private final Deserializer<K> _keyDeserializer;
    private final Deserializer<V> _valueDeserializer;
    protected final MarlinListenerImpl _listener;
    protected MarlinConsumerCoordinator _coordinator;
    protected boolean _clientSidePartitioningEnabled = false;

    protected MarlinListener(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, MarlinListenerImpl listener) {
        LOG.debug("Starting Streams Listener");
        this._keyDeserializer = keyDeserializer == null ? (Deserializer)config.getConfiguredInstance("key.deserializer", Deserializer.class) : keyDeserializer;
        this._valueDeserializer = valueDeserializer == null ? (Deserializer)config.getConfiguredInstance("value.deserializer", Deserializer.class) : valueDeserializer;
        this._listener = listener;
        LOG.debug("Streams listener created");
    }

    public MarlinListener(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(config, keyDeserializer, valueDeserializer, new MarlinListenerImpl(config, null));
    }

    public Set<TopicPartition> assignment() {
        return this._listener.assignment();
    }

    public Set<String> subscription() {
        if (this._clientSidePartitioningEnabled) {
            return this._coordinator.subscription();
        }
        return this._listener.subscription();
    }

    public void subscribe(Collection<String> topics) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        } else {
            this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        }
    }

    public void topicRefresherRegex(Pattern pattern, TopicRefreshRegexListener callback) {
        this._listener.topicRefresherRegex(pattern, callback);
    }

    public void topicRefresherList(Collection<String> topics, TopicRefreshListListener callback) {
        this._listener.topicRefresherList(topics, callback);
    }

    public void subscribe(List<String> topics) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        } else {
            this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        }
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.subscribe(topics, callback);
        } else {
            this._listener.subscribe(topics, callback);
        }
    }

    public void subscribe(List<String> topics, ConsumerRebalanceListener listener) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.subscribe(topics, listener);
        } else {
            this.subscribe((Collection<String>)topics, listener);
        }
    }

    public void assign(Collection<TopicPartition> partitions) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.assign(partitions);
        } else {
            this._listener.assign(partitions);
        }
    }

    public void assign(List<TopicPartition> partitions) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.assign(partitions);
        } else {
            this.assign((Collection<TopicPartition>)partitions);
        }
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.subscribe(pattern, callback);
        } else {
            this._listener.subscribe(pattern, callback);
        }
    }

    public void subscribe(Pattern pattern) {
        throw new KafkaException("subscribe API not implemented");
    }

    public void unsubscribe() {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.unsubscribe();
        } else {
            this._listener.unsubscribe();
        }
    }

    public ConsumerRecords<K, V> poll(long timeout) {
        Map<TopicPartition, List<ListenerRecord>> marlinRecMap = this._listener.poll(timeout);
        HashMap kafkaRecMap = new HashMap();
        Iterator<Map.Entry<TopicPartition, List<ListenerRecord>>> it = marlinRecMap.entrySet().iterator();
        while (it.hasNext()) {
            boolean feedsAdded = false;
            Map.Entry<TopicPartition, List<ListenerRecord>> entry = it.next();
            TopicPartition partition = entry.getKey();
            List<ListenerRecord> feedRecords = entry.getValue();
            ArrayList<ConsumerRecord<K, V>> partitionRecords = new ArrayList<ConsumerRecord<K, V>>();
            for (ListenerRecord feedRec : feedRecords) {
                feedsAdded = true;
                partitionRecords.add(this.toKafkaConsumerRecord(feedRec, this._keyDeserializer, this._valueDeserializer));
            }
            if (!feedsAdded) continue;
            kafkaRecMap.put(partition, partitionRecords);
        }
        return new ConsumerRecords(kafkaRecMap);
    }

    public void commitSync() {
        this._listener.commitSync();
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this._listener.commitSync(offsets);
    }

    public void commitAsync() {
        this._listener.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this._listener.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this._listener.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this._listener.seek(partition, offset);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this._listener.seekToBeginning(partitions);
    }

    @Deprecated
    public void seekToBeginning(TopicPartition ... partitions) {
        this.seekToBeginning(Arrays.asList(partitions));
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this._listener.seekToEnd(partitions);
    }

    @Deprecated
    public void seekToEnd(TopicPartition ... partitions) {
        this.seekToEnd(Arrays.asList(partitions));
    }

    public long position(TopicPartition partition) {
        return this._listener.position(partition);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this._listener.committed(partition);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return null;
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this._listener.getTopicInfo(topic);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this._listener.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(String stream) {
        return this._listener.listTopics(stream);
    }

    public Map<String, List<PartitionInfo>> listTopics(Pattern pattern) {
        return this._listener.listTopics(pattern);
    }

    public void pause(Collection<TopicPartition> partitions) {
        this._listener.pause(partitions);
    }

    @Deprecated
    public void pause(TopicPartition ... partitions) {
        this.pause(Arrays.asList(partitions));
    }

    public void resume(Collection<TopicPartition> partitions) {
        this._listener.resume(partitions);
    }

    @Deprecated
    public void resume(TopicPartition ... partitions) {
        this.resume(Arrays.asList(partitions));
    }

    public Set<TopicPartition> paused() {
        return this._listener.paused();
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this._listener.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this._listener.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this._listener.endOffsets(partitions);
    }

    public void close() {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.close();
        }
        this._listener.close(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public void close(long timeout, TimeUnit timeUnit) {
        if (this._clientSidePartitioningEnabled) {
            this._coordinator.close();
        }
        this._listener.close(timeout, timeUnit);
    }

    public void wakeup() {
        this._listener.wakeup();
    }

    public Marlinserver.JoinGroupResponse join(Marlinserver.JoinGroupDesc desc, MarlinJoinCallback cb) {
        return this._listener.join(desc, cb);
    }

    protected <K, V> ConsumerRecord<K, V> generateConsumerRecord(String topic, ListenerRecord rec, K kkey, V kvalue, int serializedKeySize, int serializedValueSize) {
        return new ConsumerRecord(topic, rec.feedId(), rec.offset(), kkey, kvalue, rec.timestamp(), rec.producer());
    }

    public <K, V> ConsumerRecord<K, V> toKafkaConsumerRecord(ListenerRecord rec, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Object kkey = null;
        byte[] key = rec.key();
        byte[] value = rec.value();
        String topic = rec.topic();
        if (key != null) {
            kkey = keyDeserializer.deserialize(topic, key);
        }
        Object kvalue = null;
        if (value != null) {
            kvalue = valueDeserializer.deserialize(topic, value);
        }
        return this.generateConsumerRecord(topic, rec, kkey, kvalue, key == null ? -1 : key.length, value == null ? -1 : value.length);
    }

    public static interface MarlinJoinCallback {
        public void onJoin(Marlinserver.JoinGroupInfo var1);

        public void onRejoin(Marlinserver.JoinGroupInfo var1);
    }
}

