/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.tests.producer.ProducerMultiTest;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class SendMessagesToProducer
implements Runnable {
    private String streamTopicName;
    private int numPartitions;
    private int numMsgsPerPartition;
    private KafkaProducer producer;
    private ProducerMultiTest.CountCallback callback;
    private byte[] key;
    private byte[] value;
    private boolean shouldClose;

    public SendMessagesToProducer(KafkaProducer p, ProducerMultiTest.CountCallback cb, String topicName, int numparts, int numMessagesPerPartition) {
        this(p, cb, topicName, numparts, numMessagesPerPartition, 20);
    }

    public SendMessagesToProducer(KafkaProducer p, ProducerMultiTest.CountCallback cb, String topicName, int numparts, int numMessagesPerPartition, int kvSize) {
        this(p, cb, topicName, numparts, numMessagesPerPartition, kvSize, true);
    }

    public SendMessagesToProducer(KafkaProducer p, ProducerMultiTest.CountCallback cb, String topicName, int numparts, int numMessagesPerPartition, int kvSize, boolean shouldCl) {
        this.streamTopicName = topicName;
        this.numPartitions = numparts;
        this.numMsgsPerPartition = numMessagesPerPartition;
        this.producer = p;
        this.callback = cb;
        if (kvSize != 0) {
            this.key = new byte[kvSize];
            this.value = new byte[kvSize];
        } else {
            this.key = null;
            this.value = null;
        }
        this.shouldClose = shouldCl;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.numMsgsPerPartition; ++i) {
            for (int j = 0; j < this.numPartitions; ++j) {
                ProducerRecord record = new ProducerRecord(this.streamTopicName, Integer.valueOf(j), (Object)this.key, (Object)this.value);
                this.producer.send(record, (Callback)this.callback);
            }
        }
        try {
            this.callback.waitOnCompletion();
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        if (this.shouldClose) {
            this.producer.close();
        }
    }
}

