/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.demo.drill;

import com.mapr.streams.demo.drill.CreditCard;
import com.mapr.streams.demo.drill.Region;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer {
    private static final Logger _logger = LoggerFactory.getLogger(Producer.class);
    private static Random rand = new Random();
    String stream = null;
    int numPart = 10;
    int numTransactions = 50000;

    Producer() {
    }

    public Producer(String stream) {
        this.stream = stream;
    }

    public Producer(String stream, int numPart, int numTransactions) {
        this.stream = stream;
        this.numPart = numPart;
        this.numTransactions = numTransactions;
    }

    public static String generateCC() {
        String ccNum = "";
        ccNum = ccNum + "" + rand.nextInt(6) + rand.nextInt(9) + rand.nextInt(9) + rand.nextInt(9);
        ccNum = ccNum + " " + (rand.nextInt(6) + 1) + rand.nextInt(9) + rand.nextInt(9) + rand.nextInt(9);
        ccNum = ccNum + " " + (rand.nextInt(6) + 1) + rand.nextInt(9) + rand.nextInt(9) + rand.nextInt(9);
        ccNum = ccNum + " " + (rand.nextInt(6) + 1) + rand.nextInt(9) + rand.nextInt(9) + rand.nextInt(9);
        return ccNum;
    }

    public static void usage() {
        System.err.println("App -stream <stream-name> -numPartitions <num-partitions> -numTransactions <num-transactions>");
        System.exit(1);
    }

    public static void main(String[] args) {
        Producer producer = new Producer();
        _logger.info("Args: {}", (Object)args.length);
        if (args.length < 6) {
            Producer.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-stream")) {
                if (++i >= args.length) {
                    Producer.usage();
                }
                producer.stream = args[i];
                _logger.info("Stream: {}", (Object)producer.stream);
                continue;
            }
            if (args[i].equals("-numPartitions")) {
                if (++i >= args.length) {
                    Producer.usage();
                }
                producer.numPart = Integer.parseInt(args[i]);
                _logger.info("Num Partitions: {}", (Object)producer.numPart);
                continue;
            }
            if (args[i].equals("-numTransactions")) {
                if (++i >= args.length) {
                    Producer.usage();
                }
                producer.numTransactions = Integer.parseInt(args[i]);
                _logger.info("Num Transactions: {}", (Object)producer.numTransactions);
                continue;
            }
            Producer.usage();
        }
        System.exit(producer.run());
    }

    public int run() {
        Properties props = new Properties();
        if (props.getProperty("bootstrap.servers") == null) {
            props.put("bootstrap.servers", "localhost:9092");
        }
        if (props.getProperty("key.serializer") == null) {
            props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (props.getProperty("value.serializer") == null) {
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (props.getProperty("streams.parallel.flushers.per.partition") != null) {
            props.put("streams.parallel.flushers.per.partition", (Object)false);
        }
        KafkaProducer producer = new KafkaProducer(props);
        ArrayList<String> merchants = new ArrayList<String>();
        merchants.add("Costco");
        merchants.add("Walmart");
        merchants.add("Safeway");
        merchants.add("Chevron");
        merchants.add("Texaco");
        merchants.add("Giant Eagle");
        merchants.add("76");
        merchants.add("Fred Myers");
        merchants.add("Big 5");
        merchants.add("Sports Authority");
        merchants.add("Rotten Robbies");
        ArrayList<Region> regions = new ArrayList<Region>();
        Region us_east = new Region("US_EAST");
        us_east.addCity("New York");
        us_east.addCity("Baltimore");
        us_east.addCity("Pittsburgh");
        regions.add(us_east);
        Region us_west = new Region("US_WEST");
        us_west.addCity("San Francisco");
        us_west.addCity("San Jose");
        regions.add(us_west);
        Region us_north = new Region("US_NORTH");
        us_north.addCity("Bozeman");
        us_north.addCity("Minot");
        us_north.addCity("Rochester");
        regions.add(us_north);
        Region us_south = new Region("US_SOUTH");
        us_south.addCity("Miami");
        us_south.addCity("Dallas");
        us_south.addCity("New Orleans");
        regions.add(us_south);
        boolean generatedFraudulent = false;
        boolean generatedLowExp = false;
        ArrayList<CreditCard> cards = new ArrayList<CreditCard>();
        for (int i = 0; i < 100; ++i) {
            String cc = Producer.generateCC();
            boolean isFraudulent = false;
            boolean isLowExp = false;
            int ccLimit = rand.nextInt(1000) * 10;
            if (!generatedFraudulent && rand.nextInt(100) == 13) {
                isFraudulent = true;
                generatedFraudulent = true;
            }
            if (!generatedFraudulent && i == 65) {
                isFraudulent = true;
                generatedLowExp = true;
            }
            if (!isFraudulent && !generatedLowExp && rand.nextInt(10) == 4) {
                isLowExp = true;
                generatedLowExp = true;
            }
            if (!generatedLowExp && i > 80) {
                isLowExp = true;
                generatedLowExp = true;
            }
            cards.add(new CreditCard(cc, ccLimit, isFraudulent, isLowExp));
        }
        ProducerCallback cb = new ProducerCallback();
        for (int i = 0; i < this.numTransactions; ++i) {
            CreditCard cc = (CreditCard)cards.get(rand.nextInt(cards.size()));
            Region reg = (Region)regions.get(rand.nextInt(regions.size()));
            String merchant = (String)merchants.get(rand.nextInt(merchants.size()));
            int partition = rand.nextInt(this.numPart);
            float amount = cc.use();
            String value = "{ \"merchant\": \"" + merchant + "\", \"amount\" : \"" + amount + "\"}";
            ProducerRecord record = new ProducerRecord(this.stream + ":" + reg.getName(), Integer.valueOf(partition), (Object)cc.getKey().getBytes(), (Object)value.getBytes());
            producer.send(record, (Callback)cb);
        }
        producer.flush();
        producer.close();
        return 0;
    }

    private static final class ProducerCallback
    implements Callback {
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

