/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.producer;

import com.mapr.fs.jni.MarlinProducerResult;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;

public final class MarlinProducerResultImpl
implements MarlinProducerResult {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final String topic;
    private final Callback callback;
    private volatile int feed = -1;
    private volatile long offset = 0L;
    private volatile Exception error;

    public MarlinProducerResultImpl(String topic, int feed, Callback callback) {
        this.topic = topic;
        this.feed = feed;
        this.callback = callback;
    }

    public void done(int feedid, long offset, Exception error) {
        if (feedid == -1 || this.feed == -1 || this.feed == feedid) {
            // empty if block
        }
        this.feed = feedid;
        this.offset = offset;
        this.error = error;
        this.latch.countDown();
    }

    public String getTopic() {
        return this.topic;
    }

    public int getFeed() {
        return this.feed;
    }

    public RecordMetadata getRecordMetadata() {
        return new RecordMetadata(new TopicPartition(this.topic, this.feed), this.offset, 0L);
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public boolean completed() {
        return this.latch.getCount() == 0L;
    }

    public long offset() {
        return this.offset;
    }

    public Exception error() {
        return this.error;
    }

    public Callback callback() {
        return this.callback;
    }

    public void onCompletion() {
        if (this.callback != null) {
            this.callback.onCompletion(this.getRecordMetadata(), this.error());
        }
    }
}

