/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.streams.tests.producer;

import com.mapr.streams.tests.producer.ProducerMultiTest.CountCallback;

import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class SendMessagesToProducer implements Runnable {
  private String streamTopicName;
  private int numPartitions;
  private int numMsgsPerPartition;
  private KafkaProducer producer;
  private CountCallback callback;
  private byte[] key;
  private byte[] value;

  public SendMessagesToProducer(KafkaProducer p, CountCallback cb, String topicName,
                                int numparts, int numMessagesPerPartition) {
    this(p, cb, topicName, numparts, numMessagesPerPartition, 20 /*key-value size*/);
  }

  public SendMessagesToProducer(KafkaProducer p, CountCallback cb, String topicName,
                                int numparts, int numMessagesPerPartition, int kvSize) {
    streamTopicName = topicName;
    numPartitions = numparts;
    numMsgsPerPartition = numMessagesPerPartition;
    producer = p;
    callback = cb;
    if (kvSize != 0) {
      this.key = new byte[kvSize];
      this.value = new byte[kvSize];
    } else {
      this.key = null;
      this.value = null;
    }
  }

  public void run() {
    for (int i = 0; i < numMsgsPerPartition; i++) {
      for (int j = 0; j < numPartitions; j++) {
        ProducerRecord<byte[], byte[]> record =
          new ProducerRecord<byte[], byte[]>(streamTopicName, j, key, value);
        producer.send(record, callback);
      }
    }
    try {
      callback.waitOnCompletion();
    } catch (Exception e) {
      System.out.println("Sleep interrupted " + e);
    }
    producer.close();
  }
}

