/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.streams.tests.perf;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.producer.ProducerPerformance;

import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;

@Category(StressTest.class)
public class ProducerSinglePartitionTest extends BaseTest {
  private static final Logger _logger = LoggerFactory.getLogger(ProducerSinglePartitionTest.class);
  private static final String streamName = "/jtest-" + ProducerSinglePartitionTest.class.getSimpleName();
  private static Admin madmin;
  private static int numMsgs = 1000000; // 1M
  private static int numPartitions = 1;

  @BeforeClass
  public static void setupTest() throws Exception {
    final Configuration conf = new Configuration();
    madmin = Streams.newAdmin(conf);

    StreamDescriptor sdesc = Streams.newStreamDescriptor();
    sdesc.setDefaultPartitions(numPartitions);

    madmin.createStream(streamName, sdesc);
  }

  @AfterClass
  public static void cleanupTest() throws Exception {
    madmin.deleteStream(streamName);
  }

  @Test
  public void test() throws IOException {
    ProducerPerformance.runStressTest(streamName,
                                      numMsgs / numPartitions,
                                      1 /*ntopics*/,
                                      numPartitions,
                                      1 /*nbatches*/,
                                      1 /*ms between batches*/,
                                      false /*needsVerify*/,
                                      true /*multiple flushers */,
                                      true /*printProgress*/,
                                      false /*roundrobin*/,
                                      false /*hashkey*/);
  }
}
