/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.streams.tests.perf;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;

import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.streams.listener.ListenerPerformance;

import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;

@Category(StressTest.class)
public class ListenerMultiPartitionTest extends BaseTest {
  private static final Logger _logger = LoggerFactory.getLogger(ListenerMultiPartitionTest.class);
  private static final String streamName = "/jtest-" + ListenerMultiPartitionTest.class.getSimpleName();
  private static Admin madmin;
  // TODO MINJI get this back up to 10M, for now just reduce it to 1M
  private static int numMsgs = 1000000; // 10M
  private static int numPartitions = 50;

  @BeforeClass
  public static void setupTest() throws Exception {
    final Configuration conf = new Configuration();
    madmin = Streams.newAdmin(conf);

    StreamDescriptor sdesc = Streams.newStreamDescriptor();
    sdesc.setDefaultPartitions(numPartitions);

    madmin.createStream(streamName, sdesc);
  }

  @AfterClass
  public static void cleanupTest() throws Exception {
    madmin.deleteStream(streamName);
  }

  @Test
  public void test() throws Exception {
    ProducerPerformance.runStressTest(streamName,
                                      numMsgs / numPartitions,
                                      1 /*ntopics*/,
                                      numPartitions,
                                      1 /*nbatches*/,
                                      1 /*ms between batches*/,
                                      false /*needVerify*/,
                                      true /*multiple flushers */,
                                      true /*printProgress*/,
                                      false /* roundrobin*/,
                                      false /* hashkey*/);

    ListenerPerformance lp = new ListenerPerformance(streamName,
                                                     1 /*ntopics*/,
                                                     numPartitions,
                                                     numMsgs / numPartitions,
                                                     1 /*nbatches*/,
                                                     false /*verifyKeys*/,
                                                     false /*keysInOrder*/,
                                                     false /*allowDup*/,
                                                     false /*traceEnabled*/,
                                                     true /*printProgress*/,
                                                     null /*groupId*/,
                                                     "ListenerMultiPartitionTest",
                                                     false /*topicSubscriptions*/);

    Thread lt = new Thread(lp);
    lt.start();
    lt.join();
  }
}
