/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.streams.tests.listener;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mapr.streams.Admin;
import com.mapr.streams.Streams;
import com.mapr.streams.StreamDescriptor;

import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.streams.listener.ListenerTest;

import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;

@Category(ClusterTest.class)
public class ListenerStressTest extends BaseTest {
  private static final Logger _logger = LoggerFactory.getLogger(ListenerStressTest.class);
  private static final String STREAM = "/jtest-" + ListenerStressTest.class.getSimpleName();
  private static Admin madmin;
  private static final int numParts = 4;

  @BeforeClass
  public static void setupTestClass() throws Exception {
    Configuration conf = new Configuration();
    madmin = Streams.newAdmin(conf);
  }

  @Before
  public void setupTest() throws Exception {
    StreamDescriptor sdesc = Streams.newStreamDescriptor();
    sdesc.setDefaultPartitions(numParts);
    madmin.createStream(STREAM, sdesc);
  }

  @After
  public void cleanupTest() throws Exception {
    madmin.deleteStream(STREAM);
  }

  @Test
  public void testOrderedListenerPerformance() throws IOException {
    assertTrue(ListenerTest.runStressTest(STREAM,
                                          10000 /*nmsgs per partition */,
                                          2 /*ntopics*/,
                                          numParts /*npartitions*/,
                                          2  /*nbatches*/,
                                          10*1000 /* ms sleep between batches */,
                                          true /* ordered */));
  }

  @Test
  public void testOutOfOrderListenerPerformance() throws IOException {
    assertTrue(ListenerTest.runStressTest(STREAM,
                                          10000 /*nmsgs per partition */,
                                          2 /*ntopics*/,
                                          numParts /*npartitions*/,
                                          2  /*nbatches*/,
                                          10*1000 /* ms sleep between batches */,
                                          false /* out of order */));
  }
}
