/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.streams.tests.admin;

import static org.junit.Assert.assertTrue;

import java.io.IOException;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mapr.streams.impl.MarlinRowKeyDecoder;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;

@Category(SimpleTest.class)
public class RowDecoderTest extends BaseTest {
  private static final Logger _logger = LoggerFactory.getLogger(TopicTest.class);

  @BeforeClass
  public static void setupTest() throws Exception {
  }

  @Test
  public void testDecodeAssignKey() throws IOException {
    String key = "attopic1:00000001GLTopicTest";

    Document doc = MarlinRowKeyDecoder.decodeAssignKey(key);
    _logger.info(doc.toString());

    assertTrue(doc.getString(MarlinRowKeyDecoder.TOPIC).equals("topic1"));
    assertTrue(doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 1);
    assertTrue(doc.getString(MarlinRowKeyDecoder.CONSUMER_GROUP).equals("LTopicTest"));
  }

  @Test
  public void testDecodeMsgKey() throws IOException {
    String key = "p00attopic0:000000020000000000000066";

    Document doc = MarlinRowKeyDecoder.decodeMsgKey(key);
    _logger.info(doc.toString());

    assertTrue(doc.getString(MarlinRowKeyDecoder.TOPIC).equals("topic0"));
    assertTrue(doc.getInt(MarlinRowKeyDecoder.PARTITION) == 10);
    assertTrue(doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 2);
    assertTrue(doc.getLong(MarlinRowKeyDecoder.OFFSET) == 0x66);

    // Test single-char topic name
    key = "p000t0:00000001";
    doc = MarlinRowKeyDecoder.decodeTopicFeedKey(key);
    assertTrue(doc.getString(MarlinRowKeyDecoder.TOPIC).equals("0"));
    assertTrue(doc.getInt(MarlinRowKeyDecoder.PARTITION) == 0);
    assertTrue(doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 1);
  }

  @Test
  public void testDecodeCursorKey() throws IOException {
    String key = "ctxyz:0000000bp0ffGmygroup";

    Document doc = MarlinRowKeyDecoder.decodeCursorKey(key);
    _logger.info(doc.toString());

    assertTrue(doc.getString(MarlinRowKeyDecoder.TOPIC).equals("xyz"));
    assertTrue(doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 0xb);
    assertTrue(doc.getInt(MarlinRowKeyDecoder.PARTITION) == 0xff);
    assertTrue(doc.getString(MarlinRowKeyDecoder.CONSUMER_GROUP).equals("mygroup"));
  }
}
