streamName=/tmp/transactions
partitions=50
numTransactions=1000
echo "Removing old stream $streamName"
sleep 1
hadoop fs -rm $streamName

echo "Creating new stream $streamName with $partitions partitions"
sleep 1
maprcli stream create -path $streamName -defaultpartitions $partitions

sleep 3
echo "Compiling"
sleep 1
#cd src/main/java
javac -cp `marlin classpath`:resources/json-simple-1.1.1.jar:. *.java

echo "Running Producer"
sleep 1
java -cp `marlin classpath`:resources/json-simple-1.1.1.jar:. com.mapr.streams.demo.drill.Producer -stream $streamName -numPartitions $partitions -numTransactions $numTransactions 

echo "Running Consumer"
sleep 1
java -cp `marlin classpath`:resources/json-simple-1.1.1.jar:. com.mapr.streams.demo.drill.Consumer -stream $streamName &

consumerPid=$!

sleep 15
echo "Killing Consumer"
kill -9 $consumerPid

echo "Cleaning up"
rm *\.class *\.log
