/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.streams.demo.drill;

import java.util.Random;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditCard {
  private static final Logger _logger = LoggerFactory.getLogger(CreditCard.class);

  private String cc_num;
  private int cc_limit;
  private boolean fraudulent;
  private boolean lowSpending;
  private int numUsed;
  private Random rand;

  public CreditCard(String num, int limit, boolean isFraud, boolean isLowExp) {
    cc_num = num;
    cc_limit = limit;
    fraudulent = isFraud;
    lowSpending = isLowExp;
    numUsed = 0;
    rand = new Random();
  }

  public String number() {
    return cc_num;
  }

  public String getKey() {
    return "{\"cc_num\": \"" + cc_num + "\"}";
  }

  public float use() {
    numUsed ++;

    if ((numUsed == 3) && lowSpending) {
      _logger.info("Generating 0.49 transaction");
      return (float)0.49;
    }

    if (lowSpending) {
      float amt = rand.nextInt(10) + 1;
      amt += (float)rand.nextInt(100) / 100.00;
      return amt;
    }

    if ((numUsed == 5) && fraudulent) {
      _logger.info("Generating fraudulent transaction");
      return (float)0.99;
    }

    float amt = rand.nextInt(100) + 10;
    amt += (float)rand.nextInt(100) / 100.00;
    return amt;
  }

  public boolean isLowSpending() {
    return lowSpending;
  }

  public int getLimit() {
    return cc_limit;
  }

  public boolean isFraudulent() {
    if (fraudulent && (numUsed > 50)) {
      fraudulent = false;
      return true;
    }

    return false;
  }

}
