/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.listener;

import com.mapr.fs.jni.ListenerRecord;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.impl.MarlinClient;
import com.mapr.streams.impl.listener.MarlinListenerImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinListener<K, V>
extends MarlinClient
implements Consumer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(MarlinListener.class);
    private final Deserializer<K> _keyDeserializer;
    private final Deserializer<V> _valueDeserializer;
    private final MarlinListenerImpl _listener;

    public MarlinListener(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        LOG.debug("Starting Streams Listener");
        this._keyDeserializer = keyDeserializer == null ? (Deserializer)config.getConfiguredInstance("key.deserializer", Deserializer.class) : keyDeserializer;
        this._valueDeserializer = valueDeserializer == null ? (Deserializer)config.getConfiguredInstance("value.deserializer", Deserializer.class) : valueDeserializer;
        this._listener = new MarlinListenerImpl(config);
        LOG.debug("Streams listener created");
    }

    public Set<TopicPartition> assignment() {
        return this._listener.assignment();
    }

    public Set<String> subscription() {
        return this._listener.subscription();
    }

    public void subscribe(List<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    public void subscribe(List<String> topics, ConsumerRebalanceListener callback) {
        this._listener.subscribe(topics, callback);
    }

    public void assign(List<TopicPartition> partitions) {
        this._listener.assign(partitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this._listener.subscribe(pattern, callback);
    }

    public void unsubscribe() {
        this._listener.unsubscribe();
    }

    public ConsumerRecords<K, V> poll(long timeout) {
        Map<TopicPartition, List<ListenerRecord>> marlinRecMap = this._listener.poll(timeout);
        HashMap kafkaRecMap = new HashMap();
        Iterator<Map.Entry<TopicPartition, List<ListenerRecord>>> it = marlinRecMap.entrySet().iterator();
        while (it.hasNext()) {
            boolean feedsAdded = false;
            Map.Entry<TopicPartition, List<ListenerRecord>> entry = it.next();
            TopicPartition partition = entry.getKey();
            List<ListenerRecord> feedRecords = entry.getValue();
            ArrayList<ConsumerRecord<K, V>> partitionRecords = new ArrayList<ConsumerRecord<K, V>>();
            for (ListenerRecord feedRec : feedRecords) {
                feedsAdded = true;
                partitionRecords.add(MarlinListener.toKafkaConsumerRecord(feedRec, this._keyDeserializer, this._valueDeserializer));
            }
            if (!feedsAdded) continue;
            kafkaRecMap.put(partition, partitionRecords);
        }
        return new ConsumerRecords(kafkaRecMap);
    }

    public void commitSync() {
        this._listener.commitSync();
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this._listener.commitSync(offsets);
    }

    public void commitAsync() {
        this._listener.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this._listener.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this._listener.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this._listener.seek(partition, offset);
    }

    public void seekToBeginning(TopicPartition ... partitions) {
        this._listener.seekToBeginning(partitions);
    }

    public void seekToEnd(TopicPartition ... partitions) {
        this._listener.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this._listener.position(partition);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this._listener.committed(partition);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return null;
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this._listener.getTopicInfo(topic);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this._listener.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(String stream) {
        return this._listener.listTopics(stream);
    }

    public Map<String, List<PartitionInfo>> listTopics(Pattern pattern) {
        return this._listener.listTopics(pattern);
    }

    public void pause(TopicPartition ... partitions) {
        this._listener.pause(partitions);
    }

    public void resume(TopicPartition ... partitions) {
        this._listener.resume(partitions);
    }

    public void close() {
        this._listener.close();
    }

    public void wakeup() {
        this._listener.wakeup();
    }

    public Marlinserver.JoinGroupResponse join(Marlinserver.JoinGroupDesc desc, MarlinJoinCallback cb) {
        return this._listener.join(desc, cb);
    }

    public static <K, V> ConsumerRecord<K, V> toKafkaConsumerRecord(ListenerRecord rec, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Object kkey = null;
        byte[] key = rec.key();
        byte[] value = rec.value();
        String topic = rec.topic();
        if (key != null) {
            ByteBuffer keyBytes = ByteBuffer.wrap(key);
            kkey = keyDeserializer.deserialize(topic, key);
        }
        Object kvalue = null;
        if (value != null) {
            ByteBuffer valueBytes = ByteBuffer.wrap(value);
            kvalue = valueDeserializer.deserialize(topic, value);
        }
        return new ConsumerRecord(topic, rec.feedId(), rec.offset(), kkey, kvalue, rec.timestamp(), rec.producer());
    }

    public static interface MarlinJoinCallback {
        public void onJoin(Marlinserver.JoinGroupInfo var1);

        public void onRejoin(Marlinserver.JoinGroupInfo var1);
    }
}

