/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams;

import com.mapr.fs.ShimLoader;
import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.impl.MessageStore;
import com.mapr.streams.impl.admin.MStreamDescriptor;
import com.mapr.streams.impl.admin.MarlinAdminImpl;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.ojai.store.DocumentStore;

public class Streams {
    public static final String ID = "_id";
    public static final String PARTITION = "partition";
    public static final String TOPIC = "topic";
    public static final String OFFSET = "offset";
    public static final String PRODUCER = "producer";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String MAX_SCANNER_THREADS = "streams.analytics.max_scanner_threads";
    public static final String MAX_CACHE_MEMORY = "streams.analytics.cache_memory";

    public static DocumentStore getMessageStore(String streamPath) throws IOException {
        return new MessageStore(streamPath, new Configuration(), new String[0]);
    }

    public static DocumentStore getMessageStore(String streamPath, Configuration conf) throws IOException {
        return new MessageStore(streamPath, conf, (String[])null);
    }

    public static DocumentStore getMessageStore(String streamPath, String ... topics) throws IOException {
        return new MessageStore(streamPath, new Configuration(), topics);
    }

    public static DocumentStore getMessageStore(String streamPath, Configuration conf, String ... topics) throws IOException {
        return new MessageStore(streamPath, conf, topics);
    }

    public static DocumentStore getMessageStore(String streamPath, Pattern regex) throws IOException {
        return new MessageStore(streamPath, new Configuration(), regex);
    }

    public static DocumentStore getMessageStore(String streamPath, Configuration conf, Pattern regex) throws IOException {
        return new MessageStore(streamPath, conf, regex);
    }

    public static Admin newAdmin(Configuration c) throws IOException {
        return new MarlinAdminImpl(c);
    }

    public static StreamDescriptor newStreamDescriptor() {
        return new MStreamDescriptor();
    }

    static {
        ShimLoader.load();
    }
}

