/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.admin;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class AdminTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(AdminTest.class);
    private static final String PREFIX = "/jtest-" + AdminTest.class.getSimpleName() + "-";
    private static Admin madmin;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
    }

    @Test
    public void testCompression() throws IOException {
        String sname = PREFIX + "compression";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception e) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("Verify default compression is lz4");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"lz4");
        _logger.info("switch compression to zlib");
        sdesc.setCompressionAlgo("zlib");
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"zlib");
        _logger.info("switch off compression");
        sdesc.setCompressionAlgo("off");
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"off");
        _logger.info("test bad compression type");
        Exception ex = null;
        try {
            sdesc.setCompressionAlgo("zlibspecial");
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getCompressionAlgo(), (Object)"off");
        madmin.deleteStream(sname);
    }

    @Test
    public void testTTL() throws IOException {
        String sname = PREFIX + "TTL";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception e) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("Verify default ttl is 7 days");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getTimeToLiveSec(), (long)604800L);
        _logger.info("switch TTL to 1 day");
        long rsec = 86400L;
        sdesc.setTimeToLiveSec(rsec);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getTimeToLiveSec(), (long)rsec);
        _logger.info("test bad TTL");
        Exception ex = null;
        try {
            sdesc.setTimeToLiveSec(-1L);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getTimeToLiveSec(), (long)rsec);
        madmin.deleteStream(sname);
    }

    @Test
    public void testPerms() throws IOException {
        String sname = PREFIX + "Perms";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception e) {
            // empty catch block
        }
        _logger.info("test produce/listen/topic/copy perms");
        sdesc.setProducePerms("u:2001 | g:2001");
        sdesc.setConsumePerms("u:2002 | g:2002");
        sdesc.setTopicPerms("u:2003 | g:2003");
        sdesc.setCopyPerms("u:2002 | g:2003");
        madmin.createStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getProducePerms(), (Object)"u:2001 | g:2001");
        Assert.assertEquals((Object)sdesc.getConsumePerms(), (Object)"u:2002 | g:2002");
        Assert.assertEquals((Object)sdesc.getTopicPerms(), (Object)"u:2003 | g:2003");
        Assert.assertEquals((Object)sdesc.getCopyPerms(), (Object)"u:2002 | g:2003");
        _logger.info("test admin perms");
        String adminPerm = new String(sdesc.getAdminPerms() + " | u:2005");
        sdesc.setAdminPerms(adminPerm);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAdminPerms(), (Object)adminPerm);
        Assert.assertEquals((Object)sdesc.getProducePerms(), (Object)"u:2001 | g:2001");
        Assert.assertEquals((Object)sdesc.getConsumePerms(), (Object)"u:2002 | g:2002");
        Assert.assertEquals((Object)sdesc.getTopicPerms(), (Object)"u:2003 | g:2003");
        Assert.assertEquals((Object)sdesc.getCopyPerms(), (Object)"u:2002 | g:2003");
        _logger.info("test bad perms");
        Exception ex = null;
        try {
            sdesc.setAdminPerms("k:0");
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IOException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAdminPerms(), (Object)adminPerm);
        madmin.deleteStream(sname);
    }

    @Test
    public void testAutoCreateTopic() throws IOException {
        String sname = PREFIX + "autoCreate";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("test autoCreate is on by default");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAutoCreateTopics(), (Object)true);
        _logger.info("switch off autocreate");
        sdesc.setAutoCreateTopics(false);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((Object)sdesc.getAutoCreateTopics(), (Object)false);
        madmin.deleteStream(sname);
    }

    @Test
    public void testFeedsPerTopic() throws IOException {
        String sname = PREFIX + "feedsPerTopic";
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception e) {
            // empty catch block
        }
        madmin.createStream(sname, sdesc);
        _logger.info("test numPartitions=1 on by default");
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)1L);
        _logger.info("test numPartitions=4");
        sdesc.setDefaultPartitions(4);
        madmin.editStream(sname, sdesc);
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)4L);
        _logger.info("test bad numPartitions=-1");
        Exception ex = null;
        try {
            sdesc.setDefaultPartitions(0);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)4L);
        _logger.info("test bad numPartitions=8192");
        ex = null;
        try {
            sdesc.setDefaultPartitions(8192);
            madmin.editStream(sname, sdesc);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        sdesc = madmin.getStreamDescriptor(sname);
        Assert.assertEquals((long)sdesc.getDefaultPartitions(), (long)4L);
        madmin.deleteStream(sname);
    }
}

