/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.perf;

import com.mapr.streams.impl.admin.MStreamDescriptor;
import com.mapr.streams.impl.admin.MarlinAdmin;
import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class ProducerMultiPartitionTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerMultiPartitionTest.class);
    private static final String streamName = "/jtest-" + ProducerMultiPartitionTest.class.getSimpleName();
    private static MarlinAdmin madmin;
    private static int numMsgs;
    private static int numPartitions;

    @BeforeClass
    public static void setupTestClass() throws Exception {
        Configuration conf = new Configuration();
        madmin = new MarlinAdmin(conf);
        try {
            madmin.deleteStream(streamName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Before
    public void setupTest() throws Exception {
        MStreamDescriptor sdesc = new MStreamDescriptor();
        sdesc.setDefaultPartitions(numPartitions);
        madmin.createStream(streamName, sdesc);
    }

    @After
    public void cleanupTest() throws Exception {
        madmin.deleteStream(streamName);
    }

    @Test
    public void testSpecifyPartition() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(streamName, numMsgs / numPartitions, 1, numPartitions, 1, 1L, false, true, true, false, false));
    }

    @Test
    public void testHashKey() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(streamName, numMsgs / numPartitions, 1, numPartitions, 1, 1L, false, true, true, false, true));
    }

    @Test
    public void testRoundRobin() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(streamName, numMsgs / numPartitions, 1, numPartitions, 1, 1L, false, true, true, true, false));
    }

    static {
        numMsgs = 1000000;
        numPartitions = 50;
    }
}

