/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams;

import com.mapr.streams.Streams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentStore;

public class StreamAnalyzer {
    public static String streamName = null;
    public static Pattern topicRegex = null;
    public static String[] topicNames = null;
    public static String[] projections = null;
    public static boolean countMessages = true;
    public static boolean printMessages = false;
    public static int maxParallelScans = -1;
    public static long maxCacheSize = -1L;

    public static void usage() {
        System.err.println("StreamAnalyzer -path <stream-full-name>");
        System.err.println("     [ -topics <comma separated topic names> ]");
        System.err.println("     [ -regex  <regular expression representing topic names> ]");
        System.err.println("     [ -countMessages <true/false> (default: true) ]");
        System.err.println("     [ -printMessages <true/false> (default: false) ]");
        System.err.println("     [ -projectFields <comma separated field names> ");
        System.err.println("                      (Valid field names: key, value, topic, partition, offset, producer, _id.");
        System.err.println("                       Works only if printMessages is true.");
        System.err.println("                       Default: all fields.) ]");
        System.err.println("     [ -parallelScans <max number of parallel scans> (default: 16)]");
        System.err.println("     [ -maxCacheSize  <max size of Documents to cache> (default: 100MB)]");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            ArrayList<String> tokens;
            StringTokenizer st;
            if (args[i].equals("-path")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                streamName = args[i];
                continue;
            }
            if (args[i].equals("-topics")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                st = new StringTokenizer(args[i], ", ");
                tokens = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    tokens.add(st.nextToken());
                }
                topicNames = tokens.toArray(new String[tokens.size()]);
                continue;
            }
            if (args[i].equals("-regex")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                topicRegex = Pattern.compile(args[i]);
                continue;
            }
            if (args[i].equals("-countMessages")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                countMessages = Boolean.parseBoolean(args[i]);
                continue;
            }
            if (args[i].equals("-printMessages")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                printMessages = Boolean.parseBoolean(args[i]);
                continue;
            }
            if (args[i].equals("-projectFields")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                st = new StringTokenizer(args[i], ", ");
                tokens = new ArrayList();
                while (st.hasMoreTokens()) {
                    tokens.add(st.nextToken());
                }
                projections = tokens.toArray(new String[tokens.size()]);
                continue;
            }
            if (args[i].equals("-parallelScans")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                if ((maxParallelScans = Integer.parseInt(args[i])) > 0) continue;
                System.err.println("-parallelScans cannot be <= 0");
                System.exit(1);
                continue;
            }
            if (args[i].equals("-maxCacheSize")) {
                if (++i >= args.length) {
                    StreamAnalyzer.usage();
                }
                if ((maxCacheSize = Long.parseLong(args[i])) > 0L) continue;
                System.err.println("-maxCacheSize cannot be <= 0");
                System.exit(1);
                continue;
            }
            StreamAnalyzer.usage();
        }
        if (streamName == null) {
            System.err.println("Stream path is mandatory command-line option");
            StreamAnalyzer.usage();
        }
        if (projections != null && !printMessages) {
            System.err.println("Projections are only used if '-printMessages' is set to true");
            StreamAnalyzer.usage();
        }
        if (topicNames != null && topicRegex != null) {
            System.err.println("Only '-topics' or '-regex' allowed");
            StreamAnalyzer.usage();
        }
        StreamAnalyzer.runTest();
    }

    public static void runTest() throws IOException {
        DocumentStore store = null;
        Configuration conf = new Configuration();
        if (maxParallelScans > 0 || maxCacheSize > 0L) {
            if (maxParallelScans > 0) {
                conf.setInt("streams.analytics.max_scanner_threads", maxParallelScans);
            }
            if (maxCacheSize > 0L) {
                conf.setLong("streams.analytics.cache_memory", maxCacheSize);
            }
        }
        store = topicNames != null ? Streams.getMessageStore((String)streamName, (Configuration)conf, (String[])topicNames) : (topicRegex != null ? Streams.getMessageStore((String)streamName, (Configuration)conf, (Pattern)topicRegex) : Streams.getMessageStore((String)streamName, (Configuration)conf));
        DocumentStream rs = null;
        rs = projections != null ? store.find(projections) : store.find();
        Iterator iter = rs.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Document d = (Document)iter.next();
            if (printMessages) {
                if (d.getString("_id") != null) {
                    System.out.print(" ID: " + d.getString("_id"));
                }
                if (d.getString("topic") != null) {
                    System.out.print(" topic: " + d.getString("topic"));
                }
                try {
                    System.out.print(" partition: " + d.getInt("partition"));
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                try {
                    System.out.print(" offset: " + d.getLong("offset"));
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                if (d.getString("producer") != null) {
                    System.out.print(" producer: " + d.getString("producer"));
                }
                if (d.getBinary("key") != null) {
                    System.out.print(" key: <binary>");
                }
                if (d.getBinary("value") != null) {
                    System.out.print(" value: <binary>");
                }
                System.out.println();
            }
            ++count;
        }
        if (countMessages) {
            System.out.println("Total number of messages: " + count);
        }
    }
}

