/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.web.security.WebSecurityConfig;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class PamAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(PamAuthenticationProvider.class);
    private static final String ADMIN = System.getProperty("user.name");
    private static final String PAM_DIR = "/etc/pam.d/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String authMethods = System.getProperty(WebSecurityConfig.CONFIG.getProcessName() + ".authentication.types");
        if (authMethods != null && !Arrays.asList(authMethods.split(",")).contains("basic")) {
            return null;
        }
        String name = authentication.getName();
        String service = System.getProperty(WebSecurityConfig.CONFIG.getProcessName() + ".authentication.pam.service");
        ArrayList<String> pamFiles = new ArrayList<String>();
        if (service == null) {
            String[] configFiles = System.getProperty(WebSecurityConfig.CONFIG.getProcessName() + ".auth.pam.config.files").split(",");
            for (String file : configFiles) {
                if (!new File(PAM_DIR + file).canRead()) continue;
                pamFiles.add(file);
            }
        } else if (new File(PAM_DIR + service).canRead()) {
            pamFiles.add(service);
        } else {
            throw new AuthenticationServiceException("PAM config '" + service + "' not found");
        }
        for (String file : pamFiles) {
            PAM pam = null;
            try {
                pam = new PAM(file);
                String password = authentication.getCredentials().toString();
                UnixUser unixUser = pam.authenticate(name, password);
                ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
                if (name.equalsIgnoreCase(ADMIN)) {
                    grantedAuths.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
                }
                for (String group : unixUser.getGroups()) {
                    grantedAuths.add(new SimpleGrantedAuthority("ROLE_" + group.toUpperCase()));
                }
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)name, (Object)password, grantedAuths);
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = token;
                return usernamePasswordAuthenticationToken;
            }
            catch (PAMException password) {}
            continue;
            finally {
                if (pam == null) continue;
                pam.dispose();
            }
        }
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = attr.getResponse();
        String errorMessage = "PAM auth failed for user " + name;
        String headerValue = "Basic realm=" + CLDBRpcCommonUtils.getInstance().getCurrentClusterName() + "\"";
        log.error(errorMessage);
        response.setHeader("WWW-Authenticate", headerValue);
        response.setHeader("WWW-MAPR-Err-Authenticate", errorMessage);
        throw new AuthenticationServiceException(errorMessage);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

