/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.web.security.WebSecurityConfig;
import java.util.Arrays;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;

public class MapRKerberosTicketValidator
implements KerberosTicketValidator,
InitializingBean {
    private SunJaasKerberosTicketValidator kerberosTicketValidator;

    public MapRKerberosTicketValidator() {
        String authMethods = System.getProperty(WebSecurityConfig.CONFIG.getProcessName() + ".mapr.rest.auth.methods");
        Configuration oldConfig = Configuration.getConfiguration();
        AppConfigurationEntry[] webserverKerberoses = oldConfig.getAppConfigurationEntry("MAPR_WEBSERVER_KERBEROS");
        if (authMethods != null && webserverKerberoses != null && Arrays.asList(authMethods.split(",")).contains("kerberos") && webserverKerberoses.length > 0 && webserverKerberoses[0].getOptions().containsKey("principal") && webserverKerberoses[0].getOptions().containsKey("keyTab")) {
            this.kerberosTicketValidator = new SunJaasKerberosTicketValidator();
            this.kerberosTicketValidator.setServicePrincipal((String)webserverKerberoses[0].getOptions().get("principal"));
            this.kerberosTicketValidator.setKeyTabLocation((Resource)new FileSystemResource((String)webserverKerberoses[0].getOptions().get("keyTab")));
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.kerberosTicketValidator != null) {
            this.kerberosTicketValidator.afterPropertiesSet();
        }
    }

    public KerberosTicketValidation validateTicket(byte[] bytes) throws BadCredentialsException {
        return this.kerberosTicketValidator == null ? null : this.kerberosTicketValidator.validateTicket(bytes);
    }

    public void setDebug(boolean debug) {
        if (this.kerberosTicketValidator != null) {
            this.kerberosTicketValidator.setDebug(debug);
        }
    }
}

