/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFactory {
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);

    private SslFactory() {
    }

    public static KeyManagerFactory getKeyManagerFactory() throws Exception {
        try (SslConfig sslConfig = WebSecurityManager.getSslConfig(SslConfig.SslConfigScope.SCOPE_ALL);){
            String keystoreType = sslConfig.getServerKeystoreType();
            String keystoreFilePath = sslConfig.getServerKeystoreLocation();
            File keystoreFile = new File(keystoreFilePath);
            if (!keystoreFile.exists()) {
                throw new FileNotFoundException("Unable to find or load the server keystore file" + keystoreFile);
            }
            log.debug("Initializing Java KeyManagerFactory with keystore '{}', type '{}', algorithm '{}'.", new Object[]{keystoreFile, keystoreType, "PKIX"});
            String provider = "SunJSSE";
            KeyStore ksKeys = KeyStore.getInstance(keystoreType);
            char[] keyStorePassphrase = sslConfig.getServerKeystorePassword();
            ksKeys.load(new FileInputStream(keystoreFile), keyStorePassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX", "SunJSSE");
            char[] keyPassphrase = sslConfig.getServerKeyPassword();
            kmf.init(ksKeys, keyPassphrase);
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
    }
}

