/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.google.common.io.Closeables;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;

public class XmlSslConfig
implements SslConfig {
    private static final String SSL_SERVER_XML = "ssl-server.xml";
    private static final String SSL_CLIENT_XML = "ssl-client.xml";
    private final String serverTruststoreLocation;
    private final String serverTruststoreType;
    private final String serverKeystoreLocation;
    private final String serverKeystoreType;
    private final String clientTruststoreLocation;
    private final String clientTruststoreType;
    private final String clientKeystoreLocation;
    private final String clientKeystoreType;
    private final char[] serverKeyPassword;
    private final char[] serverKeystorePassword;
    private final char[] serverTruststorePassword;
    private final char[] clientKeyPassword;
    private final char[] clientKeystorePassword;
    private final char[] clientTruststorePassword;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    XmlSslConfig(SslConfig.SslConfigScope sslConfigScope) {
        String maprConfDir = WebSecurityConfig.CONFIG.getMaprConfDir();
        File sslServerXml = new File(maprConfDir, SSL_SERVER_XML);
        File sslClientXml = new File(maprConfDir, SSL_CLIENT_XML);
        FileInputStream istreamServer = null;
        FileInputStream istreamClient = null;
        try {
            Configuration conf2332 = new Configuration(true);
            istreamClient = new FileInputStream(sslClientXml);
            conf2332.addResource((InputStream)istreamClient);
            if (sslConfigScope != SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY) {
                istreamServer = new FileInputStream(sslServerXml);
                conf2332.addResource((InputStream)istreamServer);
            }
            this.serverTruststoreLocation = conf2332.get("ssl.server.truststore.location");
            this.serverTruststoreType = conf2332.get("ssl.server.truststore.type");
            this.serverKeystoreLocation = conf2332.get("ssl.server.keystore.location");
            this.serverKeystoreType = conf2332.get("ssl.server.keystore.type");
            this.serverKeyPassword = conf2332.getPassword("ssl.server.keystore.keypassword");
            this.serverKeystorePassword = conf2332.getPassword("ssl.server.keystore.password");
            this.serverTruststorePassword = conf2332.getPassword("ssl.server.truststore.password");
            this.clientTruststoreLocation = conf2332.get("ssl.client.truststore.location");
            this.clientTruststoreType = conf2332.get("ssl.client.truststore.type");
            this.clientKeystoreLocation = conf2332.get("ssl.client.keystore.location");
            this.clientKeystoreType = conf2332.get("ssl.client.keystore.type");
            this.clientKeyPassword = conf2332.getPassword("ssl.client.keystore.keypassword");
            this.clientKeystorePassword = conf2332.getPassword("ssl.client.keystore.password");
            this.clientTruststorePassword = conf2332.getPassword("ssl.client.truststore.password");
        }
        catch (IOException e) {
            try {
                throw new SecurityException("Unable to read SSL configuration from XML files", e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(istreamClient, (boolean)true);
                    Closeables.close(istreamServer, (boolean)true);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)istreamClient, (boolean)true);
            Closeables.close((Closeable)istreamServer, (boolean)true);
            return;
        }
        catch (IOException conf2332) {
            return;
        }
    }

    @Override
    public String getServerTruststoreLocation() throws SecurityException {
        return this.serverTruststoreLocation;
    }

    @Override
    public char[] getServerTruststorePassword() throws SecurityException {
        return this.serverTruststorePassword == null ? null : Arrays.copyOf(this.serverTruststorePassword, this.serverTruststorePassword.length);
    }

    @Override
    public String getServerTruststoreType() throws SecurityException {
        return this.serverTruststoreType;
    }

    @Override
    public String getServerKeystoreLocation() throws SecurityException {
        return this.serverKeystoreLocation;
    }

    @Override
    public char[] getServerKeystorePassword() throws SecurityException {
        return this.serverKeystorePassword == null ? null : Arrays.copyOf(this.serverKeystorePassword, this.serverKeystorePassword.length);
    }

    @Override
    public char[] getServerKeyPassword() {
        return this.serverKeyPassword == null ? null : Arrays.copyOf(this.serverKeyPassword, this.serverKeyPassword.length);
    }

    @Override
    public String getServerKeystoreType() throws SecurityException {
        return this.serverKeystoreType;
    }

    @Override
    public String getClientTruststoreLocation() throws SecurityException {
        return this.clientTruststoreLocation;
    }

    @Override
    public char[] getClientTruststorePassword() throws SecurityException {
        return this.clientTruststorePassword == null ? null : Arrays.copyOf(this.clientTruststorePassword, this.clientTruststorePassword.length);
    }

    @Override
    public String getClientTruststoreType() throws SecurityException {
        return this.clientTruststoreType;
    }

    @Override
    public String getClientKeystoreLocation() throws SecurityException {
        return this.clientKeystoreLocation;
    }

    @Override
    public char[] getClientKeystorePassword() throws SecurityException {
        return this.clientKeystorePassword == null ? null : Arrays.copyOf(this.clientKeystorePassword, this.clientKeystorePassword.length);
    }

    @Override
    public char[] getClientKeyPassword() {
        return this.clientKeyPassword == null ? null : Arrays.copyOf(this.clientKeyPassword, this.clientKeyPassword.length);
    }

    @Override
    public String getClientKeystoreType() throws SecurityException {
        return this.clientKeystoreType;
    }

    @Override
    public void close() {
        char[][] passwords;
        for (char[] password : passwords = new char[][]{this.serverKeyPassword, this.serverKeystorePassword, this.serverTruststorePassword, this.clientKeyPassword, this.clientKeystorePassword, this.clientTruststorePassword}) {
            if (password == null) continue;
            for (int i = 0; i < password.length; ++i) {
                password[i] = '\u0000';
            }
        }
    }
}

