/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.ojai.store.impl.FieldInBundle;
import com.mapr.ojai.store.impl.FilterIterator;
import com.mapr.ojai.store.impl.IdByteBufferStream;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.QueryDocumentStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.Value;

public class IdDocumentStream
extends QueryDocumentStream
implements IdByteBufferStream {
    private final OjaiConnection ojaiConnection;
    private final FieldInBundle fib;
    private final Value.Type idType;
    private final IndexFieldDesc.Order order;

    public IdDocumentStream(OjaiConnection ojaiConnection, FieldInBundle fib, IndexFieldDesc.Order order) {
        this.ojaiConnection = ojaiConnection;
        this.fib = fib;
        this.order = order;
        if (fib.values.size() == 0) {
            this.idType = Value.Type.BINARY;
        } else {
            LiteralExpression litExpr = fib.values.get(0);
            Value.Type litType = litExpr.getType();
            Preconditions.checkArgument((litType == Value.Type.BINARY || litType == Value.Type.STRING ? 1 : 0) != 0);
            this.idType = litType;
        }
    }

    public Iterator<Document> iterator() {
        return new IdToDocumentIterator(this.idBufferIterator());
    }

    private <T extends Comparable<? super T>> List<T> getSortedIds(Iterator<T> idIter) {
        ArrayList<Comparable> idArray = new ArrayList<Comparable>(this.fib.values.size());
        while (idIter.hasNext()) {
            Comparable id = (Comparable)idIter.next();
            idArray.add(id);
        }
        Collections.sort(idArray);
        if (this.order == IndexFieldDesc.Order.Desc) {
            Collections.reverse(idArray);
        }
        return idArray;
    }

    @Override
    public Iterator<ByteBuffer> idBufferIterator() {
        this.checkState();
        Iterator<LiteralExpression> litIter = this.fib.values.iterator();
        if (this.order == IndexFieldDesc.Order.None) {
            if (this.idType == Value.Type.BINARY) {
                return new AsIsBufferIterator(litIter);
            }
            return new IdEncodingIterator(new AsIsStringIterator(litIter));
        }
        if (this.idType == Value.Type.BINARY) {
            List<ByteBuffer> idList = this.getSortedIds(new AsIsBufferIterator(litIter));
            return idList.iterator();
        }
        List<String> idList = this.getSortedIds(new AsIsStringIterator(litIter));
        return new IdEncodingIterator(idList.iterator());
    }

    @Override
    public void getQueryPlan(List<Map<String, Object>> planList) {
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        if (this.fib != null) {
            ArrayList<String> fieldBundle = new ArrayList<String>();
            for (LiteralExpression entry : this.fib.values) {
                fieldBundle.add(entry.getLiteral());
            }
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("fieldPath", this.fib.fieldPath.toString());
            valueMap.put("fieldInBundle", fieldBundle);
            myMap.put("parameters", valueMap);
        }
        planList.add(myMap);
    }

    private class IdToDocumentIterator
    extends FilterIterator<Document, ByteBuffer> {
        public IdToDocumentIterator(Iterator<ByteBuffer> idBufferIter) {
            super(idBufferIter);
        }

        @Override
        public Document next() {
            ByteBuffer idBuffer = (ByteBuffer)this.sourceIter.next();
            Document doc = IdDocumentStream.this.ojaiConnection.newDocument();
            doc.setId(idBuffer);
            return doc;
        }
    }

    private static class AsIsBufferIterator
    extends FilterIterator<ByteBuffer, LiteralExpression> {
        public AsIsBufferIterator(Iterator<LiteralExpression> litExpr) {
            super(litExpr);
        }

        @Override
        public ByteBuffer next() {
            LiteralExpression litExpr = (LiteralExpression)this.sourceIter.next();
            ByteBuffer idBuffer = litExpr.getBinary();
            return idBuffer;
        }
    }

    private static class IdEncodingIterator
    extends FilterIterator<ByteBuffer, String> {
        public IdEncodingIterator(Iterator<String> stringIter) {
            super(stringIter);
        }

        @Override
        public ByteBuffer next() {
            String idString = (String)this.sourceIter.next();
            ByteBuffer idBuffer = IdCodec.encode((String)idString);
            return idBuffer;
        }
    }

    private static class AsIsStringIterator
    extends FilterIterator<String, LiteralExpression> {
        public AsIsStringIterator(Iterator<LiteralExpression> litExpr) {
            super(litExpr);
        }

        @Override
        public String next() {
            LiteralExpression litExpr = (LiteralExpression)this.sourceIter.next();
            String idString = litExpr.getString();
            return idString;
        }
    }
}

