/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.FieldPathStack;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.PredicateManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;

public class ExpressionOrConditionChecker
extends ExpressionVisitor {
    MutableBoolean canUseIndex;
    boolean nonOrConditionPresent;

    public ExpressionOrConditionChecker(MutableBoolean canUseIndex) {
        this.canUseIndex = canUseIndex;
        this.nonOrConditionPresent = false;
    }

    @Override
    public void visitNary(NaryOperator naryOp) {
        super.visitNary(naryOp);
        if (!this.canUseIndex.value || !naryOp.opName.equals("or")) {
            if (!this.nonOrConditionPresent && (naryOp.opName.equals("and") || naryOp.opName.equals("elementAnd"))) {
                this.nonOrConditionPresent = true;
            }
            return;
        }
        HashMap<FieldPath, List<NaryOperator>> topRelations = new HashMap<FieldPath, List<NaryOperator>>();
        HashSet<Expression> otherPredicates = new HashSet<Expression>();
        PredicateFields predicateManager = new PredicateFields(topRelations, otherPredicates);
        naryOp.gatherExpressions(0, predicateManager);
        if (topRelations.size() != 1) {
            this.canUseIndex.value = false;
            return;
        }
        FieldPath thePath = topRelations.keySet().iterator().next();
        if (thePath.toString().contains("[]") && this.nonOrConditionPresent) {
            this.canUseIndex.value = false;
            return;
        }
        HashSet<Expression> exprs = otherPredicates;
        if (exprs.size() > 0) {
            for (Expression expr : exprs) {
                FieldExpression fieldExpr;
                FieldPath fieldPath;
                if (!(expr instanceof FieldExpression) || (fieldPath = (fieldExpr = (FieldExpression)expr).getFieldPath()).equals((Object)thePath)) continue;
                this.canUseIndex.value = false;
                break;
            }
        }
    }

    public static class MutableBoolean {
        public boolean value;

        public MutableBoolean(boolean value) {
            this.value = value;
        }
    }

    private static class PredicateFields
    implements PredicateManager {
        private final FieldPathStack fieldPathStack = new FieldPathStack();
        private final Map<FieldPath, List<NaryOperator>> topRelations;
        private final Set<Expression> otherPredicates;

        public PredicateFields(Map<FieldPath, List<NaryOperator>> topRelations, Set<Expression> otherPredicates) {
            this.topRelations = topRelations;
            this.otherPredicates = otherPredicates;
        }

        @Override
        public void addTopRelation(FieldPath fieldPath, NaryOperator nOp) {
            FieldPath newPath = this.fieldPathStack.getPath(fieldPath);
            List<NaryOperator> nOpList = this.topRelations.get(newPath);
            if (nOpList == null) {
                nOpList = new LinkedList<NaryOperator>();
                this.topRelations.put(newPath, nOpList);
            }
            nOpList.add(nOp);
        }

        @Override
        public void addOtherRelation(Expression expression) {
            this.otherPredicates.add(expression);
        }

        @Override
        public void pushPath(FieldPath fieldPath) {
            this.fieldPathStack.push(fieldPath);
        }

        @Override
        public void popPath() {
            this.fieldPathStack.pop();
        }
    }
}

