/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ojai.store.impl.ByteArrayKey;
import com.mapr.ojai.store.impl.DedupStream;
import com.mapr.ojai.store.impl.MaterializedDocumentStream;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.tests.annotations.ClusterTest;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.exceptions.OjaiException;

@Category(value={ClusterTest.class})
public class TestPipelineComponents
extends OjaiTest {
    private static final byte[] testArray1 = new byte[]{1, 2, 3, 4, 5, 6};
    private static final byte[] testArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7};
    private static final byte[] testArray3 = new byte[]{10, 2, 3};

    @Test
    public void testByteArrayKey() {
        ByteArrayKey k1 = new ByteArrayKey(testArray1, false);
        ByteArrayKey k1Copy = new ByteArrayKey(testArray1, true);
        Assert.assertEquals((long)k1.hashCode(), (long)k1Copy.hashCode());
        Assert.assertTrue((boolean)k1.equals((Object)k1Copy));
        Assert.assertTrue((boolean)k1.equals((Object)k1));
        Assert.assertFalse((boolean)k1.equals(null));
        ByteArrayKey k2 = new ByteArrayKey(testArray2, false);
        ByteArrayKey k3 = new ByteArrayKey(testArray3, false);
        Assert.assertFalse((boolean)k1.equals((Object)k2));
        Assert.assertFalse((boolean)k1.equals((Object)k3));
        Assert.assertFalse((boolean)k2.equals((Object)k3));
        ByteArrayKey k4 = new ByteArrayKey("foo".getBytes(), false);
        ByteArrayKey k5 = new ByteArrayKey("bar".getBytes(), true);
        Assert.assertFalse((k4.hashCode() == k5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)k4.equals((Object)k5));
    }

    @Test
    public void testDedupStream_mostlyDupes() {
        String[] ids = new String[]{"foo", "bar", "zing"};
        CyclicIdGenerator docStream = new CyclicIdGenerator(ids, DedupStream.MAX_QUERY_DEDUP_LIMIT + 103);
        int uniqueDocs = 0;
        try (DedupStream dedupStream = new DedupStream((DocumentStream)docStream);){
            for (Document doc : dedupStream) {
                Assert.assertNotNull((Object)doc.getId());
                ++uniqueDocs;
            }
        }
        Assert.assertEquals((long)ids.length, (long)uniqueDocs);
    }

    @Test(expected=OjaiException.class)
    public void testDedupStream_exceedLimit() {
        SequentialIdGenerator docStream = new SequentialIdGenerator(DedupStream.MAX_QUERY_DEDUP_LIMIT + 119);
        try (DedupStream dedupStream = new DedupStream((DocumentStream)docStream);){
            for (Document doc : dedupStream) {
                Assert.assertNotNull((Object)doc.getId());
            }
        }
        Assert.fail();
    }

    private static void testDedupStream_addDocsForId(List<Document> docList, String stringId) {
        Document doc = MapRDBImpl.newDocument();
        doc.setId(stringId);
        docList.add(doc);
        doc = MapRDBImpl.newDocument();
        byte[] b = stringId.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.wrap(b);
        doc.setId(byteBuffer);
    }

    @Test
    public void testDedupStream_mixedIdTypes() {
        LinkedList<Document> docList = new LinkedList<Document>();
        TestPipelineComponents.testDedupStream_addDocsForId(docList, "2010");
        TestPipelineComponents.testDedupStream_addDocsForId(docList, "foo");
        MaterializedDocumentStream docStream = new MaterializedDocumentStream(docList, false, null, null, new FieldPath[0]);
        int uniqueDocs = 0;
        try (DedupStream dedupStream = new DedupStream((DocumentStream)docStream);){
            for (Document doc : dedupStream) {
                Assert.assertNotNull((Object)doc.getId());
                ++uniqueDocs;
            }
        }
        Assert.assertEquals((long)docList.size(), (long)uniqueDocs);
    }

    private static class CyclicIdGenerator
    implements DocumentStream {
        private final String[] ids;
        private final int totalRows;

        public CyclicIdGenerator(String[] ids, int totalRows) {
            this.ids = ids;
            this.totalRows = totalRows;
        }

        public void close() throws OjaiException {
        }

        public Iterable<DocumentReader> documentReaders() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Document> iterator() {
            return new DocGenerator();
        }

        public void streamTo(DocumentListener arg0) {
            throw new UnsupportedOperationException();
        }

        private class DocGenerator
        implements Iterator<Document> {
            private int nRows;
            private int nextId;

            private DocGenerator() {
            }

            @Override
            public boolean hasNext() {
                return this.nRows < CyclicIdGenerator.this.totalRows;
            }

            @Override
            public Document next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Document doc = MapRDBImpl.newDocument();
                doc.setId(CyclicIdGenerator.this.ids[this.nextId]);
                doc.set(CyclicIdGenerator.this.ids[this.nextId], "blah");
                this.nextId = (this.nextId + 1) % CyclicIdGenerator.this.ids.length;
                ++this.nRows;
                return doc;
            }
        }
    }

    private static class SequentialIdGenerator
    implements DocumentStream {
        private final int totalRows;

        public SequentialIdGenerator(int totalRows) {
            this.totalRows = totalRows;
        }

        public void close() throws OjaiException {
        }

        public Iterable<DocumentReader> documentReaders() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Document> iterator() {
            return new DocGenerator();
        }

        public void streamTo(DocumentListener arg0) {
            throw new UnsupportedOperationException();
        }

        private class DocGenerator
        implements Iterator<Document> {
            private int nRows;

            private DocGenerator() {
            }

            @Override
            public boolean hasNext() {
                return this.nRows < SequentialIdGenerator.this.totalRows;
            }

            @Override
            public Document next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String id = Integer.toString(this.nRows);
                Document doc = MapRDBImpl.newDocument();
                doc.setId(id);
                doc.set("foo", 42);
                ++this.nRows;
                return doc;
            }
        }
    }
}

