/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.DBDocumentStream;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MultiGet;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.ojai.DBDOMDocumentReader;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.AppsUserProfiles;
import com.mapr.ojai.store.impl.CollectingDocumentListener;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.StringGenerator;
import com.mapr.ojai.store.impl.UnionDocumentStream;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentConstants;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.SortOrder;
import org.ojai.store.exceptions.StoreNotFoundException;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Documents;

@Category(value={ClusterTest.class})
public class TestOjaiDocumentStore
extends OjaiTest {
    private static final int TIMEOUT_SECONDS = 5;
    private static final String TABLE_NAME = "user_profiles_doc_store";
    private static final String SIZEOF_TABLE = "sizeof_t";
    private static final String TYPEOF_TABLE = "typeof_t";
    private static final String MATCHES_TABLE = "matches_t";
    private static final String EQUALS_TABLE = "equals_t";
    private static final SharedTestTable sharedTable28535 = new SharedTestTable("bug28535"){

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            String tableName = DBTests.getFullPath((String)rawTableName);
            JsonTable table = DBTests.createOrGetTable((String)rawTableName);
            if (table != null) {
                table.close();
            }
            return tableName;
        }

        @Override
        public long getNumRows() {
            return 0L;
        }
    };
    private static final Class<?>[] bug27711Case = new Class[]{Bug27711Float.class, Bug27711Int.class, Bug27711String.class};
    private static final SharedTable27809 sharedTable27809 = new SharedTable27809();
    private static SharedTable27024 sharedTable27024 = new SharedTable27024();
    private static final SharedTestTable sharedTable27954 = new SharedTestTable("bug27954"){

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            String tableName = DBTests.getFullPath((String)rawTableName);
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Document doc1 = connection.newDocument();
                doc1.setId("1");
                doc1.set("a", 1L);
                doc1.set("b", "anisha");
                table.insert(doc1);
                Document doc2 = connection.newDocument();
                doc2.setId("2");
                doc2.set("a", 2L);
                doc2.set("b", "zara");
                table.insert(doc2);
                Document doc3 = connection.newDocument();
                doc3.setId("3");
                doc3.set("a", 3L);
                doc3.set("c", "pk");
                table.insert(doc3);
            }
            return tableName;
        }

        @Override
        public long getNumRows() {
            return 3L;
        }
    };
    private static final String MULTIGET_TABLE = "multiget";
    private static SharedTable6SampleIndexUsage sharedTable6SampleIndexUsage = new SharedTable6SampleIndexUsage();
    private static SharedTableListComplexTypesQueries sharedTableListComplexTypesQueries = new SharedTableListComplexTypesQueries();

    @BeforeClass
    public static void setupTest() throws Exception {
        TestOjaiDocumentStore.cleanupTest();
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupTest() throws IOException {
        DBTests.deleteTables((String[])new String[]{TABLE_NAME});
        DBTests.deleteTables((String[])new String[]{SIZEOF_TABLE});
        DBTests.deleteTables((String[])new String[]{TYPEOF_TABLE});
    }

    @Test
    public void testFind() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            Query query = connection.newQuery().select(new String[]{"last_name"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)4L, (long)docList.size());
        }
    }

    @Test
    public void testFindById() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            List<Document> zoolanderList = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "Zoolander");
            Assert.assertEquals((long)0L, (long)zoolanderList.size());
            List<Document> smithList = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "dsimon");
            Assert.assertEquals((long)1L, (long)smithList.size());
        }
    }

    @Test
    public void testFindByIdBatch() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            BaseJsonTable jsonTable = table;
            ByteBuffer[] ids = new ByteBuffer[]{IdCodec.encode((String)"dsimon"), IdCodec.encode((String)"mdupont")};
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)2L, (long)docList.size());
        }
    }

    @Test
    public void testFindByIdBatchUnsorted() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            BaseJsonTable jsonTable = table;
            ByteBuffer[] ids = new ByteBuffer[]{IdCodec.encode((String)"mdupont"), IdCodec.encode((String)"dsimon")};
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)2L, (long)docList.size());
            Assert.assertEquals((Object)((Document)docList.get(0)).getString("first_name"), (Object)"Maxime");
            Assert.assertEquals((Object)((Document)docList.get(1)).getString("last_name"), (Object)"Simon");
        }
    }

    @Test
    public void testFindByIdBatchNonExistentID() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            BaseJsonTable jsonTable = table;
            ByteBuffer[] ids = new ByteBuffer[]{IdCodec.encode((String)"Zoolander"), IdCodec.encode((String)"dsimon")};
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)1L, (long)docList.size());
            Assert.assertEquals((Object)((Document)docList.get(0)).getString("last_name"), (Object)"Simon");
        }
    }

    private static void testIdInDoQuery(DocumentStore docStore, Query query, List<String> idList, boolean expectId) {
        query.build();
        Assert.assertEquals((Object)expectId, (Object)((OjaiQuery)query).includeId());
        try (QueryResult docStream = docStore.find(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                Assert.assertTrue((boolean)idList.contains(id));
                String lastName = doc.getString("last_name");
                Assert.assertNotNull((Object)lastName);
                String firstName = doc.getString("first_name");
                Assert.assertNotNull((Object)firstName);
                String docString = doc.toString();
                Assert.assertEquals((Object)expectId, (Object)docString.contains("\"_id\":"));
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
        }
    }

    @Test
    public void testIdIn() {
        ImmutableList idList = ImmutableList.of((Object)"dsimon", (Object)"mdupont");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            QueryCondition condition = connection.newCondition().in(DocumentConstants.ID_FIELD, (List)idList).build();
            Query query = connection.newQuery().where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, query, (List<String>)idList, true);
            Query queryStar = connection.newQuery().select(new String[]{"*"}).where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, queryStar, (List<String>)idList, true);
            Query queryFields = connection.newQuery().select(new String[]{"last_name", "first_name"}).where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, queryFields, (List<String>)idList, false);
            Query queryFieldsId = connection.newQuery().select(new String[]{"last_name", "first_name", "_id"}).where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, queryFieldsId, (List<String>)idList, true);
        }
    }

    @Test
    public void testDirectQueries() throws Exception {
        String tablePath = DBTests.getFullPath((String)TABLE_NAME);
        try (JsonTable table = DBTests.getTable((String)TABLE_NAME);){
            DBTests.createIndex((JsonTable)table, (String)"last_name_idx", (boolean)false, (int)0, (String[])new String[]{"last_name"}, null, (String[])new String[]{"first_name"});
        }
        String LAST_NAME = "Simon";
        String FIRST_NAME = "David";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(tablePath);
            Assert.assertNotNull((Object)docStore);
            Query coverQuery = connection.newQuery().select(new String[]{"last_name", "first_name"}).where(connection.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Simon").build()).build();
            try (QueryResult coverStream = docStore.find(coverQuery);){
                Document coverDocument = DBTests.getSingleDocument((DocumentStream)coverStream);
                Assert.assertNotNull((Object)coverDocument);
                Assert.assertEquals((Object)"Simon", (Object)coverDocument.getString("last_name"));
                Assert.assertEquals((Object)"David", (Object)coverDocument.getString("first_name"));
                Assert.assertNull((Object)coverDocument.getDate("dob"));
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)coverStream));
                Assert.assertTrue((boolean)(coverStream instanceof DBDocumentStream));
            }
            Query nonCoverQuery = connection.newQuery().select(new String[]{"last_name", "dob"}).where(connection.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Simon").build()).build();
            try (QueryResult nonCoverStream = docStore.find(nonCoverQuery);){
                Document nonCoverDocument = DBTests.getSingleDocument((DocumentStream)nonCoverStream);
                Assert.assertNotNull((Object)nonCoverDocument);
                Assert.assertEquals((Object)"Simon", (Object)nonCoverDocument.getString("last_name"));
                Assert.assertNull((Object)nonCoverDocument.getString("first_name"));
                Assert.assertNotNull((Object)nonCoverDocument.getDate("dob"));
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)nonCoverStream));
            }
        }
    }

    @Test
    public void testDirectQueries_id_range() throws IOException {
        String tablePath = DBTests.getFullPath((String)TABLE_NAME);
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            String lowerBound = "dt";
            String upperBound = "rr";
            Query coverQuery = connection.newQuery().select(new String[]{"_id", "last_name", "first_name"}).where(connection.newCondition().and().is("_id", QueryCondition.Op.GREATER, "dt").is("_id", QueryCondition.Op.LESS, "rr").close().build()).build();
            QueryResult docStream = docStore.find(coverQuery);
            int docCount = 0;
            for (Document doc : docStream) {
                ++docCount;
                String id = doc.getIdString();
                Assert.assertTrue((id.compareTo("dt") > 0 ? 1 : 0) != 0);
                Assert.assertTrue((id.compareTo("rr") < 0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
        }
    }

    private void testQuery_offset_limit(OjaiQueryProperties.QueryPath queryPath) throws Exception {
        String tablePath = DBTests.getFullPath((String)TABLE_NAME);
        FieldPath lastPath = FieldPath.parseFrom((String)"last_name");
        FieldPath firstPath = FieldPath.parseFrom((String)"first_name");
        FieldPath[] fieldPaths = new FieldPath[]{lastPath, firstPath};
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(tablePath);
            Assert.assertNotNull((Object)docStore);
            Query query = connection.newQuery().select(fieldPaths).orderBy(fieldPaths).limit(1L).offset(2L);
            if (queryPath == OjaiQueryProperties.QueryPath.DRILL) {
                query.setOption("ojai.mapr.query.force-drill", (Object)true);
            }
            query.build();
            OjaiTest.DocumentStreamRef docRef = new OjaiTest.DocumentStreamRef();
            List<Document> streamedResult = OjaiTest.collectStreamingFind(docStore, query, 5, docRef);
            Assert.assertEquals((long)1L, (long)streamedResult.size());
            Document streamedDoc = streamedResult.get(0);
            Assert.assertEquals((Object)"Simon", (Object)streamedDoc.getString("last_name"));
            Assert.assertEquals((Object)"David", (Object)streamedDoc.getString("first_name"));
            TestOjaiDocumentStore.assertQueryPath(docRef.docStream, queryPath);
            LinkedList<Document> iteratedResult = new LinkedList<Document>();
            QueryResult iteratedStream = docStore.find(query);
            for (Document doc : iteratedStream) {
                iteratedResult.add(doc);
            }
            Assert.assertEquals((long)1L, (long)iteratedResult.size());
            Document iteratedDoc = (Document)iteratedResult.get(0);
            Assert.assertEquals((Object)"Simon", (Object)iteratedDoc.getString("last_name"));
            TestOjaiDocumentStore.assertQueryPath((DocumentStream)iteratedStream, queryPath);
            iteratedStream.close();
            LinkedList<Document> readerResult = new LinkedList<Document>();
            QueryResult readerStream = docStore.find(query);
            Iterable readerIterable = readerStream.documentReaders();
            for (DocumentReader docReader : readerIterable) {
                DocumentBuilder docBuilder = TestOjaiDocumentStore.getDriver().newDocumentBuilder();
                Documents.writeReaderToBuilder((DocumentReader)docReader, (DocumentBuilder)docBuilder);
                Document doc = docBuilder.getDocument();
                readerResult.add(doc);
            }
            Assert.assertEquals((long)1L, (long)readerResult.size());
            Document readerDoc = (Document)readerResult.get(0);
            Assert.assertEquals((Object)"Simon", (Object)readerDoc.getString("last_name"));
            TestOjaiDocumentStore.assertQueryPath((DocumentStream)iteratedStream, queryPath);
            Assert.assertEquals((Object)streamedDoc, (Object)iteratedDoc);
            Assert.assertEquals((Object)iteratedDoc, (Object)readerDoc);
        }
    }

    @Test
    public void testQuery_offset_limit() throws Exception {
        this.testQuery_offset_limit(OjaiQueryProperties.QueryPath.DRILL);
        try (JsonTable table = DBTests.getTable((String)TABLE_NAME);){
            DBTests.createIndex((JsonTable)table, (String)"lnfn_idx", (boolean)false, (int)0, (String[])new String[]{"last_name", "first_name"}, null, null);
        }
        DBTests.waitForIndexFlush((String)TABLE_NAME);
        this.testQuery_offset_limit(OjaiQueryProperties.QueryPath.DIRECT);
    }

    private static List<Document> findByStringField(Connection connection, DocumentStore docStore, FieldPath fieldPath, String id, OjaiQueryProperties.QueryPath expectedPath) {
        Query query = connection.newQuery().where(connection.newCondition().is(fieldPath, QueryCondition.Op.EQUAL, id).build()).build();
        LinkedList<Document> docList = new LinkedList<Document>();
        Semaphore doneSem = new Semaphore(0);
        QueryResult docStream = docStore.find(query);
        Assert.assertEquals((Object)expectedPath, (Object)((OjaiQueryProperties)docStream).getQueryPath());
        docStream.streamTo((DocumentListener)new CollectingDocumentListener(docList, doneSem));
        try {
            doneSem.tryAcquire(1, 5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("timed out waiting for result", ex);
        }
        return docList;
    }

    private static List<Document> findByStringId(Connection connection, DocumentStore docStore, String id) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)docStore);
        Preconditions.checkNotNull((Object)id);
        OjaiDocumentStore ojaiStore = (OjaiDocumentStore)docStore;
        Assert.assertNotNull((Object)ojaiStore);
        List<Document> docList = TestOjaiDocumentStore.findByStringField(connection, docStore, DocumentConstants.ID_FIELD, id, OjaiQueryProperties.QueryPath.DIRECT);
        return docList;
    }

    @Test
    public void testDeleteById() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            List<Document> listBefore = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "jdoe");
            Assert.assertEquals((long)1L, (long)listBefore.size());
            Document idDoc = connection.newDocument();
            idDoc.set(DocumentConstants.ID_FIELD, "jdoe");
            docStore.delete(idDoc);
            docStore.flush();
            List<Document> listAfter = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "jdoe");
            Assert.assertEquals((long)0L, (long)listAfter.size());
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testFindByOtherField() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiStore = (OjaiDocumentStore)docStore;
            Assert.assertNotNull((Object)ojaiStore);
            List<Document> docList = TestOjaiDocumentStore.findByStringField((Connection)connection, docStore, AppsUserProfiles.FIRST_NAME_FIELD, "David", OjaiQueryProperties.QueryPath.DIRECT);
            Assert.assertEquals((long)1L, (long)docList.size());
            Document doc = docList.remove(0);
            Assert.assertNotNull((Object)doc);
            String lastName = doc.getString(AppsUserProfiles.LAST_NAME_FIELD);
            Assert.assertEquals((Object)"Simon", (Object)lastName);
        }
    }

    private static Document insertAbs(Connection connection, JsonTable table, String id, String a, String b, String s) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("a", a);
        document.set("b", b);
        document.set("s", s);
        table.insert(document);
        return document;
    }

    @Test
    public void testBug28386() throws IOException {
        String TEST_TABLE_NAME = "testBug28386_t";
        String tablePath = DBTests.getFullPath((String)"testBug28386_t");
        JsonTable table = DBTests.createOrGetTable((String)"testBug28386_t");
        if (table != null) {
            table.close();
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            table2.insert(connection.newDocument().set("_id", "1").setArray("a", new int[]{1, 2, 3, 4}));
            table2.flush();
            DBTests.waitForRowCount((String)table2.getName(), (long)1L);
            Query query1 = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"a[1]"}).select(new String[]{"a[3]"}).orderBy(new String[]{"a[2]"}).build();
            QueryResult docStream = ojaiDocStore.find(query1);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
            int docCount = 0;
            for (DocumentReader reader : docStream.documentReaders()) {
                Assert.assertTrue((boolean)(reader instanceof DBDOMDocumentReader));
                Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
                Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
                Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)reader.next());
                Assert.assertEquals((long)1L, (long)reader.getArrayIndex());
                Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)reader.next());
                Assert.assertEquals((long)3L, (long)reader.getArrayIndex());
                Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
                Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
                Assert.assertNull((Object)reader.next());
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
    }

    @Test
    public void testFind_sizeOf() throws IOException {
        String tablePath = DBTests.getFullPath((String)SIZEOF_TABLE);
        JsonTable table = DBTests.createOrGetTable((String)SIZEOF_TABLE);
        if (table != null) {
            table.close();
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertAbs((Connection)connection, (JsonTable)table2, "1", "a1", "b1", "s2");
            TestOjaiDocumentStore.insertAbs((Connection)connection, (JsonTable)table2, "2", "a2", "b2", "s33");
            TestOjaiDocumentStore.insertAbs((Connection)connection, (JsonTable)table2, "3", "a3", "b3", "s444");
            TestOjaiDocumentStore.insertAbs((Connection)connection, (JsonTable)table2, "4", "a4", "b4", "s");
            DBTests.waitForRowCount((String)table2.getName(), (long)4L);
            QueryCondition queryCondSizeOf = connection.newCondition().sizeOf("s", QueryCondition.Op.GREATER_OR_EQUAL, 3L).build();
            DocumentStream tableStream = table2.find(queryCondSizeOf, new String[]{"a", "b", "s"});
            int docCount = 0;
            for (Document doc : tableStream) {
                String s = doc.getString("s");
                Assert.assertTrue((s.length() >= 3 ? 1 : 0) != 0);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Query querySortedSizeOf = connection.newQuery().select(new String[]{"a", "b", "s"}).where(connection.newCondition().sizeOf("s", QueryCondition.Op.LESS_OR_EQUAL, 2L).build()).orderBy(new String[]{"b"}).build();
            QueryResult drillStream = docStore.find(querySortedSizeOf);
            docCount = 0;
            String lastB = "";
            for (Document doc : drillStream) {
                String s = doc.getString("s");
                Assert.assertTrue((s.length() <= 2 ? 1 : 0) != 0);
                String b = doc.getString("b");
                Assert.assertTrue((b.compareTo(lastB) > 0 ? 1 : 0) != 0);
                lastB = b;
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
        }
    }

    private static Document insertVts(Connection connection, JsonTable table, String id, Object v, String t) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("t", t);
        if (v instanceof String) {
            document.set("v", (String)v);
        } else if (v instanceof Integer) {
            document.set("v", ((Integer)v).intValue());
        } else {
            throw new IllegalArgumentException("no case for v of type " + v.getClass());
        }
        table.insert(document);
        return document;
    }

    @Test
    public void testFind_typeOf() throws IOException {
        String tablePath = DBTests.getFullPath((String)TYPEOF_TABLE);
        JsonTable table = DBTests.createOrGetTable((String)TYPEOF_TABLE);
        if (table != null) {
            table.close();
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertVts((Connection)connection, (JsonTable)table2, "1", "foo", "STRING");
            TestOjaiDocumentStore.insertVts((Connection)connection, (JsonTable)table2, "2", 17, "INT");
            DBTests.waitForRowCount((String)table2.getName(), (long)2L);
            Query queryTypeOf = connection.newQuery().where(connection.newCondition().typeOf("v", Value.Type.STRING).build()).build();
            QueryResult typeOfDrillStream = docStore.find(queryTypeOf);
            int docCount = 0;
            for (Document doc : typeOfDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Query queryNotTypeOf = connection.newQuery().where(connection.newCondition().notTypeOf("v", Value.Type.STRING).build()).build();
            QueryResult notTypeOfDrillStream = docStore.find(queryNotTypeOf);
            docCount = 0;
            for (Document doc : notTypeOfDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
    }

    private static Document insertS(Connection connection, JsonTable table, String id, String s) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("s", s);
        table.insert(document);
        return document;
    }

    @Test
    public void testFind_matches() throws IOException {
        String tablePath = DBTests.getFullPath((String)MATCHES_TABLE);
        JsonTable table = DBTests.createOrGetTable((String)MATCHES_TABLE);
        if (table != null) {
            table.close();
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertS((Connection)connection, (JsonTable)table2, "1", "foo");
            TestOjaiDocumentStore.insertS((Connection)connection, (JsonTable)table2, "2", "42");
            DBTests.waitForRowCount((String)table2.getName(), (long)2L);
            String regex = "[0-9]+";
            Query queryMatches = connection.newQuery().where(connection.newCondition().matches("s", "[0-9]+").build()).build();
            QueryResult matchesDrillStream = docStore.find(queryMatches);
            int docCount = 0;
            for (Document doc : matchesDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Query queryNotMatches = connection.newQuery().where(connection.newCondition().notMatches("s", "[0-9]+").build()).build();
            QueryResult notMatchesDrillStream = docStore.find(queryNotMatches);
            docCount = 0;
            for (Document doc : notMatchesDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
    }

    private static List<Object> makeList(Object ... items) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object o : items) {
            list.add(o);
        }
        return list;
    }

    private static Document insertL(Connection connection, JsonTable table, String id, Object ... items) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("list", TestOjaiDocumentStore.makeList(items));
        table.insert(document);
        return document;
    }

    @Test
    public void testFind_equals() throws IOException {
        String tablePath = DBTests.getFullPath((String)EQUALS_TABLE);
        JsonTable table = DBTests.createOrGetTable((String)EQUALS_TABLE);
        if (table != null) {
            table.close();
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertL((Connection)connection, (JsonTable)table2, "1", "foo", "Bar", "Baz");
            TestOjaiDocumentStore.insertL((Connection)connection, (JsonTable)table2, "2", 42, 17);
            DBTests.waitForRowCount((String)table2.getName(), (long)2L);
            Query equalsQuery = connection.newQuery().where(connection.newCondition().equals("list", TestOjaiDocumentStore.makeList(42, 17)).build()).build();
            QueryResult equalsStream = docStore.find(equalsQuery);
            int docCount = 0;
            for (Document doc : equalsStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath((DocumentStream)equalsStream, OjaiQueryProperties.QueryPath.DIRECT);
            Query notEqualsQuery = connection.newQuery().where(connection.newCondition().notEquals("list", TestOjaiDocumentStore.makeList(42, 17)).build()).build();
            QueryResult notEqualsDrillStream = docStore.find(notEqualsQuery);
            docCount = 0;
            for (Document doc : notEqualsDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath((DocumentStream)notEqualsDrillStream, OjaiQueryProperties.QueryPath.DIRECT);
        }
    }

    private static void insertFoo(Connection connection, DocumentStore docStore, String id, int foo) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("foo", foo);
        docStore.insert(doc);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={ClusterTest.class})
    public void testWaitForCommitInvalid1() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable28535.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites(new String("invalid"));
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    @Category(value={ClusterTest.class})
    public void testWaitForCommitInvalid2() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable28535.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites();
                docStore.beginTrackingWrites();
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    @Category(value={ClusterTest.class})
    public void testWaitForCommitInvalid3() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable28535.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites();
                String ctx = docStore.endTrackingWrites();
                docStore.beginTrackingWrites();
                docStore.beginTrackingWrites(ctx);
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testWaitForCommit() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String rawTableName = "wait_one";
            this.addCleanupTable("wait_one");
            JsonTable table = DBTests.createOrGetTable((String)"wait_one");
            if (table != null) {
                table.close();
            }
            String tableName = DBTests.getFullPath((String)"wait_one");
            this.addCleanupTable(tableName);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites();
                TestOjaiDocumentStore.insertFoo((Connection)connection, docStore, "1", 7);
                TestOjaiDocumentStore.insertFoo((Connection)connection, docStore, "2", 16);
                TestOjaiDocumentStore.insertFoo((Connection)connection, docStore, "3", 23);
                String commitContext = docStore.endTrackingWrites();
                Query query = connection.newQuery().waitForTrackedWrites(commitContext).select(new String[]{"foo"}).where(connection.newCondition().is("foo", QueryCondition.Op.GREATER_OR_EQUAL, 17).build()).build();
                try (QueryResult docStream = docStore.find(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        int foo = doc.getInt("foo");
                        Assert.assertTrue((foo >= 17 ? 1 : 0) != 0);
                        ++docCount;
                    }
                    Assert.assertEquals((long)1L, (long)docCount);
                }
            }
        }
    }

    @Test
    public void testQuery_bug27718() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName;
            String rawTableName = "bug27718";
            this.addCleanupTable("bug27718");
            int nRows = 300;
            int matchCount = 0;
            try (JsonTable table = DBTests.createOrGetTable((String)"bug27718");){
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                DBTests.createIndex((JsonTable)table, (String)"bug27718_idx", (boolean)false, (int)0, (String[])new String[]{"v1"}, (SortOrder[])new SortOrder[]{SortOrder.DESC}, null);
                Random random = new Random(27718L);
                for (int i = 1; i <= 300; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    int v1 = 200 - random.nextInt(400);
                    doc.set("v1", v1);
                    table.insert(doc);
                    if (v1 <= -100 || v1 > 100) continue;
                    ++matchCount;
                }
            }
            Assert.assertTrue((matchCount > 0 ? 1 : 0) != 0);
            DBTests.waitForIndexFlush((String)"bug27718");
            DBTests.waitForRowCount((String)"bug27718", (long)300L);
            Query query = connection.newQuery().select(new String[]{"v1", "_id"}).where(connection.newCondition().and().is("v1", QueryCondition.Op.GREATER, -100).is("v1", QueryCondition.Op.LESS_OR_EQUAL, 100).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    int v1 = doc.getInt("v1");
                    Assert.assertTrue((v1 > -100 ? 1 : 0) != 0);
                    Assert.assertTrue((v1 <= 100 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)matchCount, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug29191_project_hashedIndex() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName;
            String rawTableName = "bug29191";
            this.addCleanupTable("bug29191");
            int nRows = 300;
            int matchCount = 0;
            String indexName = "bug29191_idx";
            try (JsonTable table = DBTests.createOrGetTable((String)"bug29191");){
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                DBTests.createIndex((String)table.getPath().toString(), (String)"bug29191_idx", (String[])new String[]{"v1"}, null, (boolean)true, (int)10);
                Random random = new Random(29191L);
                for (int i = 1; i <= 300; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    int v1 = 200 - random.nextInt(400);
                    doc.set("v1", v1);
                    table.insert(doc);
                    if (v1 <= -100 || v1 > 100) continue;
                    ++matchCount;
                }
            }
            Assert.assertTrue((matchCount > 0 ? 1 : 0) != 0);
            DBTests.waitForIndexFlush((String)"bug29191");
            DBTests.waitForRowCount((String)"bug29191", (long)300L);
            Query query = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)"bug29191_idx").select(new String[]{"v1", "_id"}).where(connection.newCondition().and().is("v1", QueryCondition.Op.GREATER, -100).is("v1", QueryCondition.Op.LESS_OR_EQUAL, 100).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    int v1 = doc.getInt("v1");
                    Assert.assertTrue((v1 > -100 ? 1 : 0) != 0);
                    Assert.assertTrue((v1 <= 100 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)matchCount, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug27711() throws Exception {
        StringGenerator fieldGenerator = new StringGenerator(5, 27711L);
        for (Class<?> klass : bug27711Case) {
            Bug27711 test = (Bug27711)klass.getConstructor(null).newInstance(null);
            String rawTableName = test.getRawTableName();
            String fieldName = fieldGenerator.nextUniqueString();
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                this.addCleanupTable(rawTableName);
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                DBTests.createIndex((JsonTable)table, (String)(rawTableName + Bug27711.Direction.ASC.getSuffix() + "_idx"), (boolean)false, (int)0, (String[])new String[]{fieldName + Bug27711.Direction.ASC.getSuffix()}, null, null);
                DBTests.createIndex((JsonTable)table, (String)(rawTableName + Bug27711.Direction.DESC.getSuffix() + "_idx"), (boolean)false, (int)0, (String[])new String[]{fieldName + Bug27711.Direction.DESC.getSuffix()}, (SortOrder[])new SortOrder[]{SortOrder.DESC}, null);
                for (int i = 1; i <= 83; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    test.setDocFields(doc, fieldName);
                    table.insert(doc);
                }
                test.doneInserting();
                DBTests.waitForRowCount((String)rawTableName, (long)83L);
                DBTests.waitForIndexFlush((String)rawTableName);
                try (DocumentStore docStore = connection.getStore(tableName);){
                    test.testQueries((Connection)connection, rawTableName, fieldName, Bug27711.Direction.ASC, docStore);
                    test.testQueries((Connection)connection, rawTableName, fieldName, Bug27711.Direction.DESC, docStore);
                }
            }
        }
    }

    @Test
    public void testQuery_bug27809() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            Query query = connection.newQuery().select(new String[]{"s1"}).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String s1 = doc.getString("s1");
                    Assert.assertNotNull((Object)s1);
                    ++docCount;
                }
                Assert.assertEquals((long)sharedTable27809.getNumRows(), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((Object)sharedTable27809.getIndexName(), (Object)TestOjaiDocumentStore.getIndexUsed((DocumentStream)docStream));
            }
        }
    }

    private static void bug27024_querySExists(Connection connection, String tableName, Query query, int nonNullStrings, String indexName) {
        try (DocumentStore docStore = connection.getStore(tableName);
             QueryResult docStream = docStore.find(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                String s = doc.getString("s");
                Assert.assertNotNull((Object)s);
                ++docCount;
            }
            Assert.assertEquals((long)nonNullStrings, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
        }
    }

    @Test
    public void testQuery_bug27024() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            String rawTableName = sharedTable27024.getRawTableName();
            int nonNullStrings = sharedTable27024.getNonNullStrings();
            int nRows = (int)sharedTable27024.getNumRows();
            String indexName = sharedTable27024.getIndexName();
            Assert.assertTrue((nonNullStrings > 0 ? 1 : 0) != 0);
            Assert.assertNotEquals((long)nRows, (long)nonNullStrings);
            Query querySExists = connection.newQuery().select(new String[]{"s"}).where(connection.newCondition().exists("s").build()).build();
            TestOjaiDocumentStore.bug27024_querySExists((Connection)connection, tableName, querySExists, nonNullStrings, indexName);
            Query querySExistsId = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().exists("s").build()).build();
            TestOjaiDocumentStore.bug27024_querySExists((Connection)connection, tableName, querySExistsId, nonNullStrings, indexName);
            Query querySNotExists = connection.newQuery().select(new String[]{"s"}).where(connection.newCondition().notExists("s").build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(querySNotExists);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNull((Object)s);
                    ++docCount;
                }
                Assert.assertEquals((long)(nRows - nonNullStrings), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
            }
            Query querySNotExistsId = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().notExists("s").build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(querySNotExistsId);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNull((Object)s);
                    ++docCount;
                }
                Assert.assertEquals((long)(nRows - nonNullStrings), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void test_bug27560() throws Exception {
        String rawTableName = "equals_not_all";
        this.addCleanupTable("equals_not_all");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             JsonTable table = DBTests.createOrGetTable((String)"equals_not_all");){
            DBTests.createIndex((JsonTable)table, (String)"equals_not_all_idx", (boolean)false, (int)0, (String[])new String[]{"i.a.b"}, null, null);
            String tableName = DBTests.getFullPath((String)"equals_not_all");
            this.addCleanupTable(tableName);
            try (DocumentStore docStore = connection.getStore(tableName);){
                int nGroup = 286;
                int[] iValue = new int[]{-97, -101, -201, -301, -401};
                int waitFor = 0;
                for (int i = 1; i <= 286; ++i) {
                    for (int j = 0; j < iValue.length; ++j) {
                        Document doc = connection.newDocument();
                        doc.setId("record" + j + (i - 1) * iValue.length);
                        Document aDoc = connection.newDocument();
                        aDoc.set("b", iValue[j]);
                        aDoc.set("k", "foo");
                        Document iDoc = connection.newDocument();
                        iDoc.set("a", aDoc);
                        doc.set("i", iDoc);
                        doc.set("j", j);
                        docStore.insert(doc);
                        ++waitFor;
                    }
                }
                DBTests.waitForIndexFlush((String)"equals_not_all");
                DBTests.waitForRowCount((String)"equals_not_all", (long)waitFor);
                Query query = connection.newQuery().select(new String[]{"i.a.b", "_id"}).where(connection.newCondition().and().is("i.a.b", QueryCondition.Op.EQUAL, iValue[0]).is("i.a.b", QueryCondition.Op.GREATER_OR_EQUAL, -100).close().build()).build();
                try (QueryResult docStream = docStore.find(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        int i = doc.getInt("i.a.b");
                        Assert.assertEquals((long)iValue[0], (long)i);
                        ++docCount;
                    }
                    Assert.assertEquals((long)286L, (long)docCount);
                }
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testDrill_bug27566() throws IOException {
        String rawTableName = "bug27566";
        try (JsonTable table = DBTests.createOrGetTable((String)"bug27566");){
            String tableName = DBTests.getFullPath((String)"bug27566");
            this.addCleanupTable(tableName);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 17;
                OTime theTime = new OTime(1, 20, 42, 879);
                for (int i = 1; i <= 17; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    OTime t = new OTime(theTime.getHour(), theTime.getMinute() - 8 + i, theTime.getSecond(), theTime.getMilliSecond());
                    doc.set("t", t);
                    docStore.insert(doc);
                }
                DBTests.waitForRowCount((String)"bug27566", (long)17L);
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"t", "_id"}).where(connection.newCondition().is("t", QueryCondition.Op.EQUAL, theTime).build()).build();
                try (QueryResult docStream = docStore.find(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                        OTime t = doc.getTime("t");
                        Assert.assertEquals((Object)theTime, (Object)t);
                        ++docCount;
                    }
                    Assert.assertEquals((long)1L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                }
            }
        }
    }

    @Test
    public void testStore_bug27054() throws Exception {
        String rawTableName = "bug27054_t";
        String tablePath = DBTests.getFullPath((String)"bug27054_t");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug27054_t");){
            DBTests.createIndex((JsonTable)table, (String)"bug27054_t_idx", (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            String regex = "^[a-zA-Z0-9]+.*$";
            Pattern pattern = Pattern.compile("^[a-zA-Z0-9]+.*$");
            StringGenerator valueGenerator = new StringGenerator(32, 27054L);
            int nRows = 100;
            int matchingDocs = 0;
            for (int i = 1; i <= 100; ++i) {
                Matcher matcher;
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                Object s = valueGenerator.nextUniqueString();
                if (i % 2 == 0) {
                    s = "^" + (String)s;
                }
                if ((matcher = pattern.matcher((CharSequence)s)).matches()) {
                    ++matchingDocs;
                }
                System.out.println("s = " + (String)s);
                doc.set("s", (String)s);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27054_t");
            DBTests.waitForRowCount((String)"bug27054_t", (long)100L);
            int docCount = 0;
            Query queryMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().matches("s", "^[a-zA-Z0-9]+.*$").build()).build();
            try (QueryResult matchesStream = docStore.find(queryMatches);){
                docCount = 0;
                for (Document doc : matchesStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotNull((Object)s);
                    Matcher matcher = pattern.matcher(s);
                    Assert.assertTrue((boolean)matcher.matches());
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents matched " + docCount);
                Assert.assertEquals((long)matchingDocs, (long)docCount);
            }
            Query queryNotMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().notMatches("s", "^[a-zA-Z0-9]+.*$").build()).build();
            try (QueryResult matchesStream = docStore.find(queryNotMatches);){
                docCount = 0;
                for (Document doc : matchesStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotNull((Object)s);
                    Matcher matcher = pattern.matcher(s);
                    Assert.assertTrue((!matcher.matches() ? 1 : 0) != 0);
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents notMatched " + docCount);
                Assert.assertEquals((long)(100 - matchingDocs), (long)docCount);
            }
        }
    }

    @Test
    public void testPrefixMatch() throws Exception {
        String rawTableName = "priTab";
        String tablePath = DBTests.getFullPath((String)"priTab");
        try (JsonTable table = DBTests.createOrGetTable((String)"priTab");){
            DBTests.createIndex((JsonTable)table, (String)"priTab_idx", (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            String regex = "abc[0-9]";
            Pattern pattern = Pattern.compile("abc[0-9]");
            StringGenerator valueGenerator = new StringGenerator(32, 27054L);
            int nRows = 100;
            int matchingDocs = 0;
            for (int i = 1; i <= 100; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                Object s = valueGenerator.nextUniqueString();
                if (i % 2 == 0) {
                    Random generator = new Random();
                    s = "abc" + generator.nextInt(10);
                } else {
                    s = "^" + (String)s;
                }
                Matcher matcher = pattern.matcher((CharSequence)s);
                if (matcher.matches()) {
                    ++matchingDocs;
                }
                System.out.println("s = " + (String)s);
                doc.set("s", (String)s);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"priTab");
            DBTests.waitForRowCount((String)"priTab", (long)100L);
            int docCount = 0;
            Query queryMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().matches("s", "abc[0-9]").build()).build();
            try (QueryResult matchesStream = docStore.find(queryMatches);){
                docCount = 0;
                for (Document doc : matchesStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotNull((Object)s);
                    Matcher matcher = pattern.matcher(s);
                    Assert.assertTrue((boolean)matcher.matches());
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents matched " + docCount);
                Assert.assertEquals((long)matchingDocs, (long)docCount);
            }
            Query queryNotMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().notMatches("s", "abc[0-9]").build()).build();
            try (QueryResult matchesStream = docStore.find(queryNotMatches);){
                docCount = 0;
                for (Document doc : matchesStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotNull((Object)s);
                    Matcher matcher = pattern.matcher(s);
                    Assert.assertTrue((!matcher.matches() ? 1 : 0) != 0);
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents notMatched " + docCount);
                Assert.assertEquals((long)(100 - matchingDocs), (long)docCount);
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testDrill_bug27567() throws IOException {
        String tableName;
        String rawTableName = "bug27567";
        this.addCleanupTable("bug27567");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug27567");){
            tableName = DBTests.getFullPath((String)"bug27567");
            this.addCleanupTable(tableName);
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tableName);){
            int nRows = 19;
            OTimestamp theTimestamp = new OTimestamp(2756709L);
            for (int i = 1; i <= 19; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                OTimestamp t = new OTimestamp((long)(2756691 + i));
                doc.set("t", t);
                docStore.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27567", (long)19L);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"t", "_id"}).where(connection.newCondition().is("t", QueryCondition.Op.EQUAL, theTimestamp).build()).build();
            try (QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    OTimestamp t = doc.getTimestamp("t");
                    Assert.assertEquals((Object)theTimestamp, (Object)t);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testDrill_bug27467() throws Exception {
        String rawTableName = "bug27467";
        this.addCleanupTable("bug27467");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug27467");){
            String tableName = DBTests.getFullPath((String)"bug27467");
            this.addCleanupTable(tableName);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                boolean[] useDrillOptions;
                Document doc = connection.newDocument(" {\"_id\":\"record0\",\"sl1\":{\"l1_a60_array\":[false,1.1862953200067821E38,1289709519,1.5671444844984837E308,\"qlaa|qxu|irpbkzh\",385279837858599013,\"2874730-03-17\",null,125,11641,\"06:41:47.109\",\"269616082-11-09T20:12:38.373Z\",\"/v8AdwBlAGoAaA==\",{\"key0\":false,\"key1\":3.516588262442531E37,\"key10\":\"23:50:33.829\",\"key11\":\"135990985-09-30T17:49:14.725Z\",\"key12\":\"/v8AZwBhAHsAeQ==\",\"key13\":\"/v8AZgB0AGkAdw==\",\"key2\":762072476,\"key3\":1.4561384399789896E308,\"key4\":\"gm{~nv|nwsh}nsjg\",\"key5\":2144246572548827237,\"key6\":\"3492035-04-17\",\"key7\":null,\"key8\":120,\"key9\":5716},[false,3.116079632963063E37,841854436,9.036146914887033E307,\"soamzfti~sbydo~h\",5013954358349961317,\"1422655-06-20\",null,101,15936,\"02:40:27.749\",\"275951436-08-31T15:14:54.693Z\",\"/v8AaABhAHAAYg==\",\"97855806-09-18T08:28:23.013Z\"],null]}}");
                table.insert(doc);
                DBTests.waitForRowCount((String)"bug27467", (long)1L);
                for (boolean useDrill : useDrillOptions = new boolean[]{true, false}) {
                    Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)useDrill).select(new String[]{"_id", "sl1.l1_a60_array[14][4]"}).build();
                    OjaiTest.DocumentStreamRef streamRef = new OjaiTest.DocumentStreamRef();
                    List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, streamRef);
                    Assert.assertEquals((long)1L, (long)docList.size());
                    Assert.assertEquals((Object)(useDrill ? OjaiQueryProperties.QueryPath.DRILL : OjaiQueryProperties.QueryPath.DIRECT), (Object)TestOjaiDocumentStore.getQueryPath(streamRef.docStream));
                    Document doc2 = docList.get(0);
                    String id = doc2.getIdString();
                    Assert.assertEquals((Object)"record0", (Object)id);
                    List a_list = doc2.getList("sl1.l1_a60_array");
                    Assert.assertNotNull((Object)a_list);
                    Assert.assertEquals((long)15L, (long)a_list.size());
                    for (int i = 0; i < 14; ++i) {
                        Assert.assertNull(a_list.get(i));
                    }
                    Assert.assertNotNull(a_list.get(14));
                    List subList = doc2.getList("sl1.l1_a60_array[14]");
                    Assert.assertNotNull((Object)subList);
                    Assert.assertEquals((long)5L, (long)subList.size());
                    for (int i = 0; i < 4; ++i) {
                        Assert.assertNull(subList.get(i));
                    }
                    Assert.assertNotNull(subList.get(4));
                    Assert.assertEquals((Object)"soamzfti~sbydo~h", (Object)doc2.getString("sl1.l1_a60_array[14][4]"));
                }
            }
        }
    }

    private static void bug28005QueryValue(DocumentStore docStore, String theId, Value id, QueryCondition cond) {
        Document doc = docStore.findById(id);
        OjaiTest.assertIdString(doc, theId, true);
        doc = docStore.findById(id, new String[]{"a"});
        OjaiTest.assertIdString(doc, theId, false);
        doc = docStore.findById(id, new String[]{"_id"});
        OjaiTest.assertIdString(doc, theId, true);
        doc = docStore.findById(id, cond);
        OjaiTest.assertIdString(doc, theId, true);
        doc = docStore.findById(id, cond, new String[]{"a"});
        OjaiTest.assertIdString(doc, theId, false);
        doc = docStore.findById(id, cond, new String[]{"a", "_id"});
        OjaiTest.assertIdString(doc, theId, true);
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28005() throws IOException {
        String rawTableName = "bug28005";
        this.addCleanupTable("bug28005");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug28005");){
            String tableName = DBTests.getFullPath((String)"bug28005");
            this.addCleanupTable(tableName);
            String theId = "1";
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                Document doc = connection.newDocument();
                doc.setId("1");
                doc.set("a", 1);
                table.insert(doc);
                DBTests.waitForRowCount((String)"bug28005", (long)1L);
                QueryCondition cond = connection.newCondition().is("a", QueryCondition.Op.EQUAL, 1).build();
                Document doc2 = docStore.findById("1");
                OjaiTest.assertIdString(doc2, "1", true);
                doc2 = docStore.findById("1", new String[]{"a"});
                OjaiTest.assertIdString(doc2, "1", false);
                doc2 = docStore.findById("1", new String[]{"_id"});
                OjaiTest.assertIdString(doc2, "1", true);
                doc2 = docStore.findById("1", cond);
                OjaiTest.assertIdString(doc2, "1", true);
                doc2 = docStore.findById("1", cond, new String[]{"a"});
                OjaiTest.assertIdString(doc2, "1", false);
                doc2 = docStore.findById("1", cond, new String[]{"a", "_id"});
                OjaiTest.assertIdString(doc2, "1", true);
                Value idStringValue = TestOjaiDocumentStore.getDriver().getValueBuilder().newValue("1");
                TestOjaiDocumentStore.bug28005QueryValue(docStore, "1", idStringValue, cond);
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27954() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryExists = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"*"}).where(connection.newCondition().exists("a").build()).build();
                int docCount = 0;
                try (QueryResult docStream = docStore.find(queryExists);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        int idInt = Integer.parseInt(id);
                        Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                        long a = doc.getLong("a");
                        Assert.assertEquals((long)idInt, (long)a);
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                }
                Query queryNotExists = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"*"}).where(connection.newCondition().notExists("c").build()).build();
                docCount = 0;
                try (QueryResult docStream = docStore.find(queryNotExists);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        int idInt = Integer.parseInt(id);
                        Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                        long a = doc.getLong("a");
                        Assert.assertEquals((long)idInt, (long)a);
                        String c = doc.getString("c");
                        Assert.assertNull((Object)c);
                        ++docCount;
                    }
                    Assert.assertEquals((long)2L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                }
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27259() throws Exception {
        String rawTableName = "bug27259";
        this.addCleanupTable("bug27259");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug27259");){
            String tableName = DBTests.getFullPath((String)"bug27259");
            this.addCleanupTable(tableName);
            String indexName = "bug27259_idx";
            DBTests.createIndex((JsonTable)table, (String)"bug27259_idx", (boolean)false, (int)0, (String[])new String[]{"d"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 61;
                ODate midDate = new ODate(2017, 6, 15);
                int nGreater = 0;
                Random random = new Random(27259L);
                for (int i = 1; i <= 61; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    ODate date = new ODate(2017, 1 + random.nextInt(12), 1 + random.nextInt(28));
                    doc.set("d", date);
                    if (date.compareTo(midDate) > 0) {
                        ++nGreater;
                    }
                    table.insert(doc);
                }
                DBTests.waitForIndexFlush((String)"bug27259");
                DBTests.waitForRowCount((String)"bug27259", (long)61L);
                Query query = connection.newQuery().select(new String[]{"d"}).where(connection.newCondition().is("d", QueryCondition.Op.GREATER, midDate).build()).build();
                try (QueryResult docStream = docStore.find(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                        ODate date = doc.getDate("d");
                        Assert.assertTrue((date.compareTo(midDate) > 0 ? 1 : 0) != 0);
                        ++docCount;
                    }
                    Assert.assertEquals((long)nGreater, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                    Assert.assertEquals((Object)"bug27259_idx", (Object)TestOjaiDocumentStore.getIndexUsed((DocumentStream)docStream));
                }
            }
        }
    }

    private static boolean bug27697GetDoc(Iterator<Document> docIter) {
        if (!docIter.hasNext()) {
            return false;
        }
        Document doc = docIter.next();
        String id = doc.getIdString();
        Assert.assertNotNull((Object)id);
        int i = Integer.parseInt(id);
        Assert.assertTrue((i > 0 ? 1 : 0) != 0);
        int a = doc.getInt("a");
        Assert.assertEquals((long)i, (long)a);
        return true;
    }

    private static void bug27697DoQueries(String tableName, Connection connection, OjaiQueryProperties.QueryPath queryPath) {
        int i;
        boolean gotRows;
        int limit = 2;
        Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)(queryPath == OjaiQueryProperties.QueryPath.DRILL ? 1 : 0)).limit(2L).build();
        int nIters = 5;
        DocumentStore[] docStore = new DocumentStore[5];
        DocumentStream[] docStream = new DocumentStream[5];
        ArrayList<Iterator> docIter = new ArrayList<Iterator>(5);
        int[] iterCount = new int[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            docStore[i2] = connection.getStore(tableName);
            docStream[i2] = docStore[i2].find(query);
            docIter.add(i2, docStream[i2].iterator());
        }
        do {
            gotRows = false;
            for (i = 0; i < 5; ++i) {
                if (!TestOjaiDocumentStore.bug27697GetDoc((Iterator)docIter.get(i))) continue;
                int n = i;
                iterCount[n] = iterCount[n] + 1;
                gotRows |= true;
            }
        } while (gotRows);
        for (i = 0; i < 5; ++i) {
            docStream[i].close();
            docStore[i].close();
            Assert.assertEquals((long)2L, (long)iterCount[i]);
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27697() throws Exception {
        String rawTableName = "bug27697";
        this.addCleanupTable("bug27697");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug27697");){
            String tableName = DBTests.getFullPath((String)"bug27697");
            this.addCleanupTable(tableName);
            int nRows = 3;
            for (int i = 1; i <= 3; ++i) {
                Document doc = TestOjaiDocumentStore.getDriver().newDocument();
                doc.setId(Integer.toString(i));
                doc.set("a", i);
                doc.set("b", 3 - i);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27697", (long)3L);
            Timer timer = new Timer();
            TimerTask timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    throw new RuntimeException("Queries took too long");
                }
            };
            timer.schedule(timeoutTask, 60000L);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
                TestOjaiDocumentStore.bug27697DoQueries(tableName, (Connection)connection, OjaiQueryProperties.QueryPath.DIRECT);
                TestOjaiDocumentStore.bug27697DoQueries(tableName, (Connection)connection, OjaiQueryProperties.QueryPath.DRILL);
            }
        }
    }

    private static void bug27937Query(DocumentStore docStore, Query query, boolean expectId) {
        query.build();
        try (QueryResult docStream = docStore.find(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                OjaiTest.assertIdString(doc, null, expectId);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
        }
    }

    @Test
    public void testQuery_bug27937() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            ImmutableList idList = ImmutableList.of((Object)"1", (Object)"2");
            QueryCondition condition = connection.newCondition().in("_id", (List)idList).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryPlain = connection.newQuery().where(condition);
                TestOjaiDocumentStore.bug27937Query(docStore, queryPlain, true);
                Query queryStar = connection.newQuery().where(condition).select(new String[]{"*"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryStar, true);
                Query queryStarId = connection.newQuery().where(condition).select(new String[]{"*", "_id"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryStarId, true);
                Query queryField = connection.newQuery().where(condition).select(new String[]{"b"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryField, false);
                Query queryId = connection.newQuery().where(condition).select(new String[]{"_id"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryId, true);
                Query queryFieldId = connection.newQuery().where(condition).select(new String[]{"b", "_id"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryFieldId, true);
            }
        }
    }

    @Test
    public void testQuery_bug27654() throws Exception {
        String rawTableName = "bug27654";
        this.addCleanupTable("bug27654");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             JsonTable table = DBTests.createOrGetTable((String)"bug27654");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 17;
            int evenRows = 0;
            for (int i = 1; i <= 17; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                doc.set("a", i);
                boolean isEven = i % 2 == 0;
                doc.set("isEven", isEven);
                if (isEven) {
                    ++evenRows;
                }
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27654", (long)17L);
            Assert.assertTrue((evenRows > 0 ? 1 : 0) != 0);
            Query query = connection.newQuery().where(connection.newCondition().is("isEven", QueryCondition.Op.EQUAL, true).build()).build();
            int docCount = 0;
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(query);){
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    boolean isEven = doc.getBoolean("isEven");
                    Assert.assertTrue((boolean)isEven);
                    ++docCount;
                }
                Assert.assertEquals((long)evenRows, (long)docCount);
                OjaiTest.assertQueryPath((DocumentStream)docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)"bug27654", (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
            }
        }
    }

    private static void bug28274_general_query(DocumentStore docStore, Query query, int theValue, long nRows, String indexName) {
        try (QueryResult docStream = docStore.find(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                int a = doc.getInt("a");
                int b = doc.getInt("b");
                Assert.assertEquals((long)theValue, (long)a);
                Assert.assertEquals((long)(nRows - (long)theValue), (long)b);
                String c = doc.getString("c");
                Assert.assertNotNull((Object)c);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
            Assert.assertEquals((Object)indexName, (Object)TestOjaiDocumentStore.getIndexUsed((DocumentStream)docStream));
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28274_general() throws Exception {
        String rawTableName = "bug28274_general";
        this.addCleanupTable("bug28274_general");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug28274_general");){
            String tableName = DBTests.getFullPath((String)"bug28274_general");
            this.addCleanupTable(tableName);
            String indexName = "bug28274_general_idx";
            DBTests.createIndex((JsonTable)table, (String)"bug28274_general_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 61;
                Random random = new Random(28274L);
                for (int i = 1; i <= 61; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    doc.set("a", i);
                    doc.set("b", 61 - i);
                    doc.set("c", Integer.toString(random.nextInt()));
                    table.insert(doc);
                }
                DBTests.waitForIndexFlush((String)"bug28274_general");
                DBTests.waitForRowCount((String)"bug28274_general", (long)61L);
                int theValue = 17;
                Query query = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)"bug28274_general").where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 17).is("b", QueryCondition.Op.EQUAL, 44).close().build()).build();
                TestOjaiDocumentStore.bug28274_general_query(docStore, query, 17, 61L, "bug28274_general");
                Query queryIndex = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)"bug28274_general_idx").where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 17).is("b", QueryCondition.Op.EQUAL, 44).close().build()).build();
                TestOjaiDocumentStore.bug28274_general_query(docStore, queryIndex, 17, 61L, "bug28274_general_idx");
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28274_matches_id() throws Exception {
        String rawTableName = "bug28274_matches_id";
        this.addCleanupTable("bug28274_matches_id");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug28274_matches_id");){
            String tableName = DBTests.getFullPath((String)"bug28274_matches_id");
            this.addCleanupTable(tableName);
            String indexName = "bug28274_matches_id_idx";
            DBTests.createIndex((JsonTable)table, (String)"bug28274_matches_id_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 61;
                StringGenerator stringGenerator = new StringGenerator(64, 28274L);
                boolean makeMatch = true;
                int matchCount = 0;
                for (int i = 1; i <= 61; ++i) {
                    if (makeMatch) {
                        makeMatch = false;
                    } else {
                        ++matchCount;
                        makeMatch = true;
                    }
                    Document doc = connection.newDocument();
                    String id = (makeMatch ? "xyz" : "") + stringGenerator.nextUniqueString();
                    doc.setId(id);
                    String a = (makeMatch ? "xyz" : "") + stringGenerator.nextUniqueString();
                    doc.set("a", a);
                    table.insert(doc);
                }
                Assert.assertTrue((matchCount > 0 ? 1 : 0) != 0);
                DBTests.waitForIndexFlush((String)"bug28274_matches_id");
                DBTests.waitForRowCount((String)"bug28274_matches_id", (long)61L);
                String thePattern = "^xyz.*";
                Query query = connection.newQuery().where(connection.newCondition().and().matches("_id", "^xyz.*").matches("a", "^xyz.*").close().build()).build();
                Pattern pattern = Pattern.compile("^xyz.*");
                try (QueryResult docStream = docStore.find(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Matcher idMatcher = pattern.matcher(id);
                        Assert.assertTrue((boolean)idMatcher.matches());
                        String a = doc.getString("a");
                        Matcher aMatcher = pattern.matcher(a);
                        Assert.assertTrue((boolean)aMatcher.matches());
                        ++docCount;
                    }
                    Assert.assertEquals((long)matchCount, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                }
            }
        }
    }

    private static void bug28274_project_indexed_query(DocumentStore docStore, Query query, int theValue, String indexName) {
        try (QueryResult docStream = docStore.find(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                int idInt = Integer.parseInt(id);
                Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                int a = doc.getInt("a");
                Assert.assertEquals((long)idInt, (long)a);
                Assert.assertEquals((long)theValue, (long)a);
                String aText = doc.getString("aText");
                Assert.assertNull((Object)aText);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
            Assert.assertEquals((Object)indexName, (Object)TestOjaiDocumentStore.getIndexUsed((DocumentStream)docStream));
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28274_project_indexed() throws Exception {
        String rawTableName = "bug28274_concrete";
        this.addCleanupTable("bug28274_concrete");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug28274_concrete");){
            String tableName = DBTests.getFullPath((String)"bug28274_concrete");
            this.addCleanupTable(tableName);
            String indexName = "bug28274_concrete_idx";
            DBTests.createIndex((JsonTable)table, (String)"bug28274_concrete_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 6;
                for (int i = 1; i <= 6; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    doc.set("a", i);
                    doc.set("aText", "sometext" + i);
                    table.insert(doc);
                }
                DBTests.waitForIndexFlush((String)"bug28274_concrete");
                DBTests.waitForRowCount((String)"bug28274_concrete", (long)6L);
                int theValue = 3;
                Query query = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)"bug28274_concrete").select(new String[]{"a"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 3).is("aText", QueryCondition.Op.EQUAL, "sometext3").close().build()).build();
                TestOjaiDocumentStore.bug28274_project_indexed_query(docStore, query, 3, "bug28274_concrete");
                Query queryRaw = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)"bug28274_concrete_idx").select(new String[]{"a"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 3).is("aText", QueryCondition.Op.EQUAL, "sometext3").close().build()).build();
                TestOjaiDocumentStore.bug28274_project_indexed_query(docStore, queryRaw, 3, "bug28274_concrete_idx");
            }
        }
    }

    @Test
    public void testQuery_bug28439() throws Exception {
        String rawTableName = "bug28439";
        this.addCleanupTable("bug28439");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             JsonTable table = DBTests.createOrGetTable((String)"bug28439");){
            String id;
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 2;
            for (int i = 1; i <= 2; ++i) {
                Document doc = connection.newDocument();
                String id2 = Integer.toString(i);
                doc.setId(id2);
                doc.set("a", "a" + id2);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug28439", (long)2L);
            Query query = connection.newQuery().select(new String[]{"a"}).build();
            DocumentStore docStore = connection.getStore(tableName);
            QueryResult docStream = docStore.find(query);
            Document doc1 = docStore.findById("1");
            Assert.assertNotNull((Object)doc1);
            int docCount = 0;
            for (Document doc : docStream) {
                id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath((DocumentStream)docStream, OjaiQueryProperties.QueryPath.DIRECT);
            docStream.close();
            docStore.close();
            docStore = connection.getStore(tableName);
            docStream = docStore.find(query);
            docCount = 0;
            for (Document doc : docStream) {
                id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath((DocumentStream)docStream, OjaiQueryProperties.QueryPath.DIRECT);
            DocumentMutation mutation = connection.newMutation().append("b", "_append");
            docStore.update("1", mutation);
            docStream.close();
            docStore.close();
        }
    }

    @Test(expected=StoreNotFoundException.class)
    public void testStore_bug27658() throws Exception {
        String rawTableName = "bug27658";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore documentStore = connection.getStore("bug27658");
            Assert.assertNotNull((Object)documentStore);
        }
    }

    @Test
    public void testStore_bug28161() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            Document ex4;
            String tableName = sharedTable27809.prepare((Connection)connection);
            Query query = connection.newQuery().select(new String[]{"s1"}).offset(2L).limit(2L).build();
            DocumentStore docStore = connection.getStore(tableName);
            try (QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String s1 = doc.getString("s1");
                    Assert.assertNotNull((Object)s1);
                    ++docCount;
                }
                Assert.assertEquals((long)2L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
            }
            docStore.close();
            boolean caughtEx = false;
            try {
                QueryResult docCount = docStore.find(query);
            }
            catch (TableClosedException ex2) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            caughtEx = false;
            try {
                Document ex2 = docStore.findById("1");
            }
            catch (TableClosedException ex3) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            QueryCondition condition = connection.newCondition().is("s1", QueryCondition.Op.EQUAL, "foo").build();
            caughtEx = false;
            try {
                Iterator iterator = docStore.findById("1", condition);
            }
            catch (TableClosedException ex4) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            caughtEx = false;
            try {
                ex4 = docStore.findById("1", new String[]{"s1"});
            }
            catch (TableClosedException ex5) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            caughtEx = false;
            try {
                ex4 = docStore.findById("1", condition, new String[]{"s1"});
            }
            catch (TableClosedException ex6) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
        }
    }

    @Test
    public void testStore_bug28384() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            QueryCondition condition = connection.newCondition().typeOf("s1", Value.Type.STRING).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Document docAll = docStore.findById("3");
                Assert.assertNotNull((Object)docAll);
                Document doc = docStore.findById("3", (String[])null);
                Assert.assertNotNull((Object)doc);
                doc = docStore.findById("3", condition);
                Assert.assertNotNull((Object)doc);
                doc = docStore.findById("3", condition, (String[])null);
                Assert.assertNotNull((Object)doc);
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testStore_bug28217_begin() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites(null);
            }
        }
    }

    @Test
    public void testStore_allowNullQueryCondition_MAPRDB_1543() throws Exception {
        String rawTableName = "testStore_allowNullQueryCondition_MAPRDB_1543_table";
        this.addCleanupTable("testStore_allowNullQueryCondition_MAPRDB_1543_table");
        try (JsonTable table = DBTests.createOrGetTable((String)"testStore_allowNullQueryCondition_MAPRDB_1543_table");){
            String tableName = DBTests.getFullPath((String)"testStore_allowNullQueryCondition_MAPRDB_1543_table");
            this.addCleanupTable(tableName);
            Document doc1 = MapRDBImpl.newDocument().set("a.b", "ab").set("a.c", "ac");
            Document doc2 = MapRDBImpl.newDocument().set("a.b1", "ab1").set("a.c1", "ac1");
            table.insert("key1", doc1);
            table.insert("key2", doc2);
            table.flush();
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                Document readDoc2;
                int docCount = 0;
                QueryCondition qc = null;
                DocumentStream docStream = docStore.find(qc);
                for (Document readDoc2 : docStream) {
                    switch (readDoc2.getIdString()) {
                        case "key1": {
                            ++docCount;
                            break;
                        }
                        case "key2": {
                            docCount += 2;
                            break;
                        }
                    }
                }
                Assert.assertEquals((long)3L, (long)docCount);
                docCount = 0;
                readDoc2 = docStore.findById("key1", qc);
                Assert.assertNotNull((Object)readDoc2);
                Assert.assertEquals((Object)"key1", (Object)readDoc2.getIdString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDocumentStore_buffered_writes() throws Exception {
        String test_buffered_write_table = "test_buffered_write_table";
        String test_buffered_write_table_path = DBTests.getFullPath((String)"test_buffered_write_table");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             JsonTable table = DBTests.createOrReplaceTable((String)"test_buffered_write_table");
             DocumentStore buffered_store = connection.getStore(test_buffered_write_table_path, connection.newDocument().set("ojai.mapr.documentstore.buffer-writes", true));){
            buffered_store.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":null}}"));
            DocumentStream streamWithoutFlush = table.find();
            List docs = DBTests.getAllDocumentsAndCloseStream((DocumentStream)streamWithoutFlush);
            Assert.assertEquals((long)0L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables((String[])new String[]{"test_buffered_write_table"});
            throw throwable;
        }
        DBTests.deleteTables((String[])new String[]{"test_buffered_write_table"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDocumentStore_non_buffered_writes() throws Exception {
        String test_non_buffered_write_table = "test_non_buffered_write_table";
        String test_non_buffered_write_table_path = DBTests.getFullPath((String)"test_non_buffered_write_table");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             JsonTable table = DBTests.createOrReplaceTable((String)"test_non_buffered_write_table");
             DocumentStore non_buffered_store = connection.getStore(test_non_buffered_write_table_path, connection.newDocument().set("ojai.mapr.documentstore.buffer-writes", false));){
            non_buffered_store.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":null}}"));
            DocumentStream streamWithoutFlush = table.find();
            List docs = DBTests.getAllDocumentsAndCloseStream((DocumentStream)streamWithoutFlush);
            Assert.assertEquals((long)1L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables((String[])new String[]{"test_non_buffered_write_table"});
            throw throwable;
        }
        DBTests.deleteTables((String[])new String[]{"test_non_buffered_write_table"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDocumentStore_default_non_buffered_writes() throws Exception {
        String test_non_buffered_write_table = "test_default_buffered_write_table";
        String test_non_buffered_write_table_path = DBTests.getFullPath((String)"test_default_buffered_write_table");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             JsonTable table = DBTests.createOrReplaceTable((String)"test_default_buffered_write_table");
             DocumentStore non_buffered_store = connection.getStore(test_non_buffered_write_table_path);){
            non_buffered_store.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":null}}"));
            DocumentStream streamWithoutFlush = table.find();
            List docs = DBTests.getAllDocumentsAndCloseStream((DocumentStream)streamWithoutFlush);
            Assert.assertEquals((long)1L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables((String[])new String[]{"test_default_buffered_write_table"});
            throw throwable;
        }
        DBTests.deleteTables((String[])new String[]{"test_default_buffered_write_table"});
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28195() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().select(new String[]{"*"}).where(connection.newCondition().is("_id", QueryCondition.Op.GREATER_OR_EQUAL, "1").build()).orderBy("b", SortOrder.DESC).build();
                String lastB = null;
                int docCount = 0;
                try (QueryResult docStream = docStore.find(query);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        int idInt = Integer.parseInt(id);
                        Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                        long a = doc.getLong("a");
                        Assert.assertEquals((long)idInt, (long)a);
                        String b = doc.getString("b");
                        Assert.assertTrue((OjaiTest.STRING_CMP_W_NULL.compare(b, lastB) <= 0 ? 1 : 0) != 0);
                        lastB = b;
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                }
            }
        }
    }

    @Test
    public void testQuery_bug28013() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            String rawTableName = sharedTable27024.getRawTableName();
            String indexName = sharedTable27024.getIndexName();
            long nRows = sharedTable27024.getNumRows();
            int nonNullStrings = sharedTable27024.getNonNullStrings();
            int length2Strings = sharedTable27024.getLength2Strings();
            Query querySExists = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)indexName).where(connection.newCondition().typeOf("s", Value.Type.STRING).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(querySExists);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotNull((Object)s);
                    ++docCount;
                }
                Assert.assertEquals((long)nonNullStrings, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
            }
            Query querySLength2 = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)indexName).where(connection.newCondition().sizeOf("s", QueryCondition.Op.EQUAL, 2L).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(querySLength2);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertEquals((long)2L, (long)s.length());
                    ++docCount;
                }
                Assert.assertEquals((long)length2Strings, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
            }
        }
    }

    private static void bug28361_query(Connection connection, String tableName, Query querySLength2And, String lastSizeOf2String, String indexName) {
        try (DocumentStore docStore = connection.getStore(tableName);
             QueryResult docStream = docStore.find(querySLength2And);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                String s = doc.getString("s");
                Assert.assertEquals((long)2L, (long)s.length());
                Assert.assertEquals((Object)lastSizeOf2String, (Object)s);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
        }
    }

    @Test
    public void testQuery_bug28361() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            String rawTableName = sharedTable27024.getRawTableName();
            String indexName = sharedTable27024.getIndexName();
            String lastSizeOf2String = sharedTable27024.getLastSizeOf2String();
            Query querySLength2And = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)rawTableName).where(connection.newCondition().and().sizeOf("s", QueryCondition.Op.EQUAL, 2L).is("s", QueryCondition.Op.EQUAL, lastSizeOf2String).close().build()).build();
            TestOjaiDocumentStore.bug28361_query((Connection)connection, tableName, querySLength2And, lastSizeOf2String, rawTableName);
            Query querySLength2AndIndex = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)indexName).where(connection.newCondition().and().sizeOf("s", QueryCondition.Op.EQUAL, 2L).is("s", QueryCondition.Op.EQUAL, lastSizeOf2String).close().build()).build();
            TestOjaiDocumentStore.bug28361_query((Connection)connection, tableName, querySLength2AndIndex, lastSizeOf2String, indexName);
        }
    }

    @Test
    public void testQuery_bug28715() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            int length2Strings = sharedTable27024.getLength2Strings();
            int nonNullStrings = sharedTable27024.getNonNullStrings();
            String rawTableName = sharedTable27024.getRawTableName();
            Query querySLengthNot2 = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)rawTableName).where(connection.newCondition().sizeOf("s", QueryCondition.Op.NOT_EQUAL, 2L).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(querySLengthNot2);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotEquals((long)2L, (long)s.length());
                    ++docCount;
                }
                Assert.assertEquals((long)(nonNullStrings - length2Strings), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
            }
        }
    }

    @Test
    public void testQuery_bug28350() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            String rawTableName = sharedTable27954.getRawTableName();
            Query query = connection.newQuery().select(new String[]{"*"}).where(connection.newCondition().typeOf("asdf", Value.Type.STRING).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
            }
        }
    }

    @Test
    public void testOmniTypeNotEquals() throws IOException, Exception {
        String testTable = "testtable-testOmniTableNotEquals";
        OjaiConnection connection = TestOjaiDocumentStore.getConnection();
        try (JsonTable table = DBTests.createOrReplaceTable((String)"testtable-testOmniTableNotEquals");){
            DBTests.createIndex((String)"testtable-testOmniTableNotEquals", (String)"a_idx", (String[])new String[]{"a"});
        }
        try (DocumentStore store = connection.getStore(DBTests.getFullPath((String)"testtable-testOmniTableNotEquals"));){
            store.insertOrReplace(connection.newDocument("{\"_id\":\"1\",\"a\":1}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"2\",\"a\":2.04}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"3\",\"a\":\"three\"}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"4\",\"a\":false}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"5\",\"b\":true}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"6\",\"c\":true}"));
            store.flush();
            DBTests.waitForIndexFlush((String)"testtable-testOmniTableNotEquals");
            Query q = connection.newQuery().where(connection.newCondition().is("a", QueryCondition.Op.NOT_EQUAL, 1).build()).build();
            try (QueryResult stream = store.find(q);){
                int count = 0;
                for (Document d : stream) {
                    Assert.assertNotNull((Object)d.getIdString());
                    ++count;
                }
                Assert.assertEquals((long)5L, (long)count);
            }
        }
    }

    @Test
    public void testQuery_bug28190() throws Exception {
        String rawTableName = "bug28190";
        OjaiTest.createTableAndLoad("bug28190");
        this.addCleanupTable("bug28190");
        String indexName = "bug28190_idx";
        DBTests.createIndex((String)"bug28190", (String)"bug28190_idx", (String[])new String[]{"a", "b"}, (String[])new String[]{"c"});
        DBTests.waitForRowCount((String)"bug28190", (long)16L);
        DBTests.waitForIndexFlush((String)"bug28190");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            Query query = connection.newQuery().select(new String[]{"a"}).setOption("ojai.mapr.query.hint-using-index", (Object)"bug28190_idx").where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 1).is("_id", QueryCondition.Op.NOT_EQUAL, "001").close().build()).build();
            try (JsonTable table = DBTests.createOrGetTable((String)"bug28190");){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                try (DocumentStore docStore = connection.getStore(tableName);
                     QueryResult docStream = docStore.find(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                        int a = doc.getInt("a");
                        Assert.assertEquals((long)1L, (long)a);
                        ++docCount;
                    }
                    Assert.assertEquals((long)5L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                    Assert.assertEquals((Object)"bug28190_idx", (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
                }
            }
        }
    }

    @Test
    public void testQuery_bug28384() throws Exception {
        String theId = "1";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Document doc = docStore.findById("1", (String[])null);
                Assert.assertNotNull((Object)doc);
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                String idGet = doc.getString("_id");
                Assert.assertEquals((Object)"1", (Object)idGet);
                String docString = doc.toString();
                Assert.assertTrue((boolean)docString.contains("_id"));
            }
        }
    }

    @Test
    public void testQuery_bug28534() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            long rowCount = sharedTable27809.getNumRows();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryNotExists = connection.newQuery().where(connection.newCondition().notExists(DocumentConstants.ID_FIELD).build()).build();
                try (QueryResult docStream = docStore.find(queryNotExists);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        ++docCount;
                    }
                    Assert.assertEquals((long)0L, (long)docCount);
                }
                Query queryExists = connection.newQuery().where(connection.newCondition().exists(DocumentConstants.ID_FIELD).build()).build();
                try (QueryResult docStream = docStore.find(queryExists);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        ++docCount;
                    }
                    Assert.assertEquals((long)rowCount, (long)docCount);
                }
            }
        }
    }

    public void testQuery_bug28953() throws Exception {
        String rawTableName = "bug28953";
        int numZeros = 0;
        this.addCleanupTable("bug28953");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String indexName;
            String tableName;
            int nPartition = 32;
            int theMultiple = 2;
            int nRows = 64;
            try (JsonTable table = DBTests.createOrGetTable((String)"bug28953");){
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                for (int i = 1; i <= 64; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    doc.set("a", "a" + (String)id);
                    doc.set("b", 64 - i);
                    int c = i % 2;
                    doc.set("c", c);
                    if (c == 0) {
                        ++numZeros;
                    }
                    table.insert(doc);
                }
                indexName = "bug28953_c_hidx";
                DBTests.createIndex((JsonTable)table, (String)indexName, (boolean)true, (int)32, (String[])new String[]{"c"}, null, (String[])new String[]{"b"});
            }
            DBTests.waitForRowCount((String)"bug28953", (long)64L);
            DBTests.waitForIndexFlush((String)"bug28953");
            Query query = connection.newQuery().select(new String[]{"b"}).where(connection.newCondition().is("c", QueryCondition.Op.EQUAL, 0).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 QueryResult docStream = docStore.find(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    int b = doc.getInt("b");
                    Assert.assertTrue((b <= 64 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)numZeros, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
                String queryPlanString = OjaiDocumentStore.queryPlanToString(OjaiTest.getQueryPlan((DocumentStream)docStream));
                Assert.assertTrue((String)queryPlanString, (boolean)queryPlanString.contains(UnionDocumentStream.class.getSimpleName()));
            }
        }
    }

    @Test
    public void testMultiGet() throws IOException {
        String tablePath = DBTests.getFullPath((String)MULTIGET_TABLE);
        JsonTable table = DBTests.createOrGetTable((String)MULTIGET_TABLE);
        if (table != null) {
            table.close();
        }
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            BaseJsonTable jsonTable = table2;
            int numDocuments = 30000;
            for (int i = 0; i < numDocuments; ++i) {
                Document document = connection.newDocument();
                document.set("_id", "key" + i).set("a", "a" + i).set("b", i).set("c", "c" + i);
                table2.insert(document);
            }
            table2.flush();
            ByteBuffer[] ids = new ByteBuffer[numDocuments];
            for (int i = 0; i < numDocuments; ++i) {
                ids[i] = IdCodec.encode((String)("key" + i));
            }
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)numDocuments, (long)docList.size());
            for (int i = 0; i < numDocuments; ++i) {
                Assert.assertEquals((Object)("a" + i), (Object)((Document)docList.get(i)).getString("a"));
            }
            ConditionImpl condition = MapRDBImpl.newCondition().is("b", QueryCondition.Op.LESS, 100L).build();
            multiGet = new MultiGet(jsonTable, (QueryCondition)condition, jsonTable.isExcludeId(), new String[]{"c"});
            docList = multiGet.doGet(ids);
            Assert.assertEquals((long)100L, (long)docList.size());
            for (int i = 0; i < 100; ++i) {
                Assert.assertEquals(null, (Object)((Document)docList.get(i)).getString("a"));
                Assert.assertEquals(null, (Object)((Document)docList.get(i)).getString("b"));
                Assert.assertEquals((Object)("c" + i), (Object)((Document)docList.get(i)).getString("c"));
            }
        }
    }

    @Ignore(value="MAPRDB-375")
    @Test
    public void testQuery_6SampleIndexUsage() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable6SampleIndexUsage.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query qaDotb1 = connection.newQuery().where(connection.newCondition().is("a.b", QueryCondition.Op.EQUAL, 1).build());
                OjaiTest.simpleQueryCheck(docStore, qaDotb1, (Set<String>)ImmutableSet.of((Object)"1"), "aDotb_idx");
                Query qaDotb2 = connection.newQuery().where(connection.newCondition().is("a.b", QueryCondition.Op.GREATER, 0).build());
                OjaiTest.simpleQueryCheck(docStore, qaDotb2, (Set<String>)ImmutableSet.of((Object)"1"), "aDotb_idx");
                ImmutableList qaDotb3_list = ImmutableList.of((Object)1, (Object)2, (Object)3);
                Query qaDotb3 = connection.newQuery().where(connection.newCondition().equals("a.b", (List)qaDotb3_list).build());
                OjaiTest.simpleQueryCheck(docStore, qaDotb3, (Set<String>)ImmutableSet.of((Object)"2"), "aDotb_idx");
                Query qaDotbArray1 = connection.newQuery().where(connection.newCondition().is("a.b[]", QueryCondition.Op.EQUAL, 1).build());
                OjaiTest.simpleQueryCheck(docStore, qaDotbArray1, (Set<String>)ImmutableSet.of((Object)"1", (Object)"2"), "aDotbArray_idx");
                Query qaDotbArray2 = connection.newQuery().where(connection.newCondition().equals("a.b", (List)qaDotb3_list).build());
                OjaiTest.simpleQueryCheck(docStore, qaDotbArray2, (Set<String>)ImmutableSet.of((Object)"2"), "aDotbArray_idx");
                Query qaArrayDotb1 = connection.newQuery().where(connection.newCondition().is("a[].b", QueryCondition.Op.EQUAL, 1).build());
                OjaiTest.simpleQueryCheck(docStore, qaArrayDotb1, (Set<String>)ImmutableSet.of((Object)"1", (Object)"3"), "aArrayDotb_idx");
                Query qaArrayDotb2 = connection.newQuery().where(connection.newCondition().equals("a[].b", (List)qaDotb3_list).build());
                OjaiTest.simpleQueryCheck(docStore, qaArrayDotb2, (Set<String>)ImmutableSet.of((Object)"2", (Object)"4"), "aArrayDotb_idx");
                Query qaArrayDotbArray1 = connection.newQuery().where(connection.newCondition().is("a[].b", QueryCondition.Op.EQUAL, 1).build());
                OjaiTest.simpleQueryCheck(docStore, qaArrayDotbArray1, (Set<String>)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"), "aArrayDotbAray_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req002_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req002_1 = connection.newQuery().where(connection.newCondition().is("REQ_002_tags[]", QueryCondition.Op.EQUAL, "ipod").build());
        ImmutableSet req002_1_ids = ImmutableSet.of((Object)"REQ_002_001", (Object)"REQ_002_002", (Object)"REQ_002_004");
        OjaiTest.simpleQueryCheck(docStore, req002_1, (Set<String>)req002_1_ids, useIndex);
        Query req002_2 = connection.newQuery().where(connection.newCondition().is("REQ_002_tags[]", QueryCondition.Op.EQUAL, 10).build());
        ImmutableSet req002_2_ids = ImmutableSet.of((Object)"REQ_002_003", (Object)"REQ_002_004", (Object)"REQ_002_007");
        OjaiTest.simpleQueryCheck(docStore, req002_2, (Set<String>)req002_2_ids, useIndex);
        Query req002_3 = connection.newQuery().where(connection.newCondition().and().is("REQ_002_tags[]", QueryCondition.Op.GREATER, 10).is("REQ_002_tags[]", QueryCondition.Op.LESS, 18).close().build());
        ImmutableSet req002_3_ids = ImmutableSet.of((Object)"REQ_002_007");
        OjaiTest.simpleQueryCheck(docStore, req002_3, (Set<String>)req002_3_ids, useIndex);
        Query req002_4 = connection.newQuery().where(connection.newCondition().and().is("REQ_002_tags[]", QueryCondition.Op.GREATER_OR_EQUAL, 10).is("REQ_002_tags[]", QueryCondition.Op.LESS_OR_EQUAL, 18).close().build());
        ImmutableSet req002_4_ids = ImmutableSet.of((Object)"REQ_002_003", (Object)"REQ_002_004", (Object)"REQ_002_007");
        OjaiTest.simpleQueryCheck(docStore, req002_4, (Set<String>)req002_4_ids, useIndex);
        Query req002_5 = connection.newQuery().where(connection.newCondition().and().is("REQ_002_tags[]", QueryCondition.Op.EQUAL, 10).is("REQ_002_tags[]", QueryCondition.Op.EQUAL, 18).close().build());
        ImmutableSet req002_5_ids = ImmutableSet.of((Object)"REQ_002_007");
        OjaiTest.simpleQueryCheck(docStore, req002_5, (Set<String>)req002_5_ids, useIndex);
        Query req002_6 = connection.newQuery().where(connection.newCondition().or().is("REQ_002_tags[]", QueryCondition.Op.EQUAL, 10).is("REQ_002_tags[]", QueryCondition.Op.EQUAL, 18).close().build());
        ImmutableSet req002_6_ids = ImmutableSet.of((Object)"REQ_002_003", (Object)"REQ_002_004", (Object)"REQ_002_007");
        OjaiTest.simpleQueryCheck(docStore, req002_6, (Set<String>)req002_6_ids, null);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req002() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req002_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String indexName = "REQ_002_tagsArray_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_002_tagsArray_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_002_tags[]"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req002_queries((Connection)connection, docStore, "REQ_002_tagsArray_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req004_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req004_1 = connection.newQuery().where(connection.newCondition().is("REQ_004_tags[].t", QueryCondition.Op.EQUAL, "ipod").build());
        ImmutableSet req004_1_ids = ImmutableSet.of((Object)"REQ_004_004", (Object)"REQ_004_005", (Object)"REQ_004_006", (Object)"REQ_004_007", (Object)"REQ_004_008");
        OjaiTest.simpleQueryCheck(docStore, req004_1, (Set<String>)req004_1_ids, useIndex);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req004() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req004_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String indexName = "REQ_004_tagsArrayDott_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_004_tagsArrayDott_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_004_tags[].t"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req004_queries((Connection)connection, docStore, "REQ_004_tagsArrayDott_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req005_queries(Connection connection, DocumentStore docStore, String useIndex) {
        ImmutableMap req005_1_map = ImmutableMap.of((Object)"t", (Object)"ipod");
        Query req005_1 = connection.newQuery().where(connection.newCondition().equals("REQ_005_tags[]", (Map)req005_1_map).build());
        ImmutableSet req005_1_ids = ImmutableSet.of((Object)"REQ_005_004", (Object)"REQ_005_005", (Object)"REQ_005_006");
        OjaiTest.simpleQueryCheck(docStore, req005_1, (Set<String>)req005_1_ids, useIndex);
        ImmutableMap req005_2_map = ImmutableMap.of((Object)"t", (Object)"ipod", (Object)"v", (Object)10);
        Query req005_2 = connection.newQuery().where(connection.newCondition().equals("REQ_005_tags[]", (Map)req005_2_map).build());
        ImmutableSet req005_2_ids = ImmutableSet.of((Object)"REQ_005_007", (Object)"REQ_005_008");
        TestOjaiDocumentStore.simpleQueryCheck(docStore, req005_2, (Set<String>)req005_2_ids, useIndex);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req005() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req005_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String indexName = "REQ_005_tagsArray_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_005_tagsArray_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_005_tags[]"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req005_queries((Connection)connection, docStore, "REQ_005_tagsArray_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req006_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req006_1 = connection.newQuery().where(connection.newCondition().and().is("REQ_006_grades[].dsc", QueryCondition.Op.EQUAL, "history").is("REQ_006_grades[].ev", QueryCondition.Op.EQUAL, 12).close().build());
        ImmutableSet req006_1_ids = ImmutableSet.of((Object)"REQ_006_001", (Object)"REQ_006_002", (Object)"REQ_006_003", (Object)"REQ_006_004", (Object)"REQ_006_005");
        OjaiTest.simpleQueryCheck(docStore, req006_1, (Set<String>)req006_1_ids, useIndex);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req006() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req006_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String dscIndexName = "REQ_006_gradesArrayDotdsc_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_006_gradesArrayDotdsc_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_006_grades[].dsc"}, null, null);
                String evIndexName = "REQ_006_gradesArrayDotev_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_006_gradesArrayDotev_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_006_grades[].ev"}, null, null);
                String dscevIndexName = "REQ_006_gradesArrayDotdscev_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_006_gradesArrayDotdscev_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_006_grades[].dsc", "REQ_006_grades[].ev"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req006_queries((Connection)connection, docStore, "REQ_006_gradesArrayDotdsc_idx");
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req006_queries((Connection)connection, docStore, "REQ_006_gradesArrayDotev_idx");
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req006_queries((Connection)connection, docStore, "REQ_006_gradesArrayDotdscev_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req007_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req007_1 = connection.newQuery().where(connection.newCondition().elementAnd("REQ_007_grades[]").is("dsc", QueryCondition.Op.EQUAL, "history").is("ev", QueryCondition.Op.EQUAL, 12).close().build());
        ImmutableSet req007_1_ids = ImmutableSet.of((Object)"REQ_007_001", (Object)"REQ_007_002", (Object)"REQ_007_004");
        OjaiTest.simpleQueryCheck(docStore, req007_1, (Set<String>)req007_1_ids, useIndex);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req007() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req007_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String dscIndexName = "REQ_007_gradesArrayDotdsc_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_007_gradesArrayDotdsc_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_007_grades[].dsc"}, null, null);
                String evIndexName = "REQ_007_gradesArrayDotev_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_007_gradesArrayDotev_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_007_grades[].ev"}, null, null);
                String dscevIndexName = "REQ_007_gradesArrayDotdscev_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_007_gradesArrayDotdscev_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_007_grades[].dsc", "REQ_007_grades[].ev"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req007_queries((Connection)connection, docStore, "REQ_007_gradesArrayDotdsc_idx");
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req007_queries((Connection)connection, docStore, "REQ_007_gradesArrayDotev_idx");
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req007_queries((Connection)connection, docStore, "REQ_007_gradesArrayDotdscev_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req008_queries(Connection connection, DocumentStore docStore, String useIndex) {
        ImmutableList req008_1_list = ImmutableList.of((Object)"apple", (Object)"ipod");
        Query req008_1 = connection.newQuery().where(connection.newCondition().equals("REQ_008_tags", (List)req008_1_list).build());
        ImmutableSet req008_1_ids = ImmutableSet.of((Object)"REQ_008_014");
        OjaiTest.simpleQueryCheck(docStore, req008_1, (Set<String>)req008_1_ids, null);
        ImmutableList req008_2_list = ImmutableList.of((Object)"ipod", (Object)"apple");
        Query req008_2 = connection.newQuery().where(connection.newCondition().equals("REQ_008_tags", (List)req008_2_list).build());
        ImmutableSet req008_2_ids = ImmutableSet.of((Object)"REQ_008_011", (Object)"REQ_008_015");
        OjaiTest.simpleQueryCheck(docStore, req008_2, (Set<String>)req008_2_ids, null);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req008() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req008_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String indexName = "REQ_008_tags_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_008_tags_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_008_tags"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req008_queries((Connection)connection, docStore, "REQ_008_tags_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req009_queries(Connection connection, DocumentStore docStore, String useIndex) {
        ImmutableList req009_1_list = ImmutableList.of((Object)ImmutableMap.of((Object)"t", (Object)"ipod", (Object)"v", (Object)5), (Object)ImmutableMap.of((Object)"t", (Object)"apple", (Object)"v", (Object)10));
        Query req009_1 = connection.newQuery().where(connection.newCondition().equals("REQ_009_tags", (List)req009_1_list).build());
        ImmutableSet req009_1_ids = ImmutableSet.of((Object)"REQ_009_021", (Object)"REQ_009_025");
        OjaiTest.simpleQueryCheck(docStore, req009_1, (Set<String>)req009_1_ids, null);
        ImmutableList req009_2_list = ImmutableList.of((Object)ImmutableMap.of((Object)"t", (Object)"apple", (Object)"v", (Object)10), (Object)ImmutableMap.of((Object)"t", (Object)"ipod", (Object)"v", (Object)5));
        Query req009_2 = connection.newQuery().where(connection.newCondition().equals("REQ_009_tags", (List)req009_2_list).build());
        ImmutableSet req009_2_ids = ImmutableSet.of((Object)"REQ_009_024");
        OjaiTest.simpleQueryCheck(docStore, req009_2, (Set<String>)req009_2_ids, null);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req009() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req009_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String indexName = "REQ_009_tags_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_009_tags_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_009_tags"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req009_queries((Connection)connection, docStore, "REQ_009_tags_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req010_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req010_1 = connection.newQuery().where(connection.newCondition().and().is("REQ_010_tags[]", QueryCondition.Op.EQUAL, "ipod").is("REQ_010_tags[]", QueryCondition.Op.EQUAL, "apple").close().build());
        ImmutableSet req010_1_ids = ImmutableSet.of((Object)"REQ_010_010", (Object)"REQ_010_011", (Object)"REQ_010_014", (Object)"REQ_010_015");
        OjaiTest.simpleQueryCheck(docStore, req010_1, (Set<String>)req010_1_ids, null);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req010() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req010_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String indexName = "REQ_010_tagsArray_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_010_tagsArray_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_010_tags[]"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req010_queries((Connection)connection, docStore, "REQ_010_tagsArray_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req011_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req011_1 = connection.newQuery().where(connection.newCondition().and().is("REQ_011_tags[].t", QueryCondition.Op.EQUAL, "ipod").is("REQ_011_tags[].t", QueryCondition.Op.EQUAL, "apple").close().build());
        ImmutableSet req011_1_ids = ImmutableSet.of((Object)"REQ_011_020", (Object)"REQ_011_021", (Object)"REQ_011_024", (Object)"REQ_011_025", (Object)"REQ_011_026");
        OjaiTest.simpleQueryCheck(docStore, req011_1, (Set<String>)req011_1_ids, null);
        Query req011_2 = connection.newQuery().where(connection.newCondition().and().is("REQ_011_tags[].v", QueryCondition.Op.EQUAL, 5).is("REQ_011_tags[].v", QueryCondition.Op.EQUAL, 30).close().build());
        ImmutableSet req011_2_ids = ImmutableSet.of((Object)"REQ_011_026");
        OjaiTest.simpleQueryCheck(docStore, req011_2, (Set<String>)req011_2_ids, null);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req011() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req011_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String tIndexName = "REQ_011_tagsArrayDott_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_011_tagsArrayDott_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_011_tags[].t"}, null, null);
                String vIndexName = "REQ_011_tagsArrayDotv_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_011_tagsArrayDotv_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_011_tags[].v"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req011_queries((Connection)connection, docStore, "REQ_011_tagsArrayDott_idx");
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req011_queries((Connection)connection, docStore, "REQ_011_tagsArrayDotv_idx");
            }
        }
    }

    private static void testQuery_listComplexTypesQueries_req012_queries(Connection connection, DocumentStore docStore, String useIndex) {
        Query req012_1 = connection.newQuery().where(connection.newCondition().is("REQ_012_projects[].customer.contacts[].emails[].value", QueryCondition.Op.EQUAL, "jdoe@gmail.com").build());
        ImmutableSet req012_1_ids = ImmutableSet.of((Object)"REQ_012_account001");
        OjaiTest.simpleQueryCheck(docStore, req012_1, (Set<String>)req012_1_ids, null);
        Query req012_2 = connection.newQuery().where(connection.newCondition().is("REQ_012_projects[].customer.contacts[].role", QueryCondition.Op.EQUAL, "CEO").build());
        ImmutableSet req012_2_ids = ImmutableSet.of((Object)"REQ_012_account001");
        OjaiTest.simpleQueryCheck(docStore, req012_2, (Set<String>)req012_2_ids, null);
    }

    @Test
    public void testQuery_listComplexTypesQueries_req012() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTableListComplexTypesQueries.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req012_queries((Connection)connection, docStore, null);
                BaseJsonTable table = ((OjaiDocumentStore)docStore).getTable();
                String valueIndexName = "REQ_012_value_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_012_value_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_012_projects[].customer.contacts[].emails[].value"}, null, null);
                String roleIndexName = "REQ_012_role_idx";
                DBTests.createIndex((JsonTable)table, (String)"REQ_012_role_idx", (boolean)false, (int)0, (String[])new String[]{"REQ_012_projects[].customer.contacts[].role"}, null, null);
                DBTests.waitForIndexFlush((String)sharedTableListComplexTypesQueries.getRawTableName());
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req012_queries((Connection)connection, docStore, "REQ_012_value_idx");
                TestOjaiDocumentStore.testQuery_listComplexTypesQueries_req012_queries((Connection)connection, docStore, "REQ_012_role_idx");
            }
        }
    }

    @Test
    public void testQuery_bug19800_match() throws Exception {
        String rawTableName = "bug19800_match";
        OjaiTest.loadTable("bug19800_match");
        String fullTableName = DBTests.getFullPath((String)"bug19800_match");
        String expectedId = "stand_credit#default#fma#99994801#bin_validation";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(fullTableName);){
            Query q = connection.newQuery().where(connection.newCondition().matches("placeHolders.placeholder_1[]", "49433[0-9]").build()).build();
            try (QueryResult docStream = docStore.find(q);){
                int count = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)"stand_credit#default#fma#99994801#bin_validation", (Object)id);
                    ++count;
                }
                Assert.assertEquals((long)1L, (long)count);
            }
        }
    }

    public static abstract class Bug27711 {
        public static final int NROWS = 83;
        protected static final int BOUND = 100;
        protected int rowCount = 0;
        protected final Random random = new Random(27711L);

        public String getRawTableName() {
            String className = this.getClass().getName();
            return className.substring(className.lastIndexOf(36) + 1) + "_t";
        }

        private void testQuery(Connection connection, String rawTableName, String fieldName, QueryCondition.Op op, Direction dir, DocumentStore docStore) {
            QueryCondition condGt = connection.newCondition();
            this.setCondition(fieldName, condGt, op, dir);
            Query queryGt = connection.newQuery().select(new String[]{fieldName + dir.getSuffix(), "_id"}).where(condGt.build()).build();
            try (QueryResult docStream = docStore.find(queryGt);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    this.assertCmp(doc, fieldName, op, dir);
                    ++docCount;
                }
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath((DocumentStream)docStream));
                Assert.assertEquals((long)41L, (long)docCount);
                String indexName = rawTableName + dir.getSuffix() + "_idx";
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
            }
        }

        public void testQueries(Connection connection, String rawTableName, String fieldName, Direction dir, DocumentStore docStore) {
            this.testQuery(connection, rawTableName, fieldName, QueryCondition.Op.GREATER, dir, docStore);
            this.testQuery(connection, rawTableName, fieldName, QueryCondition.Op.LESS, dir, docStore);
        }

        public abstract void setDocFields(Document var1, String var2);

        public abstract void doneInserting();

        public abstract void setCondition(String var1, QueryCondition var2, QueryCondition.Op var3, Direction var4);

        public abstract void assertCmp(Document var1, String var2, QueryCondition.Op var3, Direction var4);

        public static enum Direction {
            ASC(0, "_asc"),
            DESC(1, "_desc");

            private final int v;
            private final String suffix;

            private Direction(int v, String suffix) {
                this.v = v;
                this.suffix = suffix;
            }

            public int getIndex() {
                return this.v;
            }

            public String getSuffix() {
                return this.suffix;
            }
        }
    }

    private static class SharedTable27809
    extends SharedTestTable {
        private String indexName;

        public SharedTable27809() {
            super("bug27809");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_idx";
                DBTests.createIndex((JsonTable)table, (String)(rawTableName + "_idx"), (boolean)false, (int)0, (String[])new String[]{"s1"}, null, null);
                StringGenerator stringGenerator = new StringGenerator(32, 27809L);
                int nRows = (int)this.getNumRows();
                for (int i = 1; i <= nRows; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    String s1 = stringGenerator.nextUniqueString();
                    doc.set("s1", s1);
                    table.insert(doc);
                }
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 17L;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    private static class SharedTable27024
    extends SharedTestTable {
        private final int nRows = 17;
        private int nonNullStrings;
        private String indexName = null;
        private int length2Strings;
        private String lastSizeOf2String;

        public SharedTable27024() {
            super("bug27024");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_idx";
                DBTests.createIndex((JsonTable)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
                this.nonNullStrings = 0;
                this.length2Strings = 0;
                this.lastSizeOf2String = null;
                StringGenerator stringGenerator = new StringGenerator(32, 27024L);
                for (int i = 1; i <= 17; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    doc.set("i", i);
                    if (i % 2 == 0) {
                        ++this.nonNullStrings;
                        String s = stringGenerator.nextUniqueString();
                        if (this.lastSizeOf2String == null) {
                            s = s.substring(0, 2);
                        }
                        if (s.length() == 2) {
                            ++this.length2Strings;
                            this.lastSizeOf2String = s;
                        }
                        doc.set("s", s);
                    }
                    table.insert(doc);
                }
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 17L;
        }

        public int getNonNullStrings() {
            return this.nonNullStrings;
        }

        public int getLength2Strings() {
            return this.length2Strings;
        }

        public String getLastSizeOf2String() {
            return this.lastSizeOf2String;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    private static class SharedTable6SampleIndexUsage
    extends SharedTestTable {
        public static final String aDotbName = "aDotb_idx";
        public static final String aDotbArrayName = "aDotbArray_idx";
        public static final String aArrayDotbName = "aArrayDotb_idx";
        public static final String aArrayDotbArrayName = "aArrayDotbAray_idx";

        public SharedTable6SampleIndexUsage() {
            super("test6SampleIndexUsage");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                String fileName = SharedTestTable.removeTrialSuffix(rawTableName);
                OjaiTest.loadTable(fileName);
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 4L;
        }
    }

    private static class SharedTableListComplexTypesQueries
    extends SharedTestTable {
        public SharedTableListComplexTypesQueries() {
            super("testListComplexTypesQueries");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                String fileName = SharedTestTable.removeTrialSuffix(rawTableName);
                OjaiTest.loadTable((Table)table, fileName);
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 59L;
        }
    }

    private static class Bug27711Float
    extends Bug27711 {
        private static final float[][] value = new float[2][83];
        private final float[] mid = new float[2];

        @Override
        public void setDocFields(Document doc, String fieldName) {
            float v1;
            float v0;
            Bug27711Float.value[Bug27711.Direction.ASC.getIndex()][this.rowCount] = v0 = 100.0f * this.random.nextFloat();
            doc.set(fieldName + Bug27711.Direction.ASC.getSuffix(), v0);
            Bug27711Float.value[Bug27711.Direction.DESC.getIndex()][this.rowCount] = v1 = 100.0f * this.random.nextFloat();
            doc.set(fieldName + Bug27711.Direction.DESC.getSuffix(), v1);
            ++this.rowCount;
        }

        @Override
        public void doneInserting() {
            for (int i = 0; i < 2; ++i) {
                Arrays.sort(value[i]);
                this.mid[i] = value[i][this.rowCount / 2];
            }
        }

        @Override
        public void setCondition(String fieldName, QueryCondition cond, QueryCondition.Op op, Bug27711.Direction dir) {
            cond.is(fieldName + dir.getSuffix(), op, this.mid[dir.getIndex()]);
        }

        @Override
        public void assertCmp(Document doc, String fieldName, QueryCondition.Op op, Bug27711.Direction dir) {
            float v = doc.getFloat(fieldName + dir.getSuffix());
            switch (op) {
                case GREATER: {
                    Assert.assertTrue((v > this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                case LESS: {
                    Assert.assertTrue((v < this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("no case for " + op);
                }
            }
        }
    }

    private static class Bug27711Int
    extends Bug27711 {
        private static final int[][] value = new int[2][83];
        private final int[] mid = new int[2];

        @Override
        public void setDocFields(Document doc, String fieldName) {
            int v1;
            int v0;
            Bug27711Int.value[Bug27711.Direction.ASC.getIndex()][this.rowCount] = v0 = 100 - this.random.nextInt(200);
            doc.set(fieldName + Bug27711.Direction.ASC.getSuffix(), v0);
            Bug27711Int.value[Bug27711.Direction.DESC.getIndex()][this.rowCount] = v1 = 100 - this.random.nextInt(200);
            doc.set(fieldName + Bug27711.Direction.DESC.getSuffix(), v1);
            ++this.rowCount;
        }

        @Override
        public void doneInserting() {
            for (int i = 0; i < 2; ++i) {
                Arrays.sort(value[i]);
                this.mid[i] = value[i][this.rowCount / 2];
            }
        }

        @Override
        public void setCondition(String fieldName, QueryCondition cond, QueryCondition.Op op, Bug27711.Direction dir) {
            cond.is(fieldName + dir.getSuffix(), op, this.mid[dir.getIndex()]);
        }

        @Override
        public void assertCmp(Document doc, String fieldName, QueryCondition.Op op, Bug27711.Direction dir) {
            int v = doc.getInt(fieldName + dir.getSuffix());
            switch (op) {
                case GREATER: {
                    Assert.assertTrue((v > this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                case LESS: {
                    Assert.assertTrue((v < this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("no case for " + op);
                }
            }
        }
    }

    private static class Bug27711String
    extends Bug27711 {
        private static final String[][] value = new String[2][83];
        private final String[] mid = new String[2];
        private final StringGenerator stringGenerator = new StringGenerator(32, 27711L);

        @Override
        public void setDocFields(Document doc, String fieldName) {
            String v1;
            String v0;
            Bug27711String.value[Bug27711.Direction.ASC.getIndex()][this.rowCount] = v0 = this.stringGenerator.nextUniqueString();
            doc.set(fieldName + Bug27711.Direction.ASC.getSuffix(), v0);
            Bug27711String.value[Bug27711.Direction.DESC.getIndex()][this.rowCount] = v1 = this.stringGenerator.nextUniqueString();
            doc.set(fieldName + Bug27711.Direction.DESC.getSuffix(), v1);
            ++this.rowCount;
        }

        @Override
        public void doneInserting() {
            for (int i = 0; i < 2; ++i) {
                Arrays.sort(value[i]);
                this.mid[i] = value[i][this.rowCount / 2];
            }
        }

        @Override
        public void setCondition(String fieldName, QueryCondition cond, QueryCondition.Op op, Bug27711.Direction dir) {
            cond.is(fieldName + dir.getSuffix(), op, this.mid[dir.getIndex()]);
        }

        @Override
        public void assertCmp(Document doc, String fieldName, QueryCondition.Op op, Bug27711.Direction dir) {
            String v = doc.getString(fieldName + dir.getSuffix());
            switch (op) {
                case GREATER: {
                    Assert.assertTrue((v.compareTo(this.mid[dir.getIndex()]) > 0 ? 1 : 0) != 0);
                    break;
                }
                case LESS: {
                    Assert.assertTrue((v.compareTo(this.mid[dir.getIndex()]) < 0 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("no case for " + op);
                }
            }
        }
    }
}

