/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.ContinuationListener;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedDrillSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillPreludeFilter
extends AbstractDocumentFilter {
    private static final Logger logger = LoggerFactory.getLogger(DrillPreludeFilter.class);
    private final OjaiConnection ojaiConnection;
    private final String sql;
    private final SharedDrillSession sharedDrillSession;
    private volatile DrillDocumentStream drillStream;
    volatile Exception failedException;
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private final int id = idGenerator.addAndGet(1);

    public DrillPreludeFilter(DocumentStream upstreamStream, OjaiConnection ojaiConnection, SharedDrillSession sharedDrillSession, String sql) {
        super(upstreamStream);
        Preconditions.checkArgument((sql != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sharedDrillSession != null ? 1 : 0) != 0);
        this.ojaiConnection = ojaiConnection;
        this.sql = sql;
        this.sharedDrillSession = sharedDrillSession;
        sharedDrillSession.addRef();
    }

    private void executeDrillStatement() {
        logger.debug("Drill prelude " + this.id + " sql " + this.sql);
        CountDownLatch continuationLatch = new CountDownLatch(1);
        QueryContext queryContext = QueryContext.newBuilder(this.sql).build();
        this.drillStream = new DrillDocumentStream(this.ojaiConnection, queryContext, this.sharedDrillSession);
        this.drillStream.streamTo(new ContinuationListener(continuationLatch){

            @Override
            public void failed(Exception ex) {
                DrillPreludeFilter.this.failedException = ex;
                super.failed(ex);
            }
        });
        try {
            continuationLatch.await();
        }
        catch (InterruptedException ie) {
            this.failedException = ie;
        }
        if (this.failedException != null) {
            throw new OjaiException((Throwable)this.failedException);
        }
    }

    @Override
    public Iterator<Document> iterator() {
        this.executeDrillStatement();
        return super.iterator();
    }

    @Override
    protected void closeDerived() {
        if (this.drillStream != null) {
            this.drillStream.close();
        }
        this.sharedDrillSession.close();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("sql", this.sql);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

