/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.ReaderPathBuilder;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.util.DocumentReaderWithProjection;
import org.ojai.util.FieldProjector;

public class DocumentFlattener {
    private DocumentFlattener() {
    }

    public static void addToMap(Map<String, Value> map, Document doc, FieldProjector fieldProjector) {
        DocumentReader.EventType eventType;
        ReaderPathBuilder pathBuilder = new ReaderPathBuilder();
        DocumentReaderWithProjection docReader = new DocumentReaderWithProjection(doc.asReader(), fieldProjector);
        while ((eventType = docReader.next()) != null) {
            Value value = null;
            switch (eventType) {
                case START_MAP: {
                    pathBuilder.startMap((DocumentReader)docReader);
                    break;
                }
                case END_MAP: {
                    pathBuilder.endMap();
                    break;
                }
                case START_ARRAY: {
                    pathBuilder.startArray((DocumentReader)docReader);
                    break;
                }
                case END_ARRAY: {
                    pathBuilder.endArray();
                    break;
                }
                default: {
                    value = ReaderPathBuilder.getValue((DocumentReader)docReader);
                }
            }
            if (value == null) continue;
            String fieldName = pathBuilder.pushField((DocumentReader)docReader);
            map.put(fieldName, value);
            pathBuilder.popField();
        }
    }
}

